/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.client.model;

import com.github.teamfossilsarcheology.fossil.FossilMod;
import com.github.teamfossilsarcheology.fossil.client.model.AdditiveAnimationModel;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.Prehistoric;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricFlying;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricSwimming;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.swimming.Trilobite;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.DefaultedEntityGeoModel;

public class PrehistoricGeoModel<T extends Prehistoric>
extends DefaultedEntityGeoModel<T>
implements AdditiveAnimationModel {
    private final Function<ResourceLocation, RenderType> renderType;

    public PrehistoricGeoModel(String assetName, Function<ResourceLocation, RenderType> renderType) {
        super(FossilMod.location(assetName), false);
        this.renderType = renderType;
    }

    public void setCustomAnimations(T animatable, long instanceId, AnimationState<T> animationState) {
        PrehistoricFlying flying;
        super.setCustomAnimations(animatable, instanceId, animationState);
        if (Minecraft.m_91087_().m_91104_()) {
            return;
        }
        if (animatable instanceof PrehistoricSwimming && animatable.m_20069_() || animatable instanceof PrehistoricFlying && (flying = (PrehistoricFlying)animatable).m_29443_()) {
            if (!animatable.m_20160_() && !(animatable instanceof Trilobite)) {
                CoreGeoBone root = this.getAnimationProcessor().getBone("pitch_root");
                if (root != null) {
                    float pitch = Mth.m_14179_((float)animationState.getPartialTick(), (float)((Prehistoric)animatable).f_19860_, (float)animatable.m_146909_());
                    root.setRotX(-pitch * ((float)Math.PI / 180));
                }
            } else if (animatable instanceof PrehistoricFlying) {
                PrehistoricFlying flying2 = (PrehistoricFlying)animatable;
                CoreGeoBone root = this.getAnimationProcessor().getBone("pitch_root");
                if (root != null && ((Prehistoric)animatable).m_6688_() instanceof Player) {
                    float pitch = Mth.m_14179_((float)animationState.getPartialTick(), (float)flying2.prevPitch, (float)flying2.currentPitch);
                    root.setRotX(-pitch * ((float)Math.PI / 180));
                    float yaw = Mth.m_14179_((float)animationState.getPartialTick(), (float)flying2.prevYaw, (float)flying2.currentYaw);
                    root.setRotZ(yaw * ((float)Math.PI / 180));
                }
            }
        }
    }

    public ResourceLocation getTextureResource(T object) {
        if (((Prehistoric)object).textureLocation == null) {
            ((Prehistoric)object).refreshTexturePath();
        }
        return ((Prehistoric)object).textureLocation;
    }

    public RenderType getRenderType(T animatable, ResourceLocation texture) {
        return this.renderType.apply(texture);
    }
}

