/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.client.model.block;

import com.github.teamfossilsarcheology.fossil.client.model.block.PlantBlockModel;
import com.mojang.math.Transformation;
import net.minecraft.client.renderer.FaceInfo;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public class PlantModelBakery {
    public static BakedQuad bakeFace(PlantBlockModel.PlantBlockElement part, PlantBlockModel.PlantBlockElementFace partFace, TextureAtlasSprite sprite, Direction direction, ModelState modelState) {
        return PlantModelBakery.bakeQuad(part.from(), part.to(), partFace, sprite, direction, part.rotations(), part.origin(), modelState);
    }

    private static BakedQuad bakeQuad(Vector3f posFrom, Vector3f posTo, PlantBlockModel.PlantBlockElementFace face, TextureAtlasSprite sprite, Direction facing, Vector3f rotations, Vector3f origin, ModelState modelState) {
        PlantBlockModel.PlantBlockFaceUV blockFaceUV = face.uv();
        float[] tempUvs = new float[blockFaceUV.uvs().length];
        System.arraycopy(blockFaceUV.uvs(), 0, tempUvs, 0, tempUvs.length);
        float f = sprite.m_118417_();
        float g = (blockFaceUV.uvs()[0] + blockFaceUV.uvs()[0] + blockFaceUV.uvs()[2] + blockFaceUV.uvs()[2]) / 4.0f;
        float h = (blockFaceUV.uvs()[1] + blockFaceUV.uvs()[1] + blockFaceUV.uvs()[3] + blockFaceUV.uvs()[3]) / 4.0f;
        blockFaceUV.uvs()[0] = Mth.m_14179_((float)f, (float)blockFaceUV.uvs()[0], (float)g);
        blockFaceUV.uvs()[2] = Mth.m_14179_((float)f, (float)blockFaceUV.uvs()[2], (float)g);
        blockFaceUV.uvs()[1] = Mth.m_14179_((float)f, (float)blockFaceUV.uvs()[1], (float)h);
        blockFaceUV.uvs()[3] = Mth.m_14179_((float)f, (float)blockFaceUV.uvs()[3], (float)h);
        int[] vertices = PlantModelBakery.makeVertices(blockFaceUV, sprite, facing, PlantModelBakery.setupShape(posFrom, posTo), rotations, origin, modelState);
        Direction direction = PlantModelBakery.calculateFacing(vertices);
        System.arraycopy(tempUvs, 0, blockFaceUV.uvs(), 0, tempUvs.length);
        return new BakedQuad(vertices, -1, direction, sprite, false);
    }

    private static int[] makeVertices(PlantBlockModel.PlantBlockFaceUV uvs, TextureAtlasSprite sprite, Direction orientation, float[] posDiv16, Vector3f rotations, Vector3f origin, ModelState modelState) {
        int[] is = new int[32];
        for (int i = 0; i < 4; ++i) {
            PlantModelBakery.bakeVertex(is, i, orientation, uvs, posDiv16, sprite, rotations, origin, modelState);
        }
        return is;
    }

    private static float[] setupShape(Vector3f pos1, Vector3f pos2) {
        float[] fs = new float[Direction.values().length];
        fs[FaceInfo.Constants.f_108996_] = pos1.x() / 16.0f;
        fs[FaceInfo.Constants.f_108995_] = pos1.y() / 16.0f;
        fs[FaceInfo.Constants.f_108994_] = pos1.z() / 16.0f;
        fs[FaceInfo.Constants.f_108993_] = pos2.x() / 16.0f;
        fs[FaceInfo.Constants.f_108992_] = pos2.y() / 16.0f;
        fs[FaceInfo.Constants.f_108991_] = pos2.z() / 16.0f;
        return fs;
    }

    private static void bakeVertex(int[] vertexData, int vertexIndex, Direction facing, PlantBlockModel.PlantBlockFaceUV blockFaceUV, float[] posDiv16, TextureAtlasSprite sprite, Vector3f rotations, Vector3f origin, ModelState modelState) {
        FaceInfo.VertexInfo vertexInfo = FaceInfo.m_108984_((Direction)facing).m_108982_(vertexIndex);
        Vector3f vector3f = new Vector3f(posDiv16[vertexInfo.f_108998_], posDiv16[vertexInfo.f_108999_], posDiv16[vertexInfo.f_109000_]);
        PlantModelBakery.applyElementRotation(vector3f, rotations, origin);
        PlantModelBakery.applyModelRotation(vector3f, modelState.m_6189_());
        PlantModelBakery.fillVertex(vertexData, vertexIndex, vector3f, sprite, blockFaceUV);
    }

    private static void fillVertex(int[] vertexData, int vertexIndex, Vector3f vector, TextureAtlasSprite sprite, PlantBlockModel.PlantBlockFaceUV blockFaceUV) {
        int i = vertexIndex * 8;
        vertexData[i] = Float.floatToRawIntBits(vector.x());
        vertexData[i + 1] = Float.floatToRawIntBits(vector.y());
        vertexData[i + 2] = Float.floatToRawIntBits(vector.z());
        vertexData[i + 3] = -1;
        vertexData[i + 4] = Float.floatToRawIntBits(sprite.m_118367_((double)blockFaceUV.getU(vertexIndex)));
        vertexData[i + 4 + 1] = Float.floatToRawIntBits(sprite.m_118393_((double)blockFaceUV.getV(vertexIndex)));
    }

    private static void applyElementRotation(Vector3f pos, Vector3f rotations, Vector3f origin) {
        Vector4f temp = new Vector4f(pos.x() - origin.x(), pos.y() - origin.y(), pos.z() - origin.z(), 1.0f);
        if (rotations.x() != 0.0f) {
            temp.rotateX(rotations.x() * ((float)Math.PI / 180));
        }
        if (rotations.y() != 0.0f) {
            temp.rotateY(rotations.y() * ((float)Math.PI / 180));
        }
        if (rotations.z() != 0.0f) {
            temp.rotateZ(rotations.z() * ((float)Math.PI / 180));
        }
        pos.set(temp.x() + origin.x(), temp.y() + origin.y(), temp.z() + origin.z());
    }

    private static void applyModelRotation(Vector3f pos, Transformation transform) {
        if (transform == Transformation.m_121093_()) {
            return;
        }
        Vector3f origin = new Vector3f(0.5f, 0.5f, 0.5f);
        Vector4f vector4f = new Vector4f(pos.x() - origin.x(), pos.y() - origin.y(), pos.z() - origin.z(), 1.0f);
        transform.m_252783_().transform(vector4f);
        pos.set(vector4f.x() + origin.x(), vector4f.y() + origin.y(), vector4f.z() + origin.z());
    }

    private static Direction calculateFacing(int[] faceData) {
        Vector3f vector3f = new Vector3f(Float.intBitsToFloat(faceData[0]), Float.intBitsToFloat(faceData[1]), Float.intBitsToFloat(faceData[2]));
        Vector3f vector3f2 = new Vector3f(Float.intBitsToFloat(faceData[8]), Float.intBitsToFloat(faceData[9]), Float.intBitsToFloat(faceData[10]));
        Vector3f vector3f3 = new Vector3f(Float.intBitsToFloat(faceData[16]), Float.intBitsToFloat(faceData[17]), Float.intBitsToFloat(faceData[18]));
        Vector3f vector3f4 = new Vector3f((Vector3fc)vector3f);
        vector3f4.sub((Vector3fc)vector3f2);
        Vector3f vector3f5 = new Vector3f((Vector3fc)vector3f3);
        vector3f5.sub((Vector3fc)vector3f2);
        Vector3f vector3f6 = new Vector3f((Vector3fc)vector3f5);
        vector3f6.cross((Vector3fc)vector3f4);
        vector3f6.normalize();
        Direction direction = null;
        float f = 0.0f;
        for (Direction direction2 : Direction.values()) {
            Vector3f vector3f7 = new Vector3f((float)direction2.m_122429_(), (float)direction2.m_122430_(), (float)direction2.m_122431_());
            float g = vector3f6.dot((Vector3fc)vector3f7);
            if (!(g >= 0.0f) || !(g > f)) continue;
            f = g;
            direction = direction2;
        }
        if (direction == null) {
            return Direction.UP;
        }
        return direction;
    }
}

