/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.client.renderer.blockentity;

import com.github.teamfossilsarcheology.fossil.FossilMod;
import com.github.teamfossilsarcheology.fossil.block.custom_blocks.AncientChestBlock;
import com.github.teamfossilsarcheology.fossil.block.entity.AncientChestBlockEntity;
import com.github.teamfossilsarcheology.fossil.item.ModItems;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.Property;

public class AncientChestRenderer
implements BlockEntityRenderer<AncientChestBlockEntity> {
    public static final ResourceLocation TEXTURE = FossilMod.location("textures/entity/ancient_chest.png");
    private final ModelPart chestModel = AncientChestRenderer.createBodyLayer().m_171564_();

    public AncientChestRenderer(BlockEntityRendererProvider.Context context) {
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.m_171576_();
        partDefinition.m_171599_("bottom", CubeListBuilder.m_171558_().m_171514_(0, 19).m_171481_(1.0f, 0.0f, 1.0f, 14.0f, 10.0f, 14.0f), PartPose.f_171404_);
        partDefinition.m_171599_("lid", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(1.0f, 0.0f, 0.0f, 14.0f, 5.0f, 14.0f), PartPose.m_171419_((float)0.0f, (float)9.0f, (float)1.0f));
        partDefinition.m_171599_("lock", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(7.0f, -1.0f, 15.0f, 2.0f, 4.0f, 1.0f), PartPose.m_171419_((float)0.0f, (float)8.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)64, (int)64);
    }

    public void render(AncientChestBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        Direction direction = (Direction)blockEntity.m_58900_().m_61143_((Property)AncientChestBlock.FACING);
        poseStack.m_85836_();
        poseStack.m_252880_(0.5f, 0.5f, 0.5f);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(-direction.m_122435_()));
        poseStack.m_252880_(-0.5f, -0.5f, -0.5f);
        this.chestModel.m_171324_("lid").m_171327_((float)(-blockEntity.getLidTimer()) * ((float)Math.PI / 180), 0.0f, 0.0f);
        VertexConsumer c = bufferSource.m_6299_(RenderType.m_110452_((ResourceLocation)TEXTURE));
        this.chestModel.m_104301_(poseStack, c, packedLight, packedOverlay);
        poseStack.m_85849_();
        if (blockEntity.getState() == 1) {
            poseStack.m_85836_();
            if (direction == Direction.NORTH) {
                poseStack.m_85837_(0.5, (double)0.6f, -0.1);
                poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
                poseStack.m_252781_(Axis.f_252403_.m_252977_(45.0f));
            } else if (direction == Direction.WEST) {
                poseStack.m_252880_(-0.1f, 0.6f, 0.5f);
                poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                poseStack.m_252781_(Axis.f_252403_.m_252977_(45.0f));
            } else if (direction == Direction.SOUTH) {
                poseStack.m_252880_(0.5f, 0.6f, 1.1f);
                poseStack.m_252781_(Axis.f_252436_.m_252977_(270.0f));
                poseStack.m_252781_(Axis.f_252403_.m_252977_(45.0f));
            } else if (direction == Direction.EAST) {
                poseStack.m_252880_(1.1f, 0.6f, 0.5f);
                poseStack.m_252781_(Axis.f_252403_.m_252977_(45.0f));
            }
            Minecraft mc = Minecraft.m_91087_();
            ItemRenderer itemRenderer = mc.m_91291_();
            itemRenderer.m_174242_((LivingEntity)mc.f_91074_, new ItemStack((ItemLike)ModItems.ANCIENT_KEY.get()), ItemTransforms.TransformType.FIXED, false, poseStack, bufferSource, (Level)mc.f_91073_, packedLight, packedOverlay, 0);
            poseStack.m_85849_();
        }
    }
}

