/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.client.renderer.entity;

import com.github.teamfossilsarcheology.fossil.client.model.SkeletonModel;
import com.github.teamfossilsarcheology.fossil.entity.PrehistoricSkeleton;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.util.RenderUtils;

public class SkeletonRenderer
extends EntityRenderer<PrehistoricSkeleton>
implements GeoRenderer<PrehistoricSkeleton> {
    private final GeoModel<PrehistoricSkeleton> geoModel;
    protected PrehistoricSkeleton animatable;
    protected Matrix4f entityRenderTranslations = new Matrix4f();
    protected Matrix4f modelRenderTranslations = new Matrix4f();

    public SkeletonRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.geoModel = new SkeletonModel();
    }

    public GeoModel<PrehistoricSkeleton> getGeoModel() {
        return this.geoModel;
    }

    public PrehistoricSkeleton getAnimatable() {
        return this.animatable;
    }

    public long getInstanceId(PrehistoricSkeleton animatable) {
        return animatable.m_19879_();
    }

    @NotNull
    public ResourceLocation getTextureLocation(PrehistoricSkeleton entity) {
        return super.getTextureLocation((GeoAnimatable)this.animatable);
    }

    public void preRender(PoseStack poseStack, PrehistoricSkeleton animatable, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.entityRenderTranslations = new Matrix4f((Matrix4fc)poseStack.m_85850_().m_252922_());
        this.scaleModelForRender(animatable.getScale(), animatable.getScale(), poseStack, animatable, model, isReRender, partialTick, packedLight, packedOverlay);
    }

    public void render(PrehistoricSkeleton animatable, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        this.animatable = animatable;
        this.defaultRender(poseStack, (GeoAnimatable)animatable, bufferSource, null, null, entityYaw, partialTick, packedLight);
    }

    public void actuallyRender(PoseStack poseStack, PrehistoricSkeleton animatable, BakedGeoModel model, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        poseStack.m_85836_();
        this.modelRenderTranslations = new Matrix4f((Matrix4fc)poseStack.m_85850_().m_252922_());
        if (!animatable.m_20177_((Player)Minecraft.m_91087_().f_91074_)) {
            poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - animatable.m_146908_()));
            super.actuallyRender(poseStack, (GeoAnimatable)animatable, model, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        }
        poseStack.m_85849_();
    }

    public void renderRecursively(PoseStack poseStack, PrehistoricSkeleton animatable, GeoBone bone, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        poseStack.m_85836_();
        RenderUtils.translateMatrixToBone((PoseStack)poseStack, (CoreGeoBone)bone);
        RenderUtils.translateToPivotPoint((PoseStack)poseStack, (CoreGeoBone)bone);
        RenderUtils.rotateMatrixAroundBone((PoseStack)poseStack, (CoreGeoBone)bone);
        RenderUtils.scaleMatrixForBone((PoseStack)poseStack, (CoreGeoBone)bone);
        if (bone.isTrackingMatrices()) {
            Matrix4f poseState = new Matrix4f((Matrix4fc)poseStack.m_85850_().m_252922_());
            Matrix4f localMatrix = RenderUtils.invertAndMultiplyMatrices((Matrix4f)poseState, (Matrix4f)this.entityRenderTranslations);
            bone.setModelSpaceMatrix(RenderUtils.invertAndMultiplyMatrices((Matrix4f)poseState, (Matrix4f)this.modelRenderTranslations));
            bone.setLocalSpaceMatrix(localMatrix.translation((Vector3fc)new Vector3f((Vector3fc)this.m_7860_(this.animatable, 1.0f).m_252839_())));
            bone.setWorldSpaceMatrix(new Matrix4f((Matrix4fc)localMatrix).translation((Vector3fc)new Vector3f((Vector3fc)this.animatable.m_20182_().m_252839_())));
        }
        RenderUtils.translateAwayFromPivotPoint((PoseStack)poseStack, (CoreGeoBone)bone);
        this.renderCubesOfBone(poseStack, bone, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        if (!isReRender) {
            this.applyRenderLayersForBone(poseStack, (GeoAnimatable)animatable, bone, renderType, bufferSource, buffer, partialTick, packedLight, packedOverlay);
        }
        this.renderChildBones(poseStack, (GeoAnimatable)animatable, bone, renderType, bufferSource, buffer, false, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        poseStack.m_85849_();
    }

    public RenderType getRenderType(PrehistoricSkeleton animatable, ResourceLocation texture, MultiBufferSource bufferSource, float partialTick) {
        return RenderType.m_110458_((ResourceLocation)texture);
    }

    protected boolean shouldShowName(PrehistoricSkeleton entity) {
        return false;
    }

    public void scaleModelForRender(float widthScale, float heightScale, PoseStack poseStack, PrehistoricSkeleton animatable, BakedGeoModel model, boolean isReRender, float partialTick, int packedLight, int packedOverlay) {
        if (!(isReRender || widthScale == 1.0f && heightScale == 1.0f)) {
            poseStack.m_85841_(widthScale, heightScale, widthScale);
        }
    }

    public void fireCompileRenderLayersEvent() {
    }

    public boolean firePreRenderEvent(PoseStack poseStack, BakedGeoModel model, MultiBufferSource bufferSource, float partialTick, int packedLight) {
        return true;
    }

    public void firePostRenderEvent(PoseStack poseStack, BakedGeoModel model, MultiBufferSource bufferSource, float partialTick, int packedLight) {
    }
}

