/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.compat.geckolib;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationProcessor;
import software.bernie.geckolib.core.keyframe.AnimationPoint;
import software.bernie.geckolib.core.keyframe.BoneAnimation;
import software.bernie.geckolib.core.keyframe.BoneAnimationQueue;
import software.bernie.geckolib.core.keyframe.Keyframe;
import software.bernie.geckolib.core.state.BoneSnapshot;
import software.bernie.shadowed.eliotlash.mclib.math.Constant;
import software.bernie.shadowed.eliotlash.mclib.math.IValue;

public class AnimationControllerOverride {
    private static final Keyframe<IValue> ZERO_KEYFRAME = new Keyframe(0.0, (IValue)new Constant(0.0), (IValue)new Constant(0.0));
    private static final AnimationPoint POINT = new AnimationPoint(ZERO_KEYFRAME, 0.0, 0.0, 0.0, 0.0);
    private static final AnimationPoint SCALE_POINT = new AnimationPoint(ZERO_KEYFRAME, 0.0, 0.0, 1.0, 1.0);

    public static void fixTransitions(Map<String, CoreGeoBone> bones, AnimationProcessor.QueuedAnimation currentAnimation, Map<String, BoneSnapshot> boneSnapshots, double adjustedTick, boolean firstTick, Map<String, BoneSnapshot> snapshots, double transitionLength, Map<String, BoneAnimationQueue> boneAnimationQueues) {
        HashSet<String> previousBones = new HashSet<String>(boneSnapshots.keySet());
        Set newBones = Arrays.stream(currentAnimation.animation().boneAnimations()).map(BoneAnimation::boneName).collect(Collectors.toSet());
        previousBones.removeAll(newBones);
        if (firstTick) {
            for (String previousBone : previousBones) {
                boneSnapshots.put(previousBone, BoneSnapshot.copy((BoneSnapshot)snapshots.get(previousBone)));
            }
        }
        for (String boneName : previousBones) {
            if (!bones.containsKey(boneName)) continue;
            CoreGeoBone bone = bones.get(boneName);
            BoneAnimationQueue boneAnimationQueue = boneAnimationQueues.get(boneName);
            BoneSnapshot boneSnapshot = boneSnapshots.get(boneName);
            boneAnimationQueue.addNextRotation(null, adjustedTick, transitionLength, boneSnapshot, bone.getInitialSnapshot(), POINT, POINT, POINT);
            boneAnimationQueue.addNextPosition(null, adjustedTick, transitionLength, boneSnapshot, POINT, POINT, POINT);
            boneAnimationQueue.addNextScale(null, adjustedTick, transitionLength, boneSnapshot, SCALE_POINT, SCALE_POINT, SCALE_POINT);
        }
    }
}

