/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.ai.navigation;

import com.github.teamfossilsarcheology.fossil.util.Version;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.util.profiling.metrics.MetricCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.PathNavigationRegion;
import net.minecraft.world.level.pathfinder.BinaryHeap;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.NodeEvaluator;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.Target;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PrehistoricPathFinder
extends PathFinder {
    private static final float FUDGING = 1.5f;
    private static final boolean DEBUG = Version.debugEnabled();
    private final Node[] neighbors = new Node[32];
    private final int maxVisitedNodes;
    private final NodeEvaluator nodeEvaluator;
    private final BinaryHeap openSet = new BinaryHeap();
    protected final List<Node> closedSet = new ArrayList<Node>();
    protected final Mob mob;

    public PrehistoricPathFinder(NodeEvaluator nodeEvaluator, int maxVisitedNodes, Mob mob) {
        super(nodeEvaluator, maxVisitedNodes);
        this.nodeEvaluator = nodeEvaluator;
        this.maxVisitedNodes = maxVisitedNodes;
        this.mob = mob;
    }

    @Nullable
    public Path m_77427_(PathNavigationRegion region, Mob mob, Set<BlockPos> targetPositions, float maxRange, int accuracy, float searchDepthMultiplier) {
        this.openSet.m_77081_();
        this.closedSet.clear();
        this.nodeEvaluator.m_6028_(region, mob);
        Node node = this.nodeEvaluator.m_7171_();
        Map<Target, BlockPos> map = targetPositions.stream().collect(Collectors.toMap(blockPos -> this.nodeEvaluator.m_7568_((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_()), Function.identity()));
        PatchedPath path = this.findPatchedPath(region.m_151625_(), node, map, maxRange, accuracy, searchDepthMultiplier);
        if (DEBUG && path != null) {
            path.m_164709_(this.openSet.m_164684_(), (Node[])this.closedSet.toArray(Node[]::new), map.keySet());
        }
        this.nodeEvaluator.m_6802_();
        return path;
    }

    protected PatchedPath findPatchedPath(ProfilerFiller profiler, Node start, Map<Target, BlockPos> targetPos, float maxRange, int accuracy, float searchDepthMultiplier) {
        profiler.m_6180_("find_path");
        profiler.m_142259_(MetricCategory.PATH_FINDING);
        Set<Target> set = targetPos.keySet();
        start.f_77275_ = 0.0f;
        start.f_77277_ = start.f_77276_ = this.getBestH(start, set, false);
        this.openSet.m_77081_();
        this.openSet.m_77084_(start);
        int i = 1;
        int maxNodes = (int)((float)this.maxVisitedNodes * searchDepthMultiplier);
        while (!this.openSet.m_77092_() && i < maxNodes) {
            Node node = this.openSet.m_77091_();
            this.closedSet.add(node);
            node.f_77279_ = true;
            for (Target target2 : set) {
                if (node.m_77304_((Node)target2) > (float)accuracy) continue;
                target2.m_77509_();
                return this.reconstructPath(target2, targetPos.get(target2), true);
            }
            if (node.m_77293_(start) >= maxRange) continue;
            int neighborCount = this.nodeEvaluator.m_6065_(this.neighbors, node);
            for (int l = 0; l < neighborCount; ++l) {
                Node neighbor = this.neighbors[l];
                float f = node.m_77293_(neighbor);
                neighbor.f_77280_ = node.f_77280_ + f;
                float g = node.f_77275_ + f + neighbor.f_77281_;
                if (neighbor.f_77280_ >= maxRange || neighbor.m_77303_() && g >= neighbor.f_77275_) continue;
                neighbor.f_77278_ = node;
                neighbor.f_77275_ = g;
                neighbor.f_77276_ = this.getBestH(neighbor, set, true);
                if (neighbor.m_77303_()) {
                    this.openSet.m_77086_(neighbor, neighbor.f_77275_ + neighbor.f_77276_);
                    continue;
                }
                neighbor.f_77277_ = neighbor.f_77275_ + neighbor.f_77276_;
                this.openSet.m_77084_(neighbor);
            }
            ++i;
        }
        Optional<PatchedPath> path = set.stream().map(target -> this.reconstructPath((Target)target, (BlockPos)targetPos.get(target), false)).min(Comparator.comparingDouble(Path::m_77407_).thenComparingInt(Path::m_77398_));
        profiler.m_7238_();
        return path.orElse(null);
    }

    protected float getBestH(Node node, Set<Target> targets, boolean fudge) {
        float f = Float.MAX_VALUE;
        for (Target target : targets) {
            float g = node.m_77293_((Node)target);
            target.m_77503_(g, node);
            f = Math.min(g, f);
        }
        return f * (fudge ? 1.5f : 1.0f);
    }

    private PatchedPath reconstructPath(Target target, BlockPos targetPos, boolean reachesTarget) {
        Node end = target.m_77508_();
        ArrayList list = Lists.newArrayList();
        Node node = end;
        list.add(0, node);
        while (node.f_77278_ != null) {
            node = node.f_77278_;
            list.add(0, node);
        }
        if (this.mob.m_20205_() < 1.0f && reachesTarget) {
            list.add(target);
        }
        return new PatchedPath(list, targetPos, reachesTarget);
    }

    public static class PatchedPath
    extends Path {
        public PatchedPath(List<Node> list, BlockPos blockPos, boolean bl) {
            super(list, blockPos, bl);
        }

        @NotNull
        public Vec3 m_77382_(Entity entity, int index) {
            Node point = this.m_77375_(index);
            double d0 = (double)point.f_77271_ + (double)Mth.m_14143_((float)(entity.m_20205_() + 1.0f)) * 0.5;
            double d1 = point.f_77272_;
            double d2 = (double)point.f_77273_ + (double)Mth.m_14143_((float)(entity.m_20205_() + 1.0f)) * 0.5;
            return new Vec3(d0, d1, d2);
        }
    }
}

