/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.animation;

import com.github.teamfossilsarcheology.fossil.entity.animation.AnimationInfo;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricAnimatable;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricFlying;
import java.util.HashSet;
import java.util.Locale;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Mob;
import software.bernie.geckolib.core.animation.AnimationController;

public class AnimationHolder {
    private final NavigableMap<Double, AnimationInfo> animations = new TreeMap<Double, AnimationInfo>();
    private final NavigableMap<Double, AnimationInfo> babyAnimations = new TreeMap<Double, AnimationInfo>();
    private final NavigableMap<Double, AnimationInfo> waterAnimations = new TreeMap<Double, AnimationInfo>();
    private final NavigableMap<Double, AnimationInfo> airAnimations = new TreeMap<Double, AnimationInfo>();
    private final Set<String> lookup = new HashSet<String>();

    public void add(AnimationInfo animation) {
        String name = animation.animation.name().toLowerCase(Locale.ROOT);
        String[] parts = name.split("_");
        int weight = 1;
        if (parts.length >= 3) {
            try {
                Integer.parseInt(parts[parts.length - 2]);
                weight = Integer.parseInt(parts[parts.length - 1]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (name.contains("_baby")) {
            AnimationHolder.addAnimation(this.babyAnimations, animation, weight);
        } else if (name.contains("_water")) {
            AnimationHolder.addAnimation(this.waterAnimations, animation, weight);
        } else if (name.contains("_air")) {
            AnimationHolder.addAnimation(this.airAnimations, animation, weight);
        } else {
            AnimationHolder.addAnimation(this.animations, animation, weight);
        }
        this.lookup.add(animation.animation.name());
    }

    private static void addAnimation(NavigableMap<Double, AnimationInfo> map, AnimationInfo animation, double weight) {
        if (!map.isEmpty()) {
            map.put((Double)map.lastKey() + weight, animation);
        } else {
            map.put(weight, animation);
        }
    }

    public boolean hasAnimation(String animationName) {
        return this.lookup.contains(animationName);
    }

    public AnimationInfo getRandomAnimation(Mob entity) {
        if (!this.babyAnimations.isEmpty() && entity.m_6162_()) {
            return AnimationHolder.getRandomAnimation(this.babyAnimations, entity.m_217043_());
        }
        if (!this.waterAnimations.isEmpty() && entity.m_20069_()) {
            return AnimationHolder.getRandomAnimation(this.waterAnimations, entity.m_217043_());
        }
        if (entity instanceof PrehistoricFlying) {
            PrehistoricFlying flying = (PrehistoricFlying)entity;
            if (!this.airAnimations.isEmpty() && flying.m_29443_()) {
                return AnimationHolder.getRandomAnimation(this.airAnimations, entity.m_217043_());
            }
        }
        return AnimationHolder.getRandomAnimation(this.animations, entity.m_217043_());
    }

    public void addTriggers(AnimationController<? extends PrehistoricAnimatable<?>> controller) {
        this.babyAnimations.values().forEach(animationInfo -> controller.triggerableAnim(animationInfo.animation.name(), animationInfo.rawAnimation));
        this.waterAnimations.values().forEach(animationInfo -> controller.triggerableAnim(animationInfo.animation.name(), animationInfo.rawAnimation));
        this.airAnimations.values().forEach(animationInfo -> controller.triggerableAnim(animationInfo.animation.name(), animationInfo.rawAnimation));
        this.animations.values().forEach(animationInfo -> controller.triggerableAnim(animationInfo.animation.name(), animationInfo.rawAnimation));
    }

    private static AnimationInfo getRandomAnimation(NavigableMap<Double, AnimationInfo> map, RandomSource random) {
        return map.higherEntry(random.m_188500_() * (Double)map.lastKey()).getValue();
    }
}

