/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.prehistoric.system;

import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.OrderType;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.swimming.Meganeura;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.system.AISystem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.Vec3;

public class MeganeuraAttachSystem
extends AISystem {
    private static final int MAX_TRY_TICKS = 300;
    private static final int MAX_ATTACH_TICKS = 1200;
    private final Meganeura mob;
    private final SynchedEntityData entityData;
    private BlockPos targetBlockPos;
    private Vec3 targetLocation;
    private Direction targetFace;
    private int attachCooldown = 150;
    private int attachTicks = 0;
    private int tryTicks = 0;

    public MeganeuraAttachSystem(Meganeura mob) {
        super(mob);
        this.mob = mob;
        this.entityData = mob.m_20088_();
    }

    @Override
    public void serverTick() {
        double dist;
        if (this.tryTicks > 0) {
            ++this.tryTicks;
        }
        if (this.mob.m_6162_()) {
            this.attachCooldown = 150;
            return;
        }
        if (this.attachCooldown > 0) {
            --this.attachCooldown;
        }
        if (!this.isAttached() && this.targetLocation != null && (dist = this.targetLocation.m_82554_(this.mob.m_20182_())) < 1.0) {
            this.mob.m_21566_().m_6849_(this.targetLocation.f_82479_, this.targetLocation.f_82480_, this.targetLocation.f_82481_, 0.9);
            this.mob.m_21573_().m_26573_();
            if (!this.attachStarted()) {
                this.approachAttachPos();
            }
            if (dist < 0.2) {
                this.startAttaching();
            }
        }
        if (this.isAttached()) {
            ++this.attachTicks;
            this.mob.m_20256_(Vec3.f_82478_);
        }
        if (this.attachStarted() && this.targetBlockPos != null) {
            this.mob.m_146922_(0.0f);
            this.mob.m_146926_(0.0f);
            this.mob.f_20883_ = 0.0f;
            this.mob.f_20885_ = 0.0f;
            if (!this.mob.f_19853_.m_8055_(this.targetBlockPos).m_60783_((BlockGetter)this.mob.f_19853_, this.targetBlockPos, this.getAttachmentFace())) {
                this.stopAttaching();
            }
            if (this.isAttached()) {
                if (!this.mob.m_5803_() && this.mob.getCurrentOrder() != OrderType.STAY && (this.attachTicks > 1200 && this.mob.m_217043_().m_188503_(123) == 0 || this.mob.m_5448_() != null)) {
                    this.stopAttaching(1000 + this.mob.m_217043_().m_188503_(1500));
                }
                if (this.mob.getCurrentOrder() == OrderType.FOLLOW) {
                    this.stopAttaching();
                }
            }
        }
        if (this.tryTicks > 300) {
            this.stopAttaching();
        }
    }

    @Override
    public void clientTick() {
        if (this.attachStarted()) {
            this.mob.m_146922_(0.0f);
            this.mob.m_146926_(0.0f);
            this.mob.f_20883_ = 0.0f;
            this.mob.f_20885_ = 0.0f;
        }
    }

    public void approachAttachPos() {
        this.attachCooldown = 150;
        this.tryTicks = 260;
        this.setAttachmentPos(this.targetLocation);
        this.setAttachmentFace(this.targetFace);
    }

    public void setAttachTarget(BlockPos attachBlockPos, Direction attachFace) {
        double rad = this.mob.m_20205_() / 2.0f;
        Vec3 pos = Vec3.m_82512_((Vec3i)attachBlockPos).m_82520_((0.5 + rad) * (double)attachFace.m_122429_(), 0.0, (0.5 + rad) * (double)attachFace.m_122431_());
        RandomSource random = this.mob.m_217043_();
        double randomOffset = (random.m_188500_() * 2.0 - 1.0) * (0.5 - rad - (double)1.0E-5f);
        pos = pos.m_82520_((double)attachFace.m_122427_().m_122429_() * randomOffset, (double)((random.m_188501_() * 2.0f - 1.0f) * 0.3f), (double)attachFace.m_122427_().m_122431_() * randomOffset);
        this.setAttachTarget(attachBlockPos, attachFace, pos);
    }

    public void setAttachTarget(BlockPos attachBlockPos, Direction attachFace, Vec3 attachLocation) {
        this.targetBlockPos = attachBlockPos;
        this.targetFace = attachFace;
        this.targetLocation = attachLocation;
        this.tryTicks = 0;
    }

    public void startAttaching() {
        this.attachCooldown = 150;
        this.attachTicks = 0;
        this.tryTicks = 0;
        this.setAttached(true);
        this.mob.m_6034_(this.targetLocation.f_82479_, this.mob.m_20186_(), this.targetLocation.f_82481_);
        this.mob.m_20256_(Vec3.f_82478_);
    }

    public void stopAttaching(int attachCooldown) {
        this.targetBlockPos = null;
        this.targetFace = null;
        this.targetLocation = null;
        this.tryTicks = 0;
        this.attachCooldown = attachCooldown;
        this.setAttached(false);
        this.setAttachmentPos(Vec3.f_82478_);
        this.setAttachmentFace(Direction.UP);
    }

    public void stopAttaching() {
        this.stopAttaching(150);
    }

    public boolean isAttached() {
        return (Boolean)this.entityData.m_135370_(Meganeura.ATTACHED);
    }

    private void setAttached(boolean attached) {
        this.entityData.m_135381_(Meganeura.ATTACHED, (Object)attached);
    }

    public int getAttachCooldown() {
        return this.attachCooldown;
    }

    public void setAttachCooldown(int attachCooldown) {
        this.attachCooldown = attachCooldown;
    }

    public boolean attachStarted() {
        return this.getAttachmentFace() != Direction.UP;
    }

    public Vec3 getAttachmentPos() {
        return new Vec3((double)((Float)this.entityData.m_135370_(Meganeura.ATTACHED_X)).floatValue(), (double)((Float)this.entityData.m_135370_(Meganeura.ATTACHED_Y)).floatValue(), (double)((Float)this.entityData.m_135370_(Meganeura.ATTACHED_Z)).floatValue());
    }

    private void setAttachmentPos(Vec3 location) {
        this.entityData.m_135381_(Meganeura.ATTACHED_X, (Object)Float.valueOf((float)location.f_82479_));
        this.entityData.m_135381_(Meganeura.ATTACHED_Y, (Object)Float.valueOf((float)location.f_82480_));
        this.entityData.m_135381_(Meganeura.ATTACHED_Z, (Object)Float.valueOf((float)location.f_82481_));
    }

    public Direction getAttachmentFace() {
        return (Direction)this.entityData.m_135370_(Meganeura.ATTACHED_FACE);
    }

    private void setAttachmentFace(Direction direction) {
        this.entityData.m_135381_(Meganeura.ATTACHED_FACE, (Object)direction);
    }

    @Override
    public void saveAdditional(CompoundTag tag) {
        tag.m_128405_("AttachTicks", this.attachTicks);
        tag.m_128405_("AttachCooldown", this.attachCooldown);
        tag.m_128405_("AttachFace", this.getAttachmentFace().m_122411_());
        tag.m_128379_("Attached", this.isAttached());
        Vec3 attachPos = this.getAttachmentPos();
        tag.m_128347_("AttachX", attachPos.f_82479_);
        tag.m_128347_("AttachY", attachPos.f_82480_);
        tag.m_128347_("AttachZ", attachPos.f_82481_);
        if (this.targetBlockPos != null) {
            tag.m_128365_("AttachPos", (Tag)NbtUtils.m_129224_((BlockPos)this.targetBlockPos));
        }
    }

    @Override
    public void load(CompoundTag tag) {
        this.attachTicks = tag.m_128451_("AttachTicks");
        this.attachCooldown = tag.m_128451_("AttachCooldown");
        this.setAttachmentFace(Direction.m_122376_((int)tag.m_128451_("AttachFace")));
        this.setAttached(tag.m_128471_("Attached"));
        this.setAttachmentPos(new Vec3(tag.m_128459_("AttachX"), tag.m_128459_("AttachY"), tag.m_128459_("AttachZ")));
        if (tag.m_128441_("AttachPos")) {
            this.targetBlockPos = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("AttachPos"));
        }
    }
}

