/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.forge.data;

import com.github.teamfossilsarcheology.fossil.forge.data.advancements.FossilAdvancements;
import com.github.teamfossilsarcheology.fossil.forge.data.providers.ModBlockStateProvider;
import com.github.teamfossilsarcheology.fossil.forge.data.providers.ModBlockTagsProvider;
import com.github.teamfossilsarcheology.fossil.forge.data.providers.ModEntityTypeTagsProvider;
import com.github.teamfossilsarcheology.fossil.forge.data.providers.ModFoodValueProvider;
import com.github.teamfossilsarcheology.fossil.forge.data.providers.ModItemProvider;
import com.github.teamfossilsarcheology.fossil.forge.data.providers.ModItemTagsProvider;
import com.github.teamfossilsarcheology.fossil.forge.data.providers.ModLootProvider;
import com.github.teamfossilsarcheology.fossil.forge.data.providers.ModRecipeProvider;
import com.github.teamfossilsarcheology.fossil.forge.data.providers.ModWorldGenProvider;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.ForgeAdvancementProvider;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="fossil", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void register(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        CompletableFuture lookup = event.getLookupProvider();
        ExistingFileHelper efh = event.getExistingFileHelper();
        generator.addProvider(event.includeClient(), output -> new ModBlockStateProvider(output, efh));
        generator.addProvider(event.includeClient(), output -> new ModItemProvider(output, efh));
        ModBlockTagsProvider blockTags = new ModBlockTagsProvider(generator.getPackOutput(), lookup, efh);
        generator.addProvider(event.includeServer(), (DataProvider)blockTags);
        generator.addProvider(event.includeServer(), output -> new ModItemTagsProvider(output, lookup, (TagsProvider<Block>)blockTags, efh));
        generator.addProvider(event.includeServer(), output -> new ModEntityTypeTagsProvider(output, lookup, efh));
        generator.addProvider(event.includeServer(), ModRecipeProvider::new);
        generator.addProvider(event.includeServer(), output -> new ForgeAdvancementProvider(output, lookup, efh, List.of((registries, writer, existingFileHelper) -> new FossilAdvancements().accept(writer))));
        generator.addProvider(event.includeServer(), ModLootProvider::new);
        generator.addProvider(event.includeServer(), output -> new ModWorldGenProvider(output, lookup));
        generator.addProvider(event.includeServer(), ModFoodValueProvider::new);
    }
}

