/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.network.debug;

import com.github.teamfossilsarcheology.fossil.util.Version;
import dev.architectury.networking.NetworkManager;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class C2SRotationMessage {
    public static final byte Y_ROT = 0;
    public static final byte X_ROT = 1;
    private final int entityId;
    private final double rotation;
    private final byte flag;

    public C2SRotationMessage(FriendlyByteBuf buf) {
        this(buf.readInt(), buf.readDouble(), buf.readByte());
    }

    public C2SRotationMessage(int entityId, double rotation, byte flag) {
        this.entityId = entityId;
        this.rotation = rotation;
        this.flag = flag;
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.entityId);
        buf.writeDouble(this.rotation);
        buf.writeByte((int)this.flag);
    }

    public void apply(Supplier<NetworkManager.PacketContext> contextSupplier) {
        contextSupplier.get().queue(() -> {
            if (Version.debugEnabled()) {
                Entity entity = ((NetworkManager.PacketContext)contextSupplier.get()).getPlayer().f_19853_.m_6815_(this.entityId);
                switch (this.flag) {
                    case 0: {
                        if (entity instanceof LivingEntity) {
                            entity.m_5618_((float)this.rotation);
                            entity.m_5616_((float)this.rotation);
                            break;
                        }
                        entity.m_146922_((float)this.rotation);
                        break;
                    }
                    case 1: {
                        if (entity == null) break;
                        entity.m_146926_((float)this.rotation);
                    }
                }
            }
        });
    }
}

