/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.network.debug;

import com.github.teamfossilsarcheology.fossil.client.gui.debug.InstructionTab;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.instruction.Instruction;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.Prehistoric;
import com.github.teamfossilsarcheology.fossil.util.Version;
import dev.architectury.networking.NetworkManager;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;

public class InstructionMessage {
    private final int entityId;
    private final boolean loop;
    private final List<Instruction> instructions;

    public InstructionMessage(FriendlyByteBuf buf) {
        this(buf.readInt(), buf.readBoolean(), Instruction.decodeBuffer(buf));
    }

    public InstructionMessage(int entityId, boolean loop, List<Instruction> instructions) {
        this.entityId = entityId;
        this.loop = loop;
        this.instructions = instructions;
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.entityId);
        buf.writeBoolean(this.loop);
        Instruction.encodeBuffer(this.instructions, buf);
    }

    public void apply(Supplier<NetworkManager.PacketContext> contextSupplier) {
        contextSupplier.get().queue(() -> {
            if (Version.debugEnabled()) {
                Level level = ((NetworkManager.PacketContext)contextSupplier.get()).getPlayer().f_19853_;
                Entity entity = ((NetworkManager.PacketContext)contextSupplier.get()).getPlayer().f_19853_.m_6815_(this.entityId);
                if (entity instanceof Prehistoric) {
                    Prehistoric prehistoric = (Prehistoric)entity;
                    if (level.f_46443_) {
                        if (InstructionTab.activeEntity == null || InstructionTab.activeEntity.m_19879_() != entity.m_19879_()) {
                            InstructionTab.INSTRUCTIONS.put(entity.m_20148_(), new InstructionTab.Pair(this.entityId, this.instructions));
                        }
                    } else {
                        prehistoric.getInstructionSystem().start(this.instructions, this.loop, !this.instructions.isEmpty());
                    }
                }
            }
        });
    }
}

