/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public abstract class WithFuelRecipe
implements Recipe<ContainerWithAnyFuel> {
    private final ResourceLocation location;
    private final Ingredient input;
    private final Ingredient fuel;
    private final ItemStack result;
    private final int duration;

    protected WithFuelRecipe(ResourceLocation location, Ingredient input, Ingredient fuel, ItemStack result, int duration) {
        this.location = location;
        this.input = input;
        this.fuel = fuel;
        this.result = result;
        this.duration = duration;
    }

    public boolean matches(ContainerWithAnyFuel container, Level level) {
        return this.input.test(container.m_8020_(0)) && (container.anyFuel || this.fuel.test(container.m_8020_(1)));
    }

    @NotNull
    public ItemStack assemble(ContainerWithAnyFuel container) {
        ItemStack itemStack = this.result.m_41777_();
        CompoundTag compoundTag = container.m_8020_(0).m_41783_();
        if (compoundTag != null) {
            itemStack.m_41751_(compoundTag.m_6426_());
        }
        return itemStack;
    }

    public boolean m_8004_(int width, int height) {
        return false;
    }

    @NotNull
    public ItemStack m_8043_() {
        return this.result.m_41777_();
    }

    @NotNull
    public NonNullList<Ingredient> m_7527_() {
        NonNullList nonNullList = NonNullList.m_122779_();
        nonNullList.add((Object)this.input);
        return nonNullList;
    }

    public boolean m_5598_() {
        return true;
    }

    @NotNull
    public ResourceLocation m_6423_() {
        return this.location;
    }

    public boolean isFuel(ItemStack itemStack) {
        return this.fuel.test(itemStack);
    }

    public Ingredient getInput() {
        return this.input;
    }

    public Ingredient getFuel() {
        return this.fuel;
    }

    public int getDuration() {
        return this.duration;
    }

    public static class ContainerWithAnyFuel
    extends SimpleContainer {
        public final boolean anyFuel;

        public ContainerWithAnyFuel(boolean anyFuel, ItemStack ... items) {
            super(items);
            this.anyFuel = anyFuel;
        }

        public ContainerWithAnyFuel(ItemStack input, ItemStack fuel) {
            super(new ItemStack[]{input, fuel});
            this.anyFuel = false;
        }
    }

    public static class WithFuelRecipeSerializer<T extends WithFuelRecipe>
    implements RecipeSerializer<T> {
        protected final Constructor<T> constructor;

        protected WithFuelRecipeSerializer(Constructor<T> constructor) {
            this.constructor = constructor;
        }

        @NotNull
        public T fromJson(ResourceLocation recipeId, JsonObject serializedRecipe) {
            JsonObject jsonElement = GsonHelper.m_13930_((JsonObject)serializedRecipe, (String)"input");
            Ingredient input = Ingredient.m_43917_((JsonElement)jsonElement);
            jsonElement = GsonHelper.m_13930_((JsonObject)serializedRecipe, (String)"fuel");
            Ingredient fuel = Ingredient.m_43917_((JsonElement)jsonElement);
            String result = GsonHelper.m_13906_((JsonObject)serializedRecipe, (String)"result");
            ItemStack output = new ItemStack((ItemLike)BuiltInRegistries.f_257033_.m_6612_(new ResourceLocation(result)).orElseThrow(() -> new IllegalStateException("Item: " + result + " does not exist")));
            int duration = GsonHelper.m_13824_((JsonObject)serializedRecipe, (String)"duration", (int)300);
            return (T)((WithFuelRecipe)this.constructor.construct(recipeId, input, fuel, output, duration));
        }

        @NotNull
        public T fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            Ingredient fuel = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            ItemStack output = buffer.m_130267_();
            int duration = buffer.readInt();
            return (T)((WithFuelRecipe)this.constructor.construct(recipeId, input, fuel, output, duration));
        }

        public void toNetwork(FriendlyByteBuf buffer, WithFuelRecipe recipe) {
            recipe.input.m_43923_(buffer);
            recipe.fuel.m_43923_(buffer);
            buffer.m_130055_(recipe.result);
            buffer.writeInt(recipe.duration);
        }

        @FunctionalInterface
        public static interface Constructor<R> {
            public R construct(ResourceLocation var1, Ingredient var2, Ingredient var3, ItemStack var4, int var5);
        }
    }
}

