/*
 * Decompiled with CFR 0.152.
 */
package com.github.darkpred.morehitboxes.mixin;

import com.github.darkpred.morehitboxes.api.MultiPart;
import com.github.darkpred.morehitboxes.api.MultiPartEntity;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalDoubleRef;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Entity.class})
public abstract class EntityMixin {
    @Shadow
    public abstract double m_20185_();

    @Shadow
    public abstract double m_20186_();

    @Shadow
    public abstract double m_20189_();

    @Shadow
    public abstract void m_6034_(double var1, double var3, double var5);

    @Inject(method={"onSyncedDataUpdated"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;refreshDimensions()V")})
    public void saveYPos(CallbackInfo ci, @Share(value="oldY") LocalDoubleRef oldY) {
        oldY.set(this.m_20186_());
    }

    @Inject(method={"onSyncedDataUpdated"}, at={@At(value="INVOKE", shift=At.Shift.AFTER, target="Lnet/minecraft/world/entity/Entity;refreshDimensions()V")})
    public void restoreYPos(CallbackInfo ci, @Share(value="oldY") LocalDoubleRef oldY) {
        MultiPartEntity multiPartEntity;
        EntityMixin entityMixin = this;
        if (entityMixin instanceof MultiPartEntity && (multiPartEntity = (MultiPartEntity)((Object)entityMixin)).getEntityHitboxData().fixPosOnRefresh()) {
            this.m_6034_(this.m_20185_(), oldY.get(), this.m_20189_());
        }
    }

    @Inject(method={"refreshDimensions"}, at={@At(value="RETURN")})
    public void refreshDimensionsForParts(CallbackInfo ci, @Share(value="oldY") LocalDoubleRef oldY) {
        EntityMixin entityMixin = this;
        if (entityMixin instanceof MultiPartEntity) {
            MultiPartEntity multiPartEntity = (MultiPartEntity)((Object)entityMixin);
            for (MultiPart multiPart : multiPartEntity.getEntityHitboxData().getCustomParts()) {
                multiPart.getEntity().m_6210_();
            }
        }
    }

    @ModifyReturnValue(method={"getBoundingBoxForCulling"}, at={@At(value="RETURN")})
    public AABB changeCullBox(AABB original) {
        MultiPartEntity multiPartEntity;
        EntityMixin entityMixin = this;
        if (entityMixin instanceof MultiPartEntity && (multiPartEntity = (MultiPartEntity)((Object)entityMixin)).getEntityHitboxData() != null && multiPartEntity.getEntityHitboxData().hasCustomParts()) {
            return multiPartEntity.getEntityHitboxData().getCullingBounds();
        }
        return original;
    }

    @Inject(method={"setBoundingBox"}, at={@At(value="RETURN")})
    public void updateBounds(AABB aABB, CallbackInfo ci) {
        MultiPartEntity multiPartEntity;
        EntityMixin entityMixin = this;
        if (entityMixin instanceof MultiPartEntity && (multiPartEntity = (MultiPartEntity)((Object)entityMixin)).getEntityHitboxData() != null) {
            multiPartEntity.getEntityHitboxData().makeAttackBounds();
            multiPartEntity.getEntityHitboxData().makeBoundingBoxForCulling();
        }
    }

    @Inject(method={"setId"}, at={@At(value="RETURN")})
    public void setPartIds(int id, CallbackInfo ci) {
        EntityMixin entityMixin = this;
        if (entityMixin instanceof MultiPartEntity) {
            MultiPartEntity multiPartEntity = (MultiPartEntity)((Object)entityMixin);
            List list = multiPartEntity.getEntityHitboxData().getCustomParts();
            for (int i = 0; i < list.size(); ++i) {
                list.get(i).getEntity().m_20234_(id + i + 1);
            }
        }
    }

    @Inject(method={"remove"}, at={@At(value="RETURN")})
    public void callRemoveCallback(Entity.RemovalReason removalReason, CallbackInfo ci) {
        EntityMixin entityMixin = this;
        if (entityMixin instanceof MultiPartEntity) {
            MultiPartEntity multiPartEntity = (MultiPartEntity)((Object)entityMixin);
            for (MultiPart multiPart : multiPartEntity.getEntityHitboxData().getCustomParts()) {
                multiPart.getEntity().m_142687_(removalReason);
            }
        }
    }
}

