/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.block.entity;

import com.github.teamfossilsarcheology.fossil.block.custom_blocks.FeederBlock;
import com.github.teamfossilsarcheology.fossil.block.entity.ModBlockEntities;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.Prehistoric;
import com.github.teamfossilsarcheology.fossil.food.Diet;
import com.github.teamfossilsarcheology.fossil.food.FoodMappings;
import com.github.teamfossilsarcheology.fossil.food.FoodType;
import com.github.teamfossilsarcheology.fossil.inventory.FeederMenu;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Map;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2624;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3913;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FeederBlockEntity
extends class_2624
implements class_1278 {
    private static final int SIZE = 3;
    private static final int[] SLOTS_TOP = new int[]{0, 1, 2};
    private static final String[] NAMES = new String[]{"Meat", "Plant", "Fish"};
    private static final FoodType[] FOOD_TYPES = new FoodType[]{FoodType.MEAT, FoodType.PLANT, FoodType.FISH};
    private final Map<FoodType, Integer> foodStored = new Object2IntOpenHashMap(3);
    private final class_3913 dataAccess = new class_3913(){

        public int method_17390(int index) {
            return FeederBlockEntity.this.foodStored.getOrDefault((Object)FOOD_TYPES[index], 0);
        }

        public void method_17391(int index, int value) {
            FeederBlockEntity.this.foodStored.put(FOOD_TYPES[index], value);
        }

        public int method_17389() {
            return 3;
        }
    };
    protected class_2371<class_1799> items = class_2371.method_10213((int)3, (Object)class_1799.field_8037);
    private int ticksExisted;

    public FeederBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super((class_2591)ModBlockEntities.FEEDER.get(), blockPos, blockState);
        for (FoodType type : FOOD_TYPES) {
            this.foodStored.put(type, 0);
        }
    }

    public static void serverTick(class_1937 level, class_2338 pos, class_2680 state, FeederBlockEntity blockEntity) {
        ++blockEntity.ticksExisted;
        boolean dirty = false;
        for (int i = 0; i < FOOD_TYPES.length; ++i) {
            int foodPoints;
            FoodType type = FOOD_TYPES[i];
            int current = blockEntity.foodStored.get((Object)type);
            blockEntity.foodStored.put(type, Math.max(current, 0));
            class_1799 foodStack = blockEntity.method_5438(i);
            if (foodStack.method_7960() || blockEntity.ticksExisted % 5 != 0 || current >= 10000 || (foodPoints = FoodMappings.getFoodAmount((class_1935)foodStack.method_7909(), type)) <= 0) continue;
            dirty = true;
            blockEntity.foodStored.put(type, current + foodPoints);
            foodStack.method_7934(1);
        }
        if (dirty) {
            state = (class_2680)((class_2680)state.method_11657((class_2769)FeederBlock.HERB, (Comparable)Boolean.valueOf(blockEntity.foodStored.get((Object)FoodType.PLANT) > 0))).method_11657((class_2769)FeederBlock.CARN, (Comparable)Boolean.valueOf(blockEntity.foodStored.get((Object)FoodType.MEAT) > 0 || blockEntity.foodStored.get((Object)FoodType.FISH) > 0));
            level.method_8652(pos, state, 3);
            FeederBlockEntity.method_31663((class_1937)level, (class_2338)pos, (class_2680)state);
        }
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        this.items = class_2371.method_10213((int)this.method_5439(), (Object)class_1799.field_8037);
        class_1262.method_5429((class_2487)tag, this.items);
        for (int i = 0; i < FOOD_TYPES.length; ++i) {
            this.foodStored.put(FOOD_TYPES[i], Integer.valueOf(tag.method_10568(NAMES[i])));
        }
    }

    protected void method_11007(class_2487 tag) {
        super.method_11007(tag);
        for (int i = 0; i < FOOD_TYPES.length; ++i) {
            tag.method_10575(NAMES[i], (short)this.foodStored.get((Object)FOOD_TYPES[i]).intValue());
        }
        class_1262.method_5426((class_2487)tag, this.items);
    }

    @NotNull
    protected class_2561 method_17823() {
        return class_2561.method_43471((String)"container.fossil.feeder");
    }

    @NotNull
    protected class_1703 method_5465(int containerId, class_1661 inventory) {
        return new FeederMenu(containerId, inventory, (class_1263)this, this.dataAccess);
    }

    public int method_5439() {
        return this.items.size();
    }

    public boolean method_5442() {
        for (class_1799 itemStack : this.items) {
            if (itemStack.method_7960()) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty(Diet diet) {
        for (Map.Entry<FoodType, Integer> entry : this.foodStored.entrySet()) {
            if (entry.getValue() <= 0 || !diet.canEat(entry.getKey())) continue;
            return false;
        }
        return true;
    }

    public Integer getSignalStrength() {
        return this.foodStored.values().stream().reduce(Integer::sum).orElse(0);
    }

    public void feedDinosaur(Prehistoric mob) {
        if (this.field_11863 != null) {
            int feedAmount = 0;
            Diet diet = mob.data().diet();
            for (Map.Entry<FoodType, Integer> entry : this.foodStored.entrySet()) {
                if (entry.getValue() <= 0 || !diet.canEat(entry.getKey())) continue;
                this.foodStored.put(entry.getKey(), entry.getValue() - 1);
                ++feedAmount;
                break;
            }
            if (feedAmount > 0) {
                class_2680 blockState = (class_2680)((class_2680)this.field_11863.method_8320(this.method_11016()).method_11657((class_2769)FeederBlock.HERB, (Comparable)Boolean.valueOf(this.foodStored.get((Object)FoodType.PLANT) > 0))).method_11657((class_2769)FeederBlock.CARN, (Comparable)Boolean.valueOf(this.foodStored.get((Object)FoodType.MEAT) > 0 || this.foodStored.get((Object)FoodType.FISH) > 0));
                this.field_11863.method_8501(this.method_11016(), blockState);
                FeederBlockEntity.method_31663((class_1937)this.field_11863, (class_2338)this.method_11016(), (class_2680)blockState);
                mob.feed(feedAmount);
            }
        }
    }

    @NotNull
    public class_1799 method_5438(int slot) {
        return (class_1799)this.items.get(slot);
    }

    @NotNull
    public class_1799 method_5434(int slot, int amount) {
        return class_1262.method_5430(this.items, (int)slot, (int)amount);
    }

    @NotNull
    public class_1799 method_5441(int slot) {
        return class_1262.method_5428(this.items, (int)slot);
    }

    public void method_5447(int slot, class_1799 stack) {
        this.items.set(slot, (Object)stack);
        if (stack.method_7947() > this.method_5444()) {
            stack.method_7939(this.method_5444());
        }
    }

    public boolean method_5443(class_1657 player) {
        return this.field_11863.method_8321(this.field_11867) == this && player.method_5649((double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + 0.5) <= 64.0;
    }

    public void method_5448() {
        this.items.clear();
    }

    public boolean method_5437(int index, class_1799 stack) {
        return FoodMappings.getFoodAmount((class_1935)stack.method_7909(), FOOD_TYPES[index]) > 0;
    }

    public int @NotNull [] method_5494(class_2350 side) {
        return side != class_2350.field_11033 ? SLOTS_TOP : new int[]{};
    }

    public boolean method_5492(int index, class_1799 itemStack, @Nullable class_2350 direction) {
        return this.method_5437(index, itemStack);
    }

    public boolean method_5493(int index, class_1799 stack, class_2350 direction) {
        return false;
    }

    public int getValue(FoodType type) {
        return this.foodStored.get((Object)type);
    }
}

