/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.client.gui.debug.instruction;

import com.github.teamfossilsarcheology.fossil.client.gui.debug.DebugScreen;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.InstructionTab;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.instruction.Instruction;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.instruction.InstructionRenderUtil;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.navigation.PathingDebug;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.navigation.PathingRenderUtil;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.Prehistoric;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4604;
import net.minecraft.class_761;
import software.bernie.geckolib.core.object.Color;

public class InstructionRenderer {
    private static final Map<class_2338, Integer> countAtPos = new Object2IntOpenHashMap();
    private static final List<Pair<class_243, Instruction>> texts = new ArrayList<Pair<class_243, Instruction>>();
    public static class_243 rulerStartPos;
    public static class_243 rulerEndPos;

    public static void render(class_4587 poseStack, class_4597 buffer, float partialTicks, long finishNanoTime, class_4604 frustum) {
        RenderSystem.enableBlend();
        class_310 mc = class_310.method_1551();
        if (InstructionTab.activeEntity != null) {
            Instruction instruction;
            List<Instruction> instructions = InstructionTab.INSTRUCTIONS.get(InstructionTab.activeEntity.method_5667()).instructions();
            countAtPos.clear();
            texts.clear();
            class_2338 currentPos = InstructionTab.activeEntity.method_24515();
            for (int i = 0; i < instructions.size(); ++i) {
                instruction = instructions.get(i);
                if (instruction instanceof Instruction.MoveTo) {
                    Instruction.MoveTo moveTo = (Instruction.MoveTo)instruction;
                    InstructionRenderer.addPosition(poseStack, buffer, instruction, moveTo.target, Color.WHITE);
                    currentPos = moveTo.target;
                    continue;
                }
                if (instruction instanceof Instruction.FlyTo) {
                    Instruction.FlyTo flyTo = (Instruction.FlyTo)instruction;
                    InstructionRenderer.addPosition(poseStack, buffer, instruction, flyTo.target, Color.WHITE);
                    currentPos = flyTo.target;
                    continue;
                }
                if (instruction instanceof Instruction.FlyLand) {
                    Instruction.FlyLand flyLand = (Instruction.FlyLand)instruction;
                    InstructionRenderer.addPosition(poseStack, buffer, instruction, flyLand.target, Color.WHITE);
                    currentPos = flyLand.target;
                    continue;
                }
                if (instruction instanceof Instruction.TeleportTo) {
                    Instruction.TeleportTo teleportTo = (Instruction.TeleportTo)instruction;
                    if (!frustum.method_23093(new class_238(teleportTo.target))) continue;
                    InstructionRenderer.addPosition(poseStack, buffer, instruction, teleportTo.target, Color.PINK);
                    InstructionRenderUtil.renderArrow(poseStack, class_243.method_24955((class_2382)teleportTo.target).method_1031(0.0, 1.0, 0.0), Color.ofRGBA((float)1.0f, (float)1.0f, (float)0.0f, (float)0.5f), -(teleportTo.rotation - 180));
                    currentPos = teleportTo.target;
                    continue;
                }
                if (instruction instanceof Instruction.AttachTo) {
                    Instruction.AttachTo attachTo = (Instruction.AttachTo)instruction;
                    InstructionRenderer.addPosition(poseStack, buffer, instruction, attachTo.target, Color.GREEN);
                    class_243 pos = attachTo.location;
                    class_761.method_22982((class_4587)poseStack, (class_4588)buffer.getBuffer((class_1921)class_1921.field_21695), (class_238)new class_238(pos.field_1352 - 0.05, pos.field_1351, pos.field_1350 - 0.05, pos.field_1352 + 0.05, pos.field_1351 + 0.05, pos.field_1350 + 0.05), (float)1.0f, (float)0.0f, (float)1.0f, (float)1.0f);
                    currentPos = attachTo.target;
                    continue;
                }
                if (instruction instanceof Instruction.LeapLand) {
                    Instruction.LeapLand leapLand = (Instruction.LeapLand)instruction;
                    InstructionRenderer.addPosition(poseStack, buffer, instruction, new class_2338(leapLand.location), Color.GREEN);
                    class_243 pos = leapLand.locationAbove;
                    class_761.method_22982((class_4587)poseStack, (class_4588)buffer.getBuffer((class_1921)class_1921.field_21695), (class_238)new class_238(pos.field_1352 - 0.05, pos.field_1351, pos.field_1350 - 0.05, pos.field_1352 + 0.05, pos.field_1351 + 0.05, pos.field_1350 + 0.05), (float)1.0f, (float)0.0f, (float)1.0f, (float)1.0f);
                    currentPos = new class_2338(leapLand.location);
                    continue;
                }
                if (instruction instanceof Instruction.PlayAnim) {
                    Instruction.PlayAnim playAnim = (Instruction.PlayAnim)instruction;
                    continue;
                }
                if (!(instruction instanceof Instruction.Idle)) continue;
                Instruction.Idle idle = (Instruction.Idle)instruction;
                int stack = countAtPos.compute(currentPos, (blockPos, count) -> count == null ? 1 : count + 1);
                texts.add((Pair<class_243, Instruction>)Pair.of((Object)class_243.method_24953((class_2382)currentPos).method_1031(0.0, 0.5 + (double)stack * 0.2, 0.0), (Object)instruction));
            }
            InstructionRenderUtil.renderTextBatch(poseStack, mc, texts);
            instruction = InstructionTab.highlightInstruction;
            if (instruction instanceof Instruction.MoveTo) {
                Instruction.MoveTo moveTo = (Instruction.MoveTo)instruction;
                InstructionRenderer.addPosition(poseStack, buffer, moveTo, moveTo.target, Color.RED);
            }
            if (InstructionTab.activeEntity != null && frustum.method_23093(InstructionTab.activeEntity.method_5830())) {
                Prehistoric entity = InstructionTab.activeEntity;
                double lerpX = class_3532.method_16436((double)partialTicks, (double)entity.field_6038, (double)entity.method_23317());
                double lerpY = class_3532.method_16436((double)partialTicks, (double)entity.field_5971, (double)entity.method_23318());
                double lerpZ = class_3532.method_16436((double)partialTicks, (double)entity.field_5989, (double)entity.method_23321());
                class_243 pos = new class_243(lerpX, lerpY + (double)entity.method_17682() + 1.0, lerpZ);
                InstructionRenderUtil.renderDownArrow(poseStack, pos, Color.ofRGBA((float)1.0f, (float)1.0f, (float)0.0f, (float)0.5f), Math.max(1.0f, entity.method_17681()), finishNanoTime);
            }
        }
        if (InstructionTab.positionMode == Instruction.Type.FLY_TO) {
            targetPos = PathingDebug.getAirHitResult(mc);
            InstructionRenderUtil.renderWholeBox(poseStack, targetPos, Color.ofRGBA((float)1.0f, (float)0.0f, (float)0.0f, (float)0.5f), finishNanoTime);
            InstructionRenderUtil.renderFloatingText(poseStack, class_310.method_1551(), String.valueOf(PathingDebug.pickBlockOffset), class_243.method_24953((class_2382)targetPos).method_1031(0.0, 0.7, 0.0));
        } else if (InstructionTab.positionMode != Instruction.Type.IDLE) {
            targetPos = PathingDebug.getBlockHitResult(mc);
            InstructionRenderUtil.renderWholeBox(poseStack, targetPos, Color.ofRGBA((float)1.0f, (float)0.0f, (float)0.0f, (float)0.5f), finishNanoTime);
            if (InstructionTab.positionMode == Instruction.Type.TELEPORT_TO) {
                InstructionRenderUtil.renderArrow(poseStack, class_243.method_24955((class_2382)targetPos).method_1031(0.0, 1.0, 0.0), Color.ofRGBA((float)1.0f, (float)0.0f, (float)1.0f, (float)0.5f), InstructionTab.teleportRotation);
            }
            InstructionRenderUtil.renderFloatingText(poseStack, class_310.method_1551(), String.valueOf(PathingDebug.pickBlockOffset), class_243.method_24953((class_2382)targetPos).method_1031(0.0, 0.7, 0.0));
        }
        if (DebugScreen.rulerMode > 0) {
            class_243 pos = PathingDebug.getHitResult(mc);
            class_761.method_22982((class_4587)poseStack, (class_4588)buffer.getBuffer((class_1921)class_1921.field_21695), (class_238)new class_238(pos.field_1352 - 0.05, pos.field_1351, pos.field_1350 - 0.05, pos.field_1352 + 0.05, pos.field_1351 + 0.05, pos.field_1350 + 0.05), (float)1.0f, (float)0.0f, (float)1.0f, (float)1.0f);
        }
        if (rulerStartPos != null) {
            class_761.method_22982((class_4587)poseStack, (class_4588)buffer.getBuffer((class_1921)class_1921.field_21695), (class_238)new class_238(InstructionRenderer.rulerStartPos.field_1352 - 0.05, InstructionRenderer.rulerStartPos.field_1351, InstructionRenderer.rulerStartPos.field_1350 - 0.05, InstructionRenderer.rulerStartPos.field_1352 + 0.05, InstructionRenderer.rulerStartPos.field_1351 + 0.05, InstructionRenderer.rulerStartPos.field_1350 + 0.05), (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f);
        }
        if (rulerEndPos != null) {
            class_761.method_22982((class_4587)poseStack, (class_4588)buffer.getBuffer((class_1921)class_1921.field_21695), (class_238)new class_238(InstructionRenderer.rulerEndPos.field_1352 - 0.05, InstructionRenderer.rulerEndPos.field_1351, InstructionRenderer.rulerEndPos.field_1350 - 0.05, InstructionRenderer.rulerEndPos.field_1352 + 0.05, InstructionRenderer.rulerEndPos.field_1351 + 0.05, InstructionRenderer.rulerEndPos.field_1350 + 0.05), (float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        }
        if (rulerEndPos != null && rulerStartPos != null) {
            class_243 vec = rulerEndPos.method_1020(rulerStartPos);
            PathingRenderUtil.renderLine(poseStack, rulerStartPos, rulerStartPos.method_1019(vec));
            InstructionRenderUtil.renderFloatingText(poseStack, mc, String.valueOf(vec.method_1033()), rulerStartPos.method_1019(vec.method_1021(0.5)).method_1031(0.0, 0.5, 0.0));
        }
    }

    private static void addPosition(class_4587 poseStack, class_4597 buffer, Instruction instruction, class_2338 target, Color color) {
        class_761.method_22982((class_4587)poseStack, (class_4588)buffer.getBuffer((class_1921)class_1921.field_21695), (class_238)new class_238(target), (float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)((float)color.getAlpha() / 255.0f));
        int stack = countAtPos.compute(target, (blockPos, count) -> count == null ? 1 : count + 1);
        texts.add((Pair<class_243, Instruction>)Pair.of((Object)class_243.method_24953((class_2382)target).method_1031(0.0, 0.5 + (double)stack * 0.2, 0.0), (Object)instruction));
    }
}

