/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.ai;

import com.github.teamfossilsarcheology.fossil.entity.ToyBase;
import com.github.teamfossilsarcheology.fossil.entity.animation.ServerAnimationInfo;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.OrderType;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.Prehistoric;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricFlying;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricSwimming;
import com.github.teamfossilsarcheology.fossil.entity.util.Util;
import net.minecraft.class_11;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_238;
import net.minecraft.class_5134;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayGoal
extends class_1352 {
    protected static final long COOLDOWN_BETWEEN_CAN_USE_CHECKS = 20L;
    protected long lastCanUseCheck;
    protected final Prehistoric dino;
    protected final double speedModifier;
    @Nullable
    protected class_11 path;
    protected ToyBase target;
    protected long attackEndTick = -1L;
    protected long attackDamageTick = -1L;

    public PlayGoal(Prehistoric dino, double speedModifier) {
        this.dino = dino;
        this.speedModifier = speedModifier;
    }

    public boolean method_6264() {
        long l = this.dino.field_6002.method_8510();
        if (l - this.lastCanUseCheck < 20L) {
            return false;
        }
        this.lastCanUseCheck = l;
        if (this.dino.isFleeing() || this.dino.method_5968() != null || this.dino.getCurrentOrder() != OrderType.WANDER) {
            return false;
        }
        if (this.dino.moodSystem.getPlayingCooldown() > 0 || this.dino.moodSystem.getMood() >= 100) {
            return false;
        }
        this.target = this.findPlayTarget();
        if (this.target == null) {
            return false;
        }
        this.path = this.dino.method_5942().method_6349((class_1297)this.target, 0);
        if (this.path != null) {
            return true;
        }
        return Util.canReachPrey(this.dino, this.target);
    }

    public boolean method_6266() {
        if (this.dino.field_6002.method_8510() < this.attackEndTick) {
            return true;
        }
        ToyBase currentToyTarget = this.dino.moodSystem.getToyTarget();
        if (currentToyTarget == null) {
            currentToyTarget = this.target;
        }
        if (currentToyTarget == null || this.dino.moodSystem.getPlayingCooldown() > 0) {
            return false;
        }
        double d = this.getFollowDistance();
        if (this.dino.method_5858(currentToyTarget) > d * d || this.dino.getCurrentOrder() != OrderType.WANDER) {
            return false;
        }
        this.dino.moodSystem.setToyTarget(currentToyTarget);
        return true;
    }

    public void method_6269() {
        this.dino.method_5942().method_6334(this.path, this.speedModifier);
        this.dino.moodSystem.setToyTarget(this.target);
        this.attackEndTick = -1L;
        this.attackDamageTick = -1L;
    }

    public void method_6270() {
        this.dino.moodSystem.setToyTarget(null);
        this.target = null;
    }

    public boolean method_38846() {
        return true;
    }

    public void method_6268() {
        this.dino.method_5988().method_6226((class_1297)this.target, 30.0f, 30.0f);
        if (this.dino.method_5942().method_6357() && !Util.canReachPrey(this.dino, this.target)) {
            this.dino.method_5942().method_6335((class_1297)this.target, this.speedModifier);
        }
        this.checkAndPerformAttack(this.target);
    }

    protected void checkAndPerformAttack(ToyBase target) {
        long currentTime = this.dino.field_6002.method_8510();
        if (Util.canReachPrey(this.dino, target)) {
            if (currentTime > this.attackEndTick + 20L) {
                ServerAnimationInfo animation = this.dino.startAttack();
                this.attackDamageTick = (long)((double)currentTime + animation.actionDelay);
                this.attackEndTick = (long)((double)currentTime + animation.animation.length());
                if (this.attackDamageTick > this.attackEndTick) {
                    this.attackDamageTick = this.attackEndTick;
                }
                this.dino.method_5942().method_6340();
            }
            if (this.attackDamageTick > 0L && currentTime == this.attackDamageTick) {
                target.method_5643(class_1282.method_5511((class_1309)this.dino), 0.0f);
                this.attackDamageTick = -1L;
            }
        }
    }

    protected ToyBase findPlayTarget() {
        return Util.getNearestEntity(ToyBase.class, (class_1308)this.dino, this.getTargetSearchArea(this.getFollowDistance()), toyBase -> true);
    }

    @NotNull
    protected class_238 getTargetSearchArea(double targetDistance) {
        double yDist = 4.0;
        if (this.dino instanceof PrehistoricFlying || this.dino instanceof PrehistoricSwimming && this.dino.method_5681()) {
            yDist = targetDistance;
        }
        return this.dino.method_5829().method_1009(targetDistance, yDist, targetDistance);
    }

    protected double getFollowDistance() {
        return this.dino.method_26825(class_5134.field_23717) * 2.0;
    }
}

