/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.ai.anu;

import com.github.teamfossilsarcheology.fossil.entity.ai.anu.AbstractAnuPhaseInstance;
import com.github.teamfossilsarcheology.fossil.entity.ai.anu.AnuPhase;
import com.github.teamfossilsarcheology.fossil.entity.monster.AnuBoss;
import com.github.teamfossilsarcheology.fossil.sounds.ModSounds;
import com.github.teamfossilsarcheology.fossil.util.Version;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1674;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_5819;

public class AnuFlightPhase
extends AbstractAnuPhaseInstance {
    private class_243 targetLocation;
    private int seeTime;
    private int attackTime;
    private int fireballReturnedCount;
    private static final int MAX_ATTACK_TIME = 40;
    private static final int MIN_ATTACK_TIME = 20;

    public AnuFlightPhase(AnuBoss anuBoss) {
        super(anuBoss);
    }

    @Override
    public void doClientTick() {
        for (int i = 0; i < 2; ++i) {
            this.anu.field_6002.method_8406((class_2394)class_2398.field_11251, this.anu.method_23322(0.5), this.anu.method_23319(), this.anu.method_23325(0.5), 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void doServerTick() {
        if (this.fireballReturnedCount == 3) {
            this.anu.phaseSystem.setPhase(AnuPhase.LANDING);
            return;
        }
        if (this.anu.field_6012 % 20 == 0) {
            this.anu.method_6025(2.0f);
        }
        if (!this.anu.method_24828() && this.anu.method_18798().field_1351 < 0.0) {
            this.anu.method_18799(this.anu.method_18798().method_18805(1.0, 0.6, 1.0));
        }
        if (this.targetLocation == null || !this.anu.method_5962().method_6241()) {
            if (this.findRandomPosAwayFromPlayer()) {
                this.anu.method_5942().method_6340();
                this.anu.method_5962().method_6239(this.targetLocation.field_1352, this.targetLocation.field_1351, this.targetLocation.field_1350, 1.0);
            }
        } else {
            class_1657 player = this.getPlayer();
            if (player != null) {
                if (this.targetLocation.method_1020(player.method_19538()).method_37267() < 5.0 && this.findRandomPosAwayFromPlayer()) {
                    this.anu.method_5962().method_6239(this.targetLocation.field_1352, this.targetLocation.field_1351, this.targetLocation.field_1350, 1.0);
                }
                this.throwFireballs(player);
            }
        }
        this.switchPhaseByHealth();
    }

    @Override
    protected void switchPhaseByHealth() {
        AnuPhase newPhase = AnuPhase.byFraction(this.anu.method_6032() / this.anu.method_6063());
        if (newPhase == AnuPhase.DEFENSE || this.anu.field_6002.method_8510() > this.endTime) {
            this.anu.phaseSystem.setPhase(newPhase, 100);
        }
    }

    private void throwFireballs(class_1657 targetPlayer) {
        double dist = this.anu.method_5858((class_1297)targetPlayer);
        boolean hasLineOfSight = this.anu.method_5985().method_6369((class_1297)targetPlayer);
        this.seeTime = hasLineOfSight ? ++this.seeTime : 0;
        --this.attackTime;
        if (this.attackTime == 0) {
            if (!hasLineOfSight) {
                return;
            }
            this.anu.method_7105((class_1309)targetPlayer, 0.0f);
            float distanceFactor = (float)(Math.sqrt(dist) / 25.0);
            this.attackTime = (int)class_3532.method_16439((float)distanceFactor, (float)20.0f, (float)40.0f);
        } else if (this.attackTime < 0) {
            float distanceFactor = (float)(Math.sqrt(dist) / 25.0);
            this.attackTime = (int)class_3532.method_16439((float)distanceFactor, (float)20.0f, (float)40.0f);
        }
    }

    private class_1657 getPlayer() {
        if (Version.debugEnabled() && this.anu.field_6002.method_18460((class_1297)this.anu, 200.0) != null) {
            return this.anu.field_6002.method_18460((class_1297)this.anu, 200.0);
        }
        class_1309 class_13092 = this.anu.method_5968();
        if (class_13092 instanceof class_1657) {
            class_1657 player = (class_1657)class_13092;
            return player;
        }
        return null;
    }

    private boolean findRandomPosAwayFromPlayer() {
        class_1657 player = this.getPlayer();
        for (int i = 0; i < 3; ++i) {
            float r = (float)(25.0 * Math.sqrt(this.anu.method_6051().method_43057()));
            float t = this.anu.method_6051().method_43057() * 2.0f * (float)Math.PI;
            float targetY = class_3532.method_32750((class_5819)this.anu.method_6051(), (float)0.0f, (float)4.0f);
            this.targetLocation = this.anu.getSpawnPos().method_1031((double)(r * class_3532.method_15362((float)t)), (double)targetY, (double)(r * class_3532.method_15374((float)t)));
            if (!this.anu.field_6002.method_22347(new class_2338(this.targetLocation))) continue;
            if (player != null) {
                return this.targetLocation.method_1020(player.method_19538()).method_37267() > 5.0;
            }
            return true;
        }
        return false;
    }

    @Override
    public AnuPhase getPhase() {
        return AnuPhase.FLIGHT;
    }

    @Override
    public void onHurt(class_1282 source, float amount) {
        if (source.method_5526() instanceof class_1674 && source.method_5529() instanceof class_1657) {
            ++this.fireballReturnedCount;
        }
    }

    @Override
    public void end() {
        this.fireballReturnedCount = 0;
    }

    @Override
    public class_3414 getAmbientSound() {
        return (class_3414)ModSounds.ANU_COUGH.get();
    }

    @Override
    public boolean isFlying() {
        return true;
    }
}

