/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.variant;

import com.github.teamfossilsarcheology.fossil.FossilMod;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.Prehistoric;
import com.github.teamfossilsarcheology.fossil.entity.variant.VariantCondition;
import com.github.teamfossilsarcheology.fossil.entity.variant.VariantRegistry;
import com.github.teamfossilsarcheology.fossil.util.Gender;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import net.minecraft.class_2540;
import net.minecraft.class_3518;

public record Variant(String variantId, String textureName, boolean hasBabyTexture, boolean hasTeenTexture, boolean hasGenderTextures, VariantCondition[] conditions) {
    public static Variant readBuf(class_2540 buf) {
        VariantCondition[] conditions = new VariantCondition[buf.method_10816()];
        for (int i = 0; i < conditions.length; ++i) {
            conditions[i] = VariantRegistry.fromNetwork(buf);
        }
        return new Variant(buf.method_19772(), buf.method_19772(), buf.readBoolean(), buf.readBoolean(), buf.readBoolean(), conditions);
    }

    public static void writeBuf(class_2540 buf, Variant variant) {
        buf.method_10804(variant.conditions.length);
        for (VariantCondition condition : variant.conditions) {
            VariantRegistry.toNetwork(buf, condition);
        }
        buf.method_10814(variant.variantId);
        buf.method_10814(variant.textureName);
        buf.writeBoolean(variant.hasBabyTexture);
        buf.writeBoolean(variant.hasTeenTexture);
        buf.writeBoolean(variant.hasGenderTextures);
    }

    public void appendTextureString(StringBuilder builder, Prehistoric entity) {
        builder.append("_");
        builder.append(this.textureName);
        if (this.hasBabyTexture && entity.method_6109()) {
            builder.append("_baby");
        }
        if (this.hasTeenTexture && entity.isTeen()) {
            builder.append("_teen");
        }
        if (this.hasGenderTextures && (!this.hasTeenTexture && entity.isTeen() || entity.isAdult())) {
            if (entity.getGender() == Gender.MALE) {
                builder.append("_male");
            } else {
                builder.append("_female");
            }
        }
    }

    public String getVariantId() {
        return this.variantId;
    }

    static class Deserializer
    implements JsonDeserializer<Variant> {
        Deserializer() {
        }

        public Variant deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject root = json.getAsJsonObject();
            String variantId = class_3518.method_15265((JsonObject)root, (String)"variantId");
            String textureName = class_3518.method_15253((JsonObject)root, (String)"textureName", (String)"");
            JsonArray conditionArray = class_3518.method_15292((JsonObject)root, (String)"conditions", (JsonArray)new JsonArray());
            ArrayList<VariantCondition> conditions = new ArrayList<VariantCondition>();
            for (JsonElement condition : conditionArray) {
                try {
                    conditions.add(VariantCondition.deserialize(condition.getAsJsonObject()));
                }
                catch (JsonSyntaxException e) {
                    FossilMod.LOGGER.error("Could not parse {} condition for variant {}.", (Object)condition, (Object)variantId);
                }
            }
            boolean hasBabyTexture = class_3518.method_15258((JsonObject)root, (String)"hasBabyTexture", (boolean)false);
            boolean hasTeenTexture = class_3518.method_15258((JsonObject)root, (String)"hasTeenTexture", (boolean)false);
            boolean hasGenderTextures = class_3518.method_15258((JsonObject)root, (String)"hasGenderTextures", (boolean)false);
            return new Variant(variantId, textureName, hasBabyTexture, hasTeenTexture, hasGenderTextures, (VariantCondition[])conditions.toArray(VariantCondition[]::new));
        }
    }
}

