/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.block.custom_blocks;

import com.github.teamfossilsarcheology.fossil.tags.ModBlockTags;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FourTallFlowerBlock
extends BushBlock
implements BonemealableBlock {
    public static final IntegerProperty LAYER = IntegerProperty.m_61631_((String)"layer", (int)0, (int)3);
    private final VoxelShape shape;

    public FourTallFlowerBlock(VoxelShape shape) {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76300_).m_60910_().m_60955_().m_60918_(SoundType.f_56740_).m_222979_(BlockBehaviour.OffsetType.XZ));
        this.shape = shape;
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)LAYER, (Comparable)Integer.valueOf(0)));
    }

    protected boolean m_6266_(BlockState state, BlockGetter level, BlockPos pos) {
        return super.m_6266_(state, level, pos) || state.m_60713_(Blocks.f_49992_) && this.m_49966_().m_204336_(ModBlockTags.PLANTABLE_ON_SAND);
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Vec3 vec3 = state.m_60824_(level, pos);
        return this.shape.m_83216_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos blockPos = context.m_8083_();
        Level level = context.m_43725_();
        if (blockPos.m_123342_() < level.m_151558_() - 3 && level.m_8055_(blockPos.m_7494_()).m_60629_(context) && level.m_8055_(blockPos.m_6630_(2)).m_60629_(context) && level.m_8055_(blockPos.m_6630_(3)).m_60629_(context)) {
            return super.m_5573_(context);
        }
        return null;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        level.m_7731_(pos.m_7494_(), (BlockState)this.m_49966_().m_61124_((Property)LAYER, (Comparable)Integer.valueOf(1)), 3);
        level.m_7731_(pos.m_6630_(2), (BlockState)this.m_49966_().m_61124_((Property)LAYER, (Comparable)Integer.valueOf(2)), 3);
        level.m_7731_(pos.m_6630_(3), (BlockState)this.m_49966_().m_61124_((Property)LAYER, (Comparable)Integer.valueOf(3)), 3);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        switch ((Integer)state.m_61143_((Property)LAYER)) {
            case 0: {
                return super.m_7898_(state, level, pos);
            }
            case 1: {
                BlockState blockState = level.m_8055_(pos.m_7495_());
                return blockState.m_60713_((Block)this) && (Integer)blockState.m_61143_((Property)LAYER) == 0;
            }
            case 2: {
                BlockState blockState = level.m_8055_(pos.m_7495_());
                return blockState.m_60713_((Block)this) && (Integer)blockState.m_61143_((Property)LAYER) == 1;
            }
            case 3: {
                BlockState blockState = level.m_8055_(pos.m_7495_());
                return blockState.m_60713_((Block)this) && (Integer)blockState.m_61143_((Property)LAYER) == 2;
            }
        }
        return super.m_7898_(state, level, pos);
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        if (!level.f_46443_) {
            if (player.m_150110_().f_35937_) {
                if ((Integer)state.m_61143_((Property)LAYER) == 0) {
                    for (int i = 0; i < 3; ++i) {
                        if (level.m_8055_(pos.m_6630_(i)).m_60734_() != this) continue;
                        level.m_46961_(pos.m_6630_(i), false);
                    }
                } else {
                    level.m_46961_(pos, false);
                }
            } else {
                FourTallFlowerBlock.m_49881_((BlockState)state, (Level)level, (BlockPos)pos, null, (Entity)player, (ItemStack)player.m_21205_());
            }
        }
        super.m_5707_(level, pos, state, player);
    }

    public void m_6240_(Level level, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, ItemStack tool) {
        super.m_6240_(level, player, pos, Blocks.f_50016_.m_49966_(), blockEntity, tool);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{LAYER});
    }

    public boolean m_7370_(BlockGetter level, BlockPos pos, BlockState state, boolean isClient) {
        return true;
    }

    public boolean m_214167_(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_214148_(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        int maxTries = random.m_188503_(3);
        int tries = 0;
        int timeout = 0;
        while (tries < maxTries && timeout < 101) {
            ++timeout;
            BlockPos tryPos = pos.m_7918_(random.m_188503_(10) - 4, random.m_188503_(8) - 4, random.m_188503_(10) - 4);
            if (!level.m_46859_(tryPos.m_7494_()) || !level.m_46859_(tryPos.m_6630_(2)) || !level.m_46859_(tryPos.m_6630_(3)) || !level.m_46859_(tryPos.m_6630_(4)) || !this.canPlant((Level)level, tryPos)) continue;
            ++tries;
            level.m_7731_(tryPos.m_7494_(), (BlockState)this.m_49966_().m_61124_((Property)LAYER, (Comparable)Integer.valueOf(0)), 2);
            level.m_7731_(tryPos.m_6630_(2), (BlockState)this.m_49966_().m_61124_((Property)LAYER, (Comparable)Integer.valueOf(1)), 2);
            level.m_7731_(tryPos.m_6630_(3), (BlockState)this.m_49966_().m_61124_((Property)LAYER, (Comparable)Integer.valueOf(2)), 2);
            level.m_7731_(tryPos.m_6630_(4), (BlockState)this.m_49966_().m_61124_((Property)LAYER, (Comparable)Integer.valueOf(3)), 2);
        }
    }

    private boolean canPlant(Level level, BlockPos blockPos) {
        return this.m_6266_(level.m_8055_(blockPos), (BlockGetter)level, blockPos);
    }
}

