/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.block.custom_blocks;

import com.github.teamfossilsarcheology.fossil.advancements.ModTriggers;
import com.github.teamfossilsarcheology.fossil.block.entity.AnuBarrierBlockEntity;
import com.github.teamfossilsarcheology.fossil.block.entity.ModBlockEntities;
import com.github.teamfossilsarcheology.fossil.block.entity.SarcophagusBlockEntity;
import com.github.teamfossilsarcheology.fossil.entity.monster.AnuBoss;
import com.github.teamfossilsarcheology.fossil.item.ModItems;
import com.github.teamfossilsarcheology.fossil.world.dimension.ModDimensions;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SarcophagusBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final IntegerProperty LAYER = IntegerProperty.m_61631_((String)"layer", (int)0, (int)2);
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;
    private static final VoxelShape SHAPE = Block.m_49796_((double)1.0, (double)0.0, (double)-1.0, (double)16.0, (double)49.0, (double)17.0);

    public SarcophagusBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)LAYER, (Comparable)Integer.valueOf(0))).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if ((Integer)blockState.m_61143_((Property)LAYER) != 0) {
            BlockPos below = pos.m_6625_(((Integer)blockState.m_61143_((Property)LAYER)).intValue());
            return level.m_8055_(below).m_60664_(level, player, hand, hit.m_82430_(below));
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof SarcophagusBlockEntity) {
            SarcophagusBlockEntity blockEntity2 = (SarcophagusBlockEntity)blockEntity;
            if (blockEntity2.getState() == 0) {
                ItemStack itemStack = player.m_21120_(hand);
                if (itemStack.m_150930_((Item)ModItems.SCARAB_GEM.get())) {
                    blockEntity2.setState(1);
                    level.m_7696_(pos, blockState.m_60734_(), 1, blockEntity2.getState());
                    level.m_46597_(pos, (BlockState)blockState.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(true)));
                    level.m_46597_(pos.m_7494_(), (BlockState)level.m_8055_(pos.m_7494_()).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(true)));
                    level.m_46597_(pos.m_6630_(2), (BlockState)level.m_8055_(pos.m_6630_(2)).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(true)));
                    if (!player.m_150110_().f_35937_) {
                        itemStack.m_41774_(1);
                    }
                    if (!level.f_46443_) {
                        ModTriggers.OPEN_SARCOPHAGUS_TRIGGER.trigger((ServerPlayer)player);
                    }
                }
            } else if (blockEntity2.getState() == 1) {
                blockEntity2.setState(2);
                blockEntity2.setDoorTimer(1);
                level.m_7696_(pos, blockState.m_60734_(), 1, blockEntity2.getState());
                if (!level.f_46443_) {
                    SarcophagusBlock.enableBarriers((ServerLevel)level, pos);
                }
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return super.m_6227_(blockState, level, pos, player, hand, hit);
    }

    private static void enableBarrier(ServerLevel level, BlockPos pos, Set<BlockPos> barriers) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof AnuBarrierBlockEntity) {
            AnuBarrierBlockEntity blockEntity2 = (AnuBarrierBlockEntity)blockEntity;
            blockEntity2.enable();
            barriers.add(pos.m_7949_());
        }
    }

    private static void enableBarriers(ServerLevel level, BlockPos pos) {
        if (level.m_46472_() == ModDimensions.ANU_LAIR) {
            HashSet<BlockPos> barriers = new HashSet<BlockPos>();
            BlockPos.MutableBlockPos mutable = pos.m_122032_();
            int y = pos.m_123342_() - 6;
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                Vec3i dirVec = direction.m_122436_().m_142393_(32);
                Vec3i offsetVec = direction.m_122428_().m_122436_().m_142393_(5);
                SarcophagusBlock.enableBarrier(level, (BlockPos)mutable.m_122178_(pos.m_123341_(), y, pos.m_123343_()).m_122193_(dirVec).m_122193_(offsetVec), barriers);
                SarcophagusBlock.enableBarrier(level, (BlockPos)mutable.m_122184_(0, 10, 0), barriers);
                SarcophagusBlock.enableBarrier(level, (BlockPos)mutable.m_122193_(direction.m_122427_().m_122436_().m_142393_(10)), barriers);
                SarcophagusBlock.enableBarrier(level, (BlockPos)mutable.m_122184_(0, -10, 0), barriers);
            }
            level.m_8895_().m_164855_("anu_lair", (SavedData)AnuBoss.AnuLair.spawned(barriers));
        }
    }

    @NotNull
    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        int layer = (Integer)state.m_61143_((Property)LAYER);
        if (direction.m_122434_() == Direction.Axis.Y && !neighborState.m_60713_((Block)this) && (layer == 1 || layer == 0 && direction == Direction.UP || layer == 2 && direction == Direction.DOWN)) {
            return Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(state, direction, neighborState, level, currentPos, neighborPos);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return SarcophagusBlock.m_152132_(blockEntityType, (BlockEntityType)((BlockEntityType)ModBlockEntities.SARCOPHAGUS.get()), (BlockEntityTicker)(level.f_46443_ ? SarcophagusBlockEntity::clientTick : SarcophagusBlockEntity::serverTick));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new SarcophagusBlockEntity(pos, state);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)super.m_5573_(context).m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        level.m_7731_(pos.m_7494_(), (BlockState)((BlockState)this.m_49966_().m_61124_((Property)LAYER, (Comparable)Integer.valueOf(1))).m_61124_((Property)FACING, (Comparable)((Direction)state.m_61143_((Property)FACING))), 3);
        level.m_7731_(pos.m_6630_(2), (BlockState)((BlockState)this.m_49966_().m_61124_((Property)LAYER, (Comparable)Integer.valueOf(2))).m_61124_((Property)FACING, (Comparable)((Direction)state.m_61143_((Property)FACING))), 3);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        switch ((Integer)state.m_61143_((Property)LAYER)) {
            case 1: {
                BlockState blockState = level.m_8055_(pos.m_7495_());
                return blockState.m_60713_((Block)this) && (Integer)blockState.m_61143_((Property)LAYER) == 0;
            }
            case 2: {
                BlockState blockState = level.m_8055_(pos.m_7495_());
                return blockState.m_60713_((Block)this) && (Integer)blockState.m_61143_((Property)LAYER) == 1;
            }
        }
        return super.m_7898_(state, level, pos);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, LAYER, LIT});
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }

    @NotNull
    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    @NotNull
    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    @NotNull
    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE.m_83216_(0.0, (double)(-((Integer)state.m_61143_((Property)LAYER)).intValue()), 0.0);
    }
}

