/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.block.entity;

import com.github.teamfossilsarcheology.fossil.block.ModBlocks;
import com.github.teamfossilsarcheology.fossil.block.custom_blocks.AnuBarrierFaceBlock;
import com.github.teamfossilsarcheology.fossil.block.custom_blocks.AnuBarrierOriginBlock;
import com.github.teamfossilsarcheology.fossil.block.entity.ModBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnuBarrierBlockEntity
extends BlockEntity {
    public static final int MAX_SIZE = 20;
    public static final int STATE_DISABLED = 0;
    public static final int STATE_ENABLED = 1;
    public static final int STATE_GROWING = 2;
    public static final int STATE_SHRINKING = 3;
    public static final float DURATION = 60.0f;
    public int radius = 1;
    public int height = 1;
    private int state = 0;
    private int barrierTimer;

    public AnuBarrierBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.ANU_BARRIER.get(), blockPos, blockState);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, AnuBarrierBlockEntity blockEntity) {
        AnuBarrierBlockEntity.tick(blockEntity);
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, AnuBarrierBlockEntity blockEntity) {
        AnuBarrierBlockEntity.tick(blockEntity);
    }

    private static void tick(AnuBarrierBlockEntity blockEntity) {
        if (blockEntity.state == 2) {
            ++blockEntity.barrierTimer;
            if ((float)blockEntity.barrierTimer > 60.0f) {
                blockEntity.state = 1;
                blockEntity.m_6596_();
            }
        } else if (blockEntity.state == 3) {
            --blockEntity.barrierTimer;
            if (blockEntity.barrierTimer < 0) {
                blockEntity.state = 0;
                blockEntity.m_6596_();
            }
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("Height", this.height);
        tag.m_128405_("Radius", this.radius);
        tag.m_128405_("State", this.state);
        tag.m_128405_("Timer", this.barrierTimer);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.height = tag.m_128451_("Height");
        this.radius = tag.m_128451_("Radius");
        this.state = tag.m_128451_("State");
        this.barrierTimer = tag.m_128451_("Timer");
    }

    @NotNull
    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    private void spawnBarrier(BlockPos pos, BlockState state) {
        BlockPos pos1;
        Direction direction = ((Direction)state.m_61143_((Property)AnuBarrierOriginBlock.FACING)).m_122427_();
        this.radius = 0;
        this.height = 1;
        while (this.radius < 20 && !this.f_58857_.m_8055_(pos1 = pos.m_5484_(direction, this.radius + 1)).m_60804_((BlockGetter)this.f_58857_, pos1)) {
            ++this.radius;
        }
        while (this.height < 20 && this.f_58857_.m_46859_(pos.m_6630_(this.height))) {
            ++this.height;
        }
        BlockPos.MutableBlockPos mutable = pos.m_122032_();
        for (int y = 0; y < this.height; ++y) {
            for (int x = -this.radius; x <= this.radius; ++x) {
                if (!this.f_58857_.m_46859_((BlockPos)mutable.m_122178_(pos.m_123341_() + direction.m_122429_() * x, pos.m_123342_() + y, pos.m_123343_() + direction.m_122431_() * x))) continue;
                this.f_58857_.m_7731_((BlockPos)mutable, ((AnuBarrierFaceBlock)((Object)ModBlocks.ANU_BARRIER_FACE.get())).m_152465_(state), 18);
            }
        }
    }

    private void destroyBarrier(BlockPos pos, BlockState state) {
        Direction direction = ((Direction)state.m_61143_((Property)AnuBarrierOriginBlock.FACING)).m_122427_();
        BlockPos.MutableBlockPos mutable = pos.m_122032_();
        for (int y = 0; y < this.height; ++y) {
            for (int x = -this.radius; x <= this.radius; ++x) {
                BlockState barrierState = this.f_58857_.m_8055_((BlockPos)mutable.m_122178_(pos.m_123341_() + direction.m_122429_() * x, pos.m_123342_() + y, pos.m_123343_() + direction.m_122431_() * x));
                if (!barrierState.m_60713_((Block)ModBlocks.ANU_BARRIER_FACE.get())) continue;
                this.f_58857_.m_7731_((BlockPos)mutable, Blocks.f_50016_.m_49966_(), 18);
            }
        }
    }

    public boolean isEnabled() {
        return this.state == 2 || this.state == 1;
    }

    public void setEnabled(boolean enabled) {
        if (enabled) {
            this.enable();
        } else {
            this.disable();
        }
    }

    public void enable() {
        if (!this.isEnabled()) {
            this.spawnBarrier(this.m_58899_(), this.m_58900_());
        }
        this.state = 2;
        this.barrierTimer = 0;
        this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 18);
    }

    public void disable() {
        this.state = 3;
        this.destroyBarrier(this.m_58899_(), this.m_58900_());
        this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 18);
    }

    public int getState() {
        return this.state;
    }

    public int getBarrierTimer() {
        return this.barrierTimer;
    }
}

