/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.client.renderer.blockentity;

import com.github.teamfossilsarcheology.fossil.FossilMod;
import com.github.teamfossilsarcheology.fossil.block.custom_blocks.AnuBarrierOriginBlock;
import com.github.teamfossilsarcheology.fossil.block.entity.AnuBarrierBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import java.util.stream.IntStream;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.properties.Property;

public class AnuBarrierRenderer
implements BlockEntityRenderer<AnuBarrierBlockEntity> {
    private static final float TEXTURE_WIDTH = 16.0f;
    private static final float TEXTURE_HEIGHT = 16.0f;
    private static final ResourceLocation[] LOCATIONS = (ResourceLocation[])IntStream.range(1, 32).mapToObj(idx -> FossilMod.location("textures/block/anu_portal/anu_portal_" + idx + ".png")).toArray(ResourceLocation[]::new);

    public AnuBarrierRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(AnuBarrierBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        poseStack.m_85836_();
        Direction direction = (Direction)blockEntity.m_58900_().m_61143_((Property)AnuBarrierOriginBlock.FACING);
        poseStack.m_85837_(0.5, 0.0, 0.5);
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(-direction.m_122435_() + 180.0f));
        poseStack.m_85837_(-0.5, 0.0, -0.5);
        poseStack.m_85841_(0.0625f, 0.0625f, direction.m_122434_() == Direction.Axis.X ? 0.063f : 0.062f);
        int i = (int)(blockEntity.m_58904_().m_46467_() % (long)LOCATIONS.length);
        VertexConsumer vertexConsumer = bufferSource.m_6299_(RenderType.m_110470_((ResourceLocation)LOCATIONS[i]));
        int fixedLight = LevelRenderer.m_109541_((BlockAndTintGetter)blockEntity.m_58904_(), (BlockPos)blockEntity.m_58899_().m_121945_(direction));
        this.renderBarrier(blockEntity, poseStack, vertexConsumer, fixedLight);
        poseStack.m_85849_();
    }

    private void renderBarrier(AnuBarrierBlockEntity blockEntity, PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight) {
        int maxWidth = (blockEntity.radius * 2 + 1) * 16;
        int maxHeight = blockEntity.height * 16;
        if (blockEntity.getState() == 1) {
            this.renderRectangle(poseStack, vertexConsumer, maxWidth, 0.0f, maxHeight, packedLight);
        } else if (blockEntity.getState() != 0) {
            int colCount;
            float step = Mth.m_14179_((float)((float)blockEntity.getBarrierTimer() / 60.0f), (float)0.0f, (float)maxHeight);
            int rowWidth = (int)(2.0f + step * 2.0f);
            int x = colCount = rowWidth / 2;
            int y = 0;
            while (x > 0) {
                if (x * x + y * y > colCount * colCount) {
                    --x;
                    continue;
                }
                int prevY = y;
                boolean done = false;
                while (!done) {
                    if (x * x + ++y * y <= colCount * colCount) continue;
                    done = true;
                    this.renderRectangle(poseStack, vertexConsumer, Math.min(x * 2, maxWidth), prevY, Math.min(y, maxHeight) - prevY, packedLight);
                }
                --x;
            }
        }
    }

    private void renderRectangle(PoseStack poseStack, VertexConsumer vertexConsumer, int width, float y, int height, int packedLight) {
        Matrix4f matrix4f = poseStack.m_85850_().m_85861_();
        Matrix3f matrix3f = poseStack.m_85850_().m_85864_();
        float minX = 8.0f - ((float)width - (float)width / 2.0f);
        float maxX = minX + (float)width;
        float maxY = y + (float)height;
        float offset = -Mth.m_14143_((float)((float)width / 2.0f));
        float minTexX = ((float)width + offset) / 16.0f;
        float maxTexX = offset / 16.0f;
        float minTexY = (16.0f - y) / 16.0f;
        float maxTexY = minTexY - (float)height / 16.0f;
        this.vertex(matrix4f, matrix3f, vertexConsumer, maxX, y, maxTexX, minTexY, packedLight, false);
        this.vertex(matrix4f, matrix3f, vertexConsumer, minX, y, minTexX, minTexY, packedLight, false);
        this.vertex(matrix4f, matrix3f, vertexConsumer, minX, maxY, minTexX, maxTexY, packedLight, false);
        this.vertex(matrix4f, matrix3f, vertexConsumer, maxX, maxY, maxTexX, maxTexY, packedLight, false);
        this.vertex(matrix4f, matrix3f, vertexConsumer, maxX, maxY, maxTexX, maxTexY, packedLight, true);
        this.vertex(matrix4f, matrix3f, vertexConsumer, minX, maxY, minTexX, maxTexY, packedLight, true);
        this.vertex(matrix4f, matrix3f, vertexConsumer, minX, y, minTexX, minTexY, packedLight, true);
        this.vertex(matrix4f, matrix3f, vertexConsumer, maxX, y, maxTexX, minTexY, packedLight, true);
    }

    private void vertex(Matrix4f matrix4f, Matrix3f matrix3f, VertexConsumer vertexConsumer, float x, float y, float u, float v, int n, boolean back) {
        if (back) {
            vertexConsumer.m_85982_(matrix4f, x, y, 8.0f).m_6122_(125, 255, 255, 255).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_85969_(n).m_85977_(matrix3f, 0.0f, 0.0f, -1.0f).m_5752_();
        } else {
            vertexConsumer.m_85982_(matrix4f, x, y, 8.0f).m_6122_(255, 255, 255, 255).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_85969_(n).m_85977_(matrix3f, 0.0f, 0.0f, -1.0f).m_5752_();
        }
    }
}

