/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.client.renderer.entity;

import com.github.teamfossilsarcheology.fossil.client.model.SkeletonModel;
import com.github.teamfossilsarcheology.fossil.entity.PrehistoricSkeleton;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexMultiConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib3.core.util.Color;
import software.bernie.geckolib3.geo.render.built.GeoBone;
import software.bernie.geckolib3.geo.render.built.GeoCube;
import software.bernie.geckolib3.geo.render.built.GeoModel;
import software.bernie.geckolib3.model.provider.GeoModelProvider;
import software.bernie.geckolib3.renderers.geo.IGeoRenderer;
import software.bernie.geckolib3.util.EModelRenderCycle;
import software.bernie.geckolib3.util.IRenderCycle;
import software.bernie.geckolib3.util.RenderUtils;

public class SkeletonRenderer
extends EntityRenderer<PrehistoricSkeleton>
implements IGeoRenderer<PrehistoricSkeleton> {
    private final GeoModelProvider<PrehistoricSkeleton> geoModel;
    private IRenderCycle currentModelRenderCycle = EModelRenderCycle.INITIAL;
    private PrehistoricSkeleton animatable;
    protected Matrix4f dispatchedMat = new Matrix4f();
    protected Matrix4f renderEarlyMat = new Matrix4f();
    private MultiBufferSource rtb;

    public SkeletonRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.geoModel = new SkeletonModel();
    }

    public void renderEarly(PrehistoricSkeleton animatable, PoseStack poseStack, float partialTick, MultiBufferSource bufferSource, VertexConsumer buffer, int packedLight, int packedOverlayIn, float red, float green, float blue, float alpha) {
        this.animatable = animatable;
        this.renderEarlyMat = poseStack.m_85850_().m_85861_().m_27658_();
        this.rtb = bufferSource;
        super.renderEarly((Object)animatable, poseStack, partialTick, bufferSource, buffer, packedLight, packedOverlayIn, red, green, blue, alpha);
    }

    public void render(GeoModel model, PrehistoricSkeleton animatable, float partialTick, RenderType type, PoseStack poseStack, MultiBufferSource bufferSource, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        super.render(model, (Object)animatable, partialTick, type, poseStack, bufferSource, buffer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void render(PrehistoricSkeleton animatable, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        this.setCurrentModelRenderCycle((IRenderCycle)EModelRenderCycle.INITIAL);
        poseStack.m_85836_();
        this.dispatchedMat = poseStack.m_85850_().m_85861_().m_27658_();
        GeoModel model = this.geoModel.getModel(this.geoModel.getModelResource((Object)animatable));
        poseStack.m_85837_(0.0, (double)0.01f, 0.0);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.getTextureLocation(animatable));
        if (!animatable.m_20177_((Player)Minecraft.m_91087_().f_91074_)) {
            poseStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f - animatable.m_146908_()));
            Color renderColor = this.getRenderColor((Object)animatable, partialTick, poseStack, bufferSource, null, packedLight);
            RenderType renderType = this.getRenderType(animatable, partialTick, poseStack, bufferSource, null, packedLight, this.getTextureLocation(animatable));
            VertexConsumer glintBuffer = bufferSource.m_6299_(RenderType.m_110499_());
            VertexConsumer translucentBuffer = bufferSource.m_6299_(RenderType.m_110470_((ResourceLocation)this.getTextureLocation(animatable)));
            this.render(model, animatable, partialTick, renderType, poseStack, bufferSource, glintBuffer != translucentBuffer ? VertexMultiConsumer.m_86168_((VertexConsumer)glintBuffer, (VertexConsumer)translucentBuffer) : null, packedLight, OverlayTexture.m_118093_((int)OverlayTexture.m_118088_((float)0.0f), (int)OverlayTexture.m_118096_((boolean)false)), (float)renderColor.getRed() / 255.0f, (float)renderColor.getGreen() / 255.0f, (float)renderColor.getBlue() / 255.0f, (float)renderColor.getAlpha() / 255.0f);
        }
        poseStack.m_85849_();
        super.m_7392_((Entity)animatable, entityYaw, partialTick, poseStack, bufferSource, packedLight);
    }

    public void renderRecursively(GeoBone bone, PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        boolean rotOverride;
        poseStack.m_85836_();
        RenderUtils.translateMatrixToBone((PoseStack)poseStack, (GeoBone)bone);
        RenderUtils.translateToPivotPoint((PoseStack)poseStack, (GeoBone)bone);
        boolean bl = rotOverride = bone.rotMat != null;
        if (rotOverride) {
            poseStack.m_85850_().m_85861_().m_27644_(bone.rotMat);
            poseStack.m_85850_().m_85864_().m_8178_(new Matrix3f(bone.rotMat));
        } else {
            RenderUtils.rotateMatrixAroundBone((PoseStack)poseStack, (GeoBone)bone);
        }
        RenderUtils.scaleMatrixForBone((PoseStack)poseStack, (GeoBone)bone);
        if (bone.isTrackingXform()) {
            Matrix4f poseState = poseStack.m_85850_().m_85861_().m_27658_();
            Matrix4f localMatrix = RenderUtils.invertAndMultiplyMatrices((Matrix4f)poseState, (Matrix4f)this.dispatchedMat);
            bone.setModelSpaceXform(RenderUtils.invertAndMultiplyMatrices((Matrix4f)poseState, (Matrix4f)this.renderEarlyMat));
            localMatrix.m_27648_(new Vector3f(this.m_7860_(this.animatable, 1.0f)));
            bone.setLocalSpaceXform(localMatrix);
            Matrix4f worldState = localMatrix.m_27658_();
            worldState.m_27648_(new Vector3f(this.animatable.m_20182_()));
            bone.setWorldSpaceXform(worldState);
        }
        RenderUtils.translateAwayFromPivotPoint((PoseStack)poseStack, (GeoBone)bone);
        if (!bone.isHidden) {
            if (!bone.cubesAreHidden()) {
                for (GeoCube geoCube : bone.childCubes) {
                    poseStack.m_85836_();
                    this.renderCube(geoCube, poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
                    poseStack.m_85849_();
                }
            }
            for (GeoBone childBone : bone.childBones) {
                this.renderRecursively(childBone, poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
            }
        }
        poseStack.m_85849_();
    }

    public RenderType getRenderType(PrehistoricSkeleton animatable, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, VertexConsumer buffer, int packedLight, ResourceLocation texture) {
        return RenderType.m_110458_((ResourceLocation)texture);
    }

    public int getInstanceId(PrehistoricSkeleton entity) {
        return entity.m_19879_();
    }

    public float getWidthScale(PrehistoricSkeleton entity) {
        return entity.getScale();
    }

    public float getHeightScale(PrehistoricSkeleton entity) {
        return entity.getScale();
    }

    protected boolean shouldShowName(PrehistoricSkeleton entity) {
        return false;
    }

    public GeoModelProvider<PrehistoricSkeleton> getGeoModelProvider() {
        return this.geoModel;
    }

    @NotNull
    public ResourceLocation getTextureLocation(PrehistoricSkeleton entity) {
        return this.geoModel.getTextureResource((Object)entity);
    }

    public void setCurrentRTB(MultiBufferSource bufferSource) {
        this.rtb = bufferSource;
    }

    public MultiBufferSource getCurrentRTB() {
        return this.rtb;
    }

    @NotNull
    public IRenderCycle getCurrentModelRenderCycle() {
        return this.currentModelRenderCycle;
    }

    public void setCurrentModelRenderCycle(IRenderCycle currentModelRenderCycle) {
        this.currentModelRenderCycle = currentModelRenderCycle;
    }
}

