/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.prehistoric;

import com.github.teamfossilsarcheology.fossil.FossilMod;
import com.github.teamfossilsarcheology.fossil.entity.ai.FleeBattleGoal;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.Prehistoric;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricEntityInfo;
import com.github.teamfossilsarcheology.fossil.sounds.ModSounds;
import com.github.teamfossilsarcheology.fossil.util.Gender;
import java.util.EnumSet;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.util.AirAndWaterRandomPos;
import net.minecraft.world.entity.ai.util.HoverRandomPos;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Arthropleura
extends Prehistoric {
    public static final EntityDataAccessor<Boolean> IS_BEE = SynchedEntityData.m_135353_(Arthropleura.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private MoveControl oldMoveControl;
    private LookControl oldLookControl;
    private final TemptGoal temptGoal = new TemptGoal((PathfinderMob)this, 1.25, Ingredient.m_204132_((TagKey)ItemTags.f_13149_), false);
    private final BeeWanderGoal wanderGoal = new BeeWanderGoal();

    public Arthropleura(EntityType<Arthropleura> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(3, (Goal)new FleeBattleGoal(this, 1.0));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_BEE, (Object)false);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("Bee", this.isBee());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.f_19804_.m_135381_(IS_BEE, (Object)compound.m_128471_("Bee"));
    }

    public void m_6593_(@Nullable Component name) {
        if (name != null && Objects.equals(ChatFormatting.m_126649_((String)name.getString()), "Bee")) {
            this.f_19804_.m_135381_(IS_BEE, (Object)true);
            this.f_21344_.m_26573_();
            this.m_20256_(Vec3.f_82478_);
            this.oldMoveControl = this.f_21342_;
            this.oldLookControl = this.f_21365_;
            this.f_21342_ = new FlyingMoveControl((Mob)this, 20, true);
            this.f_21365_ = new LookControl((Mob)this);
            FlyingPathNavigation flyingPathNavigation = new FlyingPathNavigation((Mob)this, this.f_19853_){

                public boolean m_6342_(BlockPos pos) {
                    return !this.f_26495_.m_8055_(pos.m_7495_()).m_60795_();
                }
            };
            flyingPathNavigation.m_26440_(false);
            flyingPathNavigation.m_7008_(false);
            flyingPathNavigation.m_26443_(true);
            this.f_21344_ = flyingPathNavigation;
            this.f_21345_.m_25352_(3, (Goal)this.temptGoal);
            this.f_21345_.m_25352_(19, (Goal)this.wanderGoal);
        } else if (Objects.equals(ChatFormatting.m_126649_((String)this.m_7755_().getString()), "Bee")) {
            this.f_21344_.m_26573_();
            this.m_20256_(Vec3.f_82478_);
            this.f_19804_.m_135381_(IS_BEE, (Object)false);
            this.f_21342_ = this.oldMoveControl;
            this.f_21365_ = this.oldLookControl;
            this.f_21344_ = this.m_6037_(this.f_19853_);
            this.f_21345_.m_25363_((Goal)this.temptGoal);
            this.f_21345_.m_25363_((Goal)this.wanderGoal);
        }
        super.m_6593_(name);
    }

    public boolean isBee() {
        return (Boolean)this.f_19804_.m_135370_(IS_BEE);
    }

    @Override
    public float m_5610_(BlockPos pos, LevelReader level) {
        if (this.isBee()) {
            if (level.m_8055_(pos).m_60795_()) {
                return 10.0f;
            }
            return 0.0f;
        }
        return super.m_5610_(pos, level);
    }

    @Override
    public void refreshTexturePath() {
        if (!this.f_19853_.f_46443_) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("textures/entity/arthropleura/arthropleura");
        if (this.m_6162_()) {
            builder.append("_baby");
        }
        if (!this.hasTeenTexture() && this.isTeen() || this.isAdult()) {
            if (this.getGender() == Gender.MALE) {
                builder.append("_male");
            } else {
                builder.append("_female");
            }
        }
        builder.append(".png");
        this.textureLocation = FossilMod.location(builder.toString());
    }

    @Override
    public PrehistoricEntityInfo info() {
        return PrehistoricEntityInfo.ARTHROPLEURA;
    }

    @NotNull
    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    @Override
    public Item getOrderItem() {
        return Items.f_42500_;
    }

    @Override
    public boolean m_142535_(float distance, float damageMultiplier, DamageSource source) {
        if (this.isBee()) {
            return false;
        }
        return super.m_142535_(distance, damageMultiplier, source);
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return this.isBee() ? SoundEvents.f_11691_ : (SoundEvent)ModSounds.ARTHROPLEURA_AMBIENT.get();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSource) {
        return this.isBee() ? SoundEvents.f_11741_ : (SoundEvent)ModSounds.ARTHROPLEURA_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return this.isBee() ? SoundEvents.f_11740_ : (SoundEvent)ModSounds.ARTHROPLEURA_DEATH.get();
    }

    @Override
    protected float m_6121_() {
        return this.isBee() ? super.m_6121_() * 2.0f : super.m_6121_() * 0.75f;
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        if (!this.isBee()) {
            this.m_5496_((SoundEvent)ModSounds.ARTHROPLEURA_WALK.get(), 0.15f, 1.0f);
        }
    }

    class BeeWanderGoal
    extends Goal {
        BeeWanderGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return Arthropleura.this.f_21344_.m_26571_() && Arthropleura.this.f_19796_.m_188503_(10) == 0;
        }

        public boolean m_8045_() {
            return Arthropleura.this.f_21344_.m_26572_();
        }

        public void m_8056_() {
            Vec3 vec3 = this.findPos();
            if (vec3 != null) {
                Arthropleura.this.f_21344_.m_26536_(Arthropleura.this.f_21344_.m_7864_(new BlockPos(vec3), 1), 1.0);
            }
        }

        @Nullable
        private Vec3 findPos() {
            Vec3 vec32 = Arthropleura.this.m_20252_(0.0f);
            int i = 8;
            Vec3 vec33 = HoverRandomPos.m_148465_((PathfinderMob)Arthropleura.this, (int)i, (int)7, (double)vec32.f_82479_, (double)vec32.f_82481_, (float)1.5707964f, (int)3, (int)1);
            if (vec33 != null) {
                return vec33;
            }
            return AirAndWaterRandomPos.m_148357_((PathfinderMob)Arthropleura.this, (int)i, (int)4, (int)-2, (double)vec32.f_82479_, (double)vec32.f_82481_, (double)1.5707963705062866);
        }
    }
}

