/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.prehistoric.base;

import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.EntityInfo;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricMobType;
import com.github.teamfossilsarcheology.fossil.food.Diet;
import com.github.teamfossilsarcheology.fossil.item.BirdEggItem;
import com.github.teamfossilsarcheology.fossil.item.DNAItem;
import com.github.teamfossilsarcheology.fossil.item.FishEggItem;
import com.github.teamfossilsarcheology.fossil.item.MammalEmbryoItem;
import com.github.teamfossilsarcheology.fossil.item.ModItems;
import com.github.teamfossilsarcheology.fossil.item.ModTabs;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.Nullable;

public enum VanillaEntityInfo implements EntityInfo
{
    AXOLOTL((EntityType<? extends Mob>)EntityType.f_147039_, PrehistoricMobType.FISH, Diet.INSECTIVORE),
    BAT((EntityType<? extends Mob>)EntityType.f_20549_, PrehistoricMobType.MAMMAL, Diet.INSECTIVORE),
    BEE((EntityType<? extends Mob>)EntityType.f_20549_, PrehistoricMobType.OTHER, Diet.HERBIVORE),
    CAT((EntityType<? extends Mob>)EntityType.f_20553_, PrehistoricMobType.MAMMAL, Diet.CARNIVORE),
    CHICKEN((EntityType<? extends Mob>)EntityType.f_20555_, PrehistoricMobType.VANILLA_BIRD, Diet.HERBIVORE),
    COD((EntityType<? extends Mob>)EntityType.f_20556_, PrehistoricMobType.FISH, Diet.PISCI_CARNIVORE),
    COW((EntityType<? extends Mob>)EntityType.f_20557_, PrehistoricMobType.MAMMAL, Diet.HERBIVORE),
    DOLPHIN((EntityType<? extends Mob>)EntityType.f_20559_, PrehistoricMobType.MAMMAL, Diet.PISCI_CARNIVORE),
    DONKEY((EntityType<? extends Mob>)EntityType.f_20560_, PrehistoricMobType.MAMMAL, Diet.HERBIVORE),
    FOX((EntityType<? extends Mob>)EntityType.f_20452_, PrehistoricMobType.MAMMAL, Diet.OMNIVORE),
    FROG((EntityType<? extends Mob>)EntityType.f_217012_, PrehistoricMobType.OTHER, Diet.HERBIVORE),
    GOAT((EntityType<? extends Mob>)EntityType.f_147035_, PrehistoricMobType.MAMMAL, Diet.HERBIVORE),
    GLOW_SQUID((EntityType<? extends Mob>)EntityType.f_147034_, PrehistoricMobType.FISH, Diet.PISCI_CARNIVORE),
    HOGLIN((EntityType<? extends Mob>)EntityType.f_20456_, PrehistoricMobType.MAMMAL, Diet.OMNIVORE),
    HORSE((EntityType<? extends Mob>)EntityType.f_20457_, PrehistoricMobType.MAMMAL, Diet.HERBIVORE),
    LLAMA((EntityType<? extends Mob>)EntityType.f_20466_, PrehistoricMobType.MAMMAL, Diet.HERBIVORE),
    MOOSHROOM((EntityType<? extends Mob>)EntityType.f_20504_, PrehistoricMobType.MAMMAL, Diet.HERBIVORE),
    OCELOT((EntityType<? extends Mob>)EntityType.f_20505_, PrehistoricMobType.MAMMAL, Diet.CARNIVORE),
    PANDA((EntityType<? extends Mob>)EntityType.f_20507_, PrehistoricMobType.MAMMAL, Diet.HERBIVORE),
    PARROT((EntityType<? extends Mob>)EntityType.f_20508_, PrehistoricMobType.VANILLA_BIRD, Diet.HERBIVORE),
    PIG((EntityType<? extends Mob>)EntityType.f_20510_, PrehistoricMobType.MAMMAL, Diet.OMNIVORE),
    POLAR_BEAR((EntityType<? extends Mob>)EntityType.f_20514_, PrehistoricMobType.MAMMAL, Diet.HERBIVORE),
    PUFFERFISH((EntityType<? extends Mob>)EntityType.f_20516_, PrehistoricMobType.FISH, Diet.OMNIVORE),
    RABBIT((EntityType<? extends Mob>)EntityType.f_20517_, PrehistoricMobType.MAMMAL, Diet.HERBIVORE),
    SALMON((EntityType<? extends Mob>)EntityType.f_20519_, PrehistoricMobType.FISH, Diet.PISCI_CARNIVORE),
    SHEEP((EntityType<? extends Mob>)EntityType.f_20520_, PrehistoricMobType.MAMMAL, Diet.HERBIVORE),
    SQUID((EntityType<? extends Mob>)EntityType.f_20480_, PrehistoricMobType.FISH, Diet.PISCI_CARNIVORE),
    STRIDER((EntityType<? extends Mob>)EntityType.f_20482_, PrehistoricMobType.MAMMAL, Diet.HERBIVORE),
    TROPICAL_FISH((EntityType<? extends Mob>)EntityType.f_20489_, PrehistoricMobType.FISH, Diet.PISCI_CARNIVORE),
    TURTLE((EntityType<? extends Mob>)EntityType.f_20490_, PrehistoricMobType.OTHER, Diet.HERBIVORE),
    WOLF((EntityType<? extends Mob>)EntityType.f_20499_, PrehistoricMobType.MAMMAL, Diet.CARNIVORE);

    private final EntityType<? extends Entity> entityType;
    public final PrehistoricMobType mobType;
    public final Diet diet;
    public final String resourceName;
    public final Supplier<Component> displayName;
    public Item dnaItem;
    public Item eggItem;
    public Item embryoItem;
    public Item cultivatedBirdEggItem;

    private VanillaEntityInfo(EntityType<? extends Mob> entityType, PrehistoricMobType mobType, Diet diet) {
        this.entityType = entityType;
        this.mobType = mobType;
        this.diet = diet;
        this.resourceName = this.name().toLowerCase(Locale.ROOT);
        this.displayName = () -> Component.m_237115_((String)("entity.minecraft." + this.resourceName));
    }

    public static void register() {
        for (VanillaEntityInfo info : VanillaEntityInfo.values()) {
            ModItems.ITEMS.register(info.resourceName + "_dna", () -> new DNAItem(info)).listen(item -> {
                info.dnaItem = item;
            });
            if (info.mobType == PrehistoricMobType.FISH) {
                VanillaEntityInfo.registerItem("egg_item", info, properties -> new FishEggItem(info), item -> {
                    info.eggItem = item;
                });
                continue;
            }
            if (info.mobType == PrehistoricMobType.MAMMAL) {
                VanillaEntityInfo.registerItem("syringe", info, properties -> new MammalEmbryoItem(info), item -> {
                    info.embryoItem = item;
                });
                continue;
            }
            if (info.mobType != PrehistoricMobType.VANILLA_BIRD) continue;
            VanillaEntityInfo.registerItem("egg_item", info, properties -> new BirdEggItem((EntityInfo)info, true), item -> {
                info.cultivatedBirdEggItem = item;
            });
        }
    }

    private static void registerItem(String name, VanillaEntityInfo info, Function<Item.Properties, Item> item, Consumer<Item> listener) {
        ModItems.ITEMS.register(name + "_" + info.resourceName, () -> (Item)item.apply(new Item.Properties().m_41491_(ModTabs.FA_MOB_ITEM_TAB))).listen(listener);
    }

    @Override
    public EntityType<? extends Entity> entityType() {
        return this.entityType;
    }

    @Override
    public PrehistoricMobType mobType() {
        return this.mobType;
    }

    @Override
    @Nullable
    public Item getDNAResult() {
        if (this.eggItem != null) {
            return this.eggItem;
        }
        if (this.embryoItem != null) {
            return this.embryoItem;
        }
        if (this.cultivatedBirdEggItem != null) {
            return this.cultivatedBirdEggItem;
        }
        return null;
    }

    @Override
    public Supplier<Component> displayName() {
        return this.displayName;
    }

    @Override
    public Item dnaItem() {
        return this.dnaItem;
    }
}

