/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.prehistoric.swimming;

import com.github.teamfossilsarcheology.fossil.entity.ai.DinoHurtByTargetGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.DinoOwnerHurtByTargetGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.DinoOwnerHurtTargetGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.LeaveWaterGoal;
import com.github.teamfossilsarcheology.fossil.entity.animation.AnimationCategory;
import com.github.teamfossilsarcheology.fossil.entity.animation.AnimationInfo;
import com.github.teamfossilsarcheology.fossil.entity.animation.AnimationLogic;
import com.github.teamfossilsarcheology.fossil.entity.animation.PausableAnimationController;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.Prehistoric;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricEntityInfo;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricSwimming;
import com.github.teamfossilsarcheology.fossil.item.ModItems;
import com.github.teamfossilsarcheology.fossil.sounds.ModSounds;
import java.util.Optional;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;

public class Spinosaurus
extends PrehistoricSwimming {
    public static final String GRAB = "animation.spinosaurus.grab";
    public static final String IDLE = "animation.spinosaurus.idle";
    public static final String IDLE_WATER = "animation.spinosaurus.idle_water";
    public static final String IDLE_WATER_FLOAT = "animation.spinosaurus.idle_water_float";
    public static final String SWIM_FLOATING = "animation.spinosaurus.swim_floating";
    public static final String SWIM_UNDERWATER = "animation.spinosaurus.swim_underwater";
    public static final String SWIM_GROUND = "animation.spinosaurus.swim_ground";
    private final SpinoAnimationLogic animationLogic = new SpinoAnimationLogic(this);

    public Spinosaurus(EntityType<Spinosaurus> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(21, new LeaveWaterGoal<Spinosaurus>(this, 1.0));
        this.f_21346_.m_25352_(1, (Goal)new DinoOwnerHurtByTargetGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new DinoOwnerHurtTargetGoal(this));
        this.f_21346_.m_25352_(3, (Goal)new DinoHurtByTargetGoal(this));
    }

    @Override
    public PrehistoricEntityInfo info() {
        return PrehistoricEntityInfo.SPINOSAURUS;
    }

    @Override
    public Item getOrderItem() {
        return (Item)ModItems.SKULL_STICK.get();
    }

    @Override
    public float getTargetScale() {
        return 1.5f;
    }

    @Override
    public float grabTargetSize() {
        return this.m_20205_();
    }

    @Override
    @NotNull
    public AnimationInfo nextGrabbingAnimation() {
        return this.getAllAnimations().get(GRAB);
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.SPINOSAURUS_AMBIENT.get();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)ModSounds.SPINOSAURUS_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.SPINOSAURUS_DEATH.get();
    }

    @Override
    public AnimationLogic<Prehistoric> getAnimationLogic() {
        return this.animationLogic;
    }

    @Override
    public void registerControllers(AnimationData data) {
        PausableAnimationController<Spinosaurus> controller = new PausableAnimationController<Spinosaurus>(this, "Movement/Idle", 5.0f, this.animationLogic::spinoPredicate);
        this.registerEatingListeners(controller);
        data.addAnimationController(controller);
        data.addAnimationController(new PausableAnimationController<Spinosaurus>(this, "Attack", 0.0f, this.getAnimationLogic()::grabAttackPredicate));
    }

    static class SpinoAnimationLogic
    extends AnimationLogic<Prehistoric> {
        public SpinoAnimationLogic(PrehistoricSwimming entity) {
            super(entity);
        }

        public PlayState spinoPredicate(AnimationEvent<PrehistoricSwimming> event) {
            if (this.isBlocked()) {
                return PlayState.STOP;
            }
            AnimationController controller = event.getController();
            if (this.tryNextAnimation(controller)) {
                return PlayState.CONTINUE;
            }
            Optional<AnimationLogic.ActiveAnimationInfo> activeAnimation = this.getActiveAnimation(controller.getName());
            if (activeAnimation.isPresent() && this.tryForcedAnimation(event, activeAnimation.get())) {
                return PlayState.CONTINUE;
            }
            double animationSpeed = 1.0;
            if (((PrehistoricSwimming)event.getAnimatable()).isBeached()) {
                this.addActiveAnimation(controller.getName(), AnimationCategory.BEACHED);
            } else if (((Prehistoric)this.entity).m_5803_()) {
                this.addActiveAnimation(controller.getName(), AnimationCategory.SLEEP);
            } else if (event.isMoving()) {
                if (((Prehistoric)this.entity).m_20069_()) {
                    boolean onGround;
                    boolean bl = onGround = ((Prehistoric)this.entity).m_20186_() - Math.floor(((Prehistoric)this.entity).m_20186_()) < 0.05 && ((Prehistoric)this.entity).f_19853_.m_6425_(((Prehistoric)this.entity).m_20183_().m_7495_()).m_76178_();
                    if (((Prehistoric)this.entity).m_204029_(FluidTags.f_13131_)) {
                        if (onGround) {
                            this.addActiveAnimation(controller.getName(), ((Prehistoric)this.entity).getAnimation((String)Spinosaurus.SWIM_GROUND).animation, AnimationCategory.SWIM, false);
                        } else {
                            this.addActiveAnimation(controller.getName(), ((Prehistoric)this.entity).getAnimation((String)Spinosaurus.SWIM_UNDERWATER).animation, AnimationCategory.SWIM, false);
                        }
                    } else if (onGround) {
                        animationSpeed = this.addMovementAnimation(event, false);
                    } else {
                        this.addActiveAnimation(controller.getName(), ((Prehistoric)this.entity).getAnimation((String)Spinosaurus.SWIM_FLOATING).animation, AnimationCategory.SWIM, false);
                    }
                } else {
                    animationSpeed = this.addMovementAnimation(event, false);
                }
            } else if (((PrehistoricSwimming)event.getAnimatable()).isWeak()) {
                this.addActiveAnimation(controller.getName(), AnimationCategory.KNOCKOUT);
            } else if (((Prehistoric)this.entity).m_20069_()) {
                if (((Prehistoric)this.entity).m_204029_(FluidTags.f_13131_)) {
                    this.addActiveAnimation(controller.getName(), ((Prehistoric)this.entity).getAnimation((String)Spinosaurus.IDLE_WATER).animation, AnimationCategory.IDLE, false);
                } else {
                    this.addActiveAnimation(controller.getName(), ((Prehistoric)this.entity).getAnimation((String)Spinosaurus.IDLE_WATER_FLOAT).animation, AnimationCategory.IDLE, false);
                }
            } else {
                this.addActiveAnimation(controller.getName(), ((Prehistoric)this.entity).getAnimation((String)Spinosaurus.IDLE).animation, AnimationCategory.IDLE, false);
            }
            SpinoAnimationLogic.setAnimationSpeed(controller, animationSpeed, event.getAnimationTick());
            Optional<AnimationLogic.ActiveAnimationInfo> newAnimation = this.getActiveAnimation(controller.getName());
            if (newAnimation.isPresent()) {
                controller.setAnimation(new AnimationBuilder().addAnimation(newAnimation.get().animationName(), (ILoopType)(newAnimation.get().loop() ? ILoopType.EDefaultLoopTypes.LOOP : ILoopType.EDefaultLoopTypes.PLAY_ONCE)));
            }
            return PlayState.CONTINUE;
        }
    }
}

