/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.prehistoric.system;

import com.github.teamfossilsarcheology.fossil.entity.ToyBase;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.Prehistoric;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricMoodType;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.system.AISystem;
import com.github.teamfossilsarcheology.fossil.tags.ModBlockTags;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.state.BlockState;

public class MoodSystem
extends AISystem {
    private int moodCheckCooldown = 100;
    private int playingCooldown;
    private ToyBase toyTarget;

    public MoodSystem(Prehistoric prehistoric) {
        super(prehistoric);
        this.playingCooldown = prehistoric.m_217043_().m_188503_(6000) + 6000;
    }

    public static boolean arePlantsNearby(Entity entity, int range) {
        for (int i = Mth.m_14107_((double)(entity.m_20185_() - (double)range)); i < Mth.m_14165_((double)(entity.m_20185_() + (double)range)); ++i) {
            for (int j = Mth.m_14107_((double)(entity.m_20186_() - (double)range / 2.0)); j < Mth.m_14165_((double)(entity.m_20186_() + (double)range / 2.0)); ++j) {
                for (int k = Mth.m_14107_((double)(entity.m_20189_() - (double)range)); k < Mth.m_14165_((double)(entity.m_20189_() + (double)range)); ++k) {
                    if (!((double)j <= (double)entity.f_19853_.m_141928_() + 1.0) || !MoodSystem.isPlantBlock(entity.f_19853_.m_8055_(new BlockPos(i, j, k)))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isPlantBlock(BlockState block) {
        return block.m_204336_(ModBlockTags.MOOD_BONUS);
    }

    public PrehistoricMoodType getMoodFace() {
        int mood = this.getMood();
        if (mood >= 100) {
            return PrehistoricMoodType.HAPPY;
        }
        if (mood >= 50) {
            return PrehistoricMoodType.CONTENT;
        }
        if (mood <= -100) {
            return PrehistoricMoodType.ANGRY;
        }
        if (mood <= -50) {
            return PrehistoricMoodType.SAD;
        }
        return PrehistoricMoodType.CALM;
    }

    public int getMoodPosition() {
        return (int)(71.0 * -((double)this.getMood() * 0.01));
    }

    public int getMood() {
        return Mth.m_14045_((int)((Integer)this.mob.m_20088_().m_135370_(Prehistoric.MOOD)), (int)-100, (int)100);
    }

    public void setMood(int mood) {
        this.mob.m_20088_().m_135381_(Prehistoric.MOOD, (Object)Mth.m_14045_((int)mood, (int)-100, (int)100));
    }

    public void increaseMood(int mood) {
        this.setMood(this.getMood() + mood);
    }

    public void doMoodCheck() {
        int overallMoodAddition = 0;
        overallMoodAddition = MoodSystem.arePlantsNearby((Entity)this.mob, 16) ? (overallMoodAddition += 50) : (overallMoodAddition -= 50);
        overallMoodAddition = this.mob.getNearbySpeciesMembers(40).size() < this.mob.data().maxPopulation() ? (overallMoodAddition += 50) : (overallMoodAddition -= 50);
        this.setMood(this.getMood() + overallMoodAddition);
    }

    public int getPlayingCooldown() {
        return this.playingCooldown;
    }

    public void setPlayingCooldown(int ticks) {
        this.playingCooldown = ticks;
    }

    public void useToy(int playBonus) {
        if (this.getPlayingCooldown() == 0) {
            this.setMood(this.getMood() + playBonus);
            this.mob.f_19853_.m_7605_((Entity)this.mob, (byte)65);
            this.setPlayingCooldown(this.mob.m_217043_().m_188503_(600) + 600);
        }
    }

    @Override
    public void serverTick() {
        if (this.getMood() > 100) {
            this.setMood(100);
        }
        if (this.getMood() < -100) {
            this.setMood(-100);
        }
        if (this.mob.isDeadlyHungry() && this.getMood() > -50) {
            this.setMood(-50);
        }
        if (this.getPlayingCooldown() > 0) {
            this.setPlayingCooldown(this.getPlayingCooldown() - 1);
        }
        if (this.moodCheckCooldown <= 0) {
            this.doMoodCheck();
            this.moodCheckCooldown = 3000 + this.mob.m_217043_().m_188503_(5000);
        }
        --this.moodCheckCooldown;
    }

    public void setToyTarget(ToyBase toyTarget) {
        this.toyTarget = toyTarget;
    }

    public ToyBase getToyTarget() {
        return this.toyTarget;
    }

    @Override
    public void saveAdditional(CompoundTag tag) {
        tag.m_128405_("Mood", this.getMood());
        tag.m_128405_("PlayingCooldown", this.getPlayingCooldown());
        tag.m_128405_("MoodCheckCooldown", this.moodCheckCooldown);
    }

    @Override
    public void load(CompoundTag tag) {
        if (tag.m_128441_("Mood")) {
            this.setMood(tag.m_128451_("Mood"));
        }
        if (tag.m_128441_("PlayingCooldown")) {
            this.setPlayingCooldown(tag.m_128451_("PlayingCooldown"));
        }
        if (tag.m_128441_("MoodCheckCooldown")) {
            this.moodCheckCooldown = tag.m_128451_("MoodCheckCooldown");
        }
    }
}

