/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.util;

import com.github.teamfossilsarcheology.fossil.client.gui.debug.InstructionTab;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.instruction.Instruction;
import com.github.teamfossilsarcheology.fossil.entity.ai.navigation.AmphibiousPathNavigation;
import com.github.teamfossilsarcheology.fossil.entity.animation.AnimationCategory;
import com.github.teamfossilsarcheology.fossil.entity.animation.AnimationLogic;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.Parasaurolophus;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.Prehistoric;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricFlying;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricLeaping;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.swimming.Meganeura;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.system.AISystem;
import com.github.teamfossilsarcheology.fossil.network.MessageHandler;
import com.github.teamfossilsarcheology.fossil.network.debug.InstructionMessage;
import com.github.teamfossilsarcheology.fossil.util.Version;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;

public class InstructionSystem
extends AISystem {
    private final List<Instruction> instructions = new ObjectArrayList();
    private int index = -1;
    private boolean shouldLoop;
    private int tries;
    private long endTick;
    private long delayTick;
    private boolean breachTargetReached;
    private boolean attached;
    private AnimationLogic.ActiveAnimationInfo activeAnim;
    private long animCount;

    public InstructionSystem(Prehistoric entity) {
        super(entity);
    }

    @Override
    public void serverTick() {
        if (this.instructions.isEmpty() || this.index >= this.instructions.size() || !Version.debugEnabled()) {
            return;
        }
        if (!this.tickRunning()) {
            this.startNext();
        }
    }

    private boolean tickRunning() {
        Prehistoric prehistoric;
        boolean debug = false;
        Instruction current = this.instructions.get(this.index);
        if (this.mob.isHungry()) {
            this.mob.setHunger(this.mob.getMaxHunger());
        }
        if ((prehistoric = this.mob) instanceof Parasaurolophus) {
            Parasaurolophus parasaurolophus = (Parasaurolophus)prehistoric;
            parasaurolophus.setStanding(false);
        }
        if (current instanceof Instruction.MoveTo) {
            Instruction.MoveTo moveTo = (Instruction.MoveTo)current;
            return this.tryUpdatePath(moveTo);
        }
        if (current instanceof Instruction.FlyTo) {
            Instruction.FlyTo flyTo = (Instruction.FlyTo)current;
            Prehistoric prehistoric2 = this.mob;
            if (prehistoric2 instanceof PrehistoricFlying) {
                PrehistoricFlying flying = (PrehistoricFlying)prehistoric2;
                if (flying.isUsingStuckNavigation()) {
                    return !flying.m_21573_().m_26571_();
                }
                return flying.m_21566_().m_24995_();
            }
            return true;
        }
        if (current instanceof Instruction.FlyLand) {
            Instruction.FlyLand flyLand = (Instruction.FlyLand)current;
            Prehistoric prehistoric3 = this.mob;
            if (prehistoric3 instanceof PrehistoricFlying) {
                PrehistoricFlying flying = (PrehistoricFlying)prehistoric3;
                return flying.m_29443_();
            }
        } else {
            if (current instanceof Instruction.TeleportTo) {
                Instruction.TeleportTo teleportTo = (Instruction.TeleportTo)current;
                if (this.endTick < this.mob.f_19853_.m_46467_()) {
                    return false;
                }
                this.mob.m_20035_(teleportTo.target, teleportTo.rotation, this.mob.m_146909_());
                this.mob.m_5616_(teleportTo.rotation);
                return true;
            }
            if (current instanceof Instruction.AttachTo) {
                Instruction.AttachTo attachTo = (Instruction.AttachTo)current;
                Prehistoric prehistoric4 = this.mob;
                if (prehistoric4 instanceof Meganeura) {
                    Meganeura meganeura = (Meganeura)prehistoric4;
                    if (!meganeura.getAttachSystem().isAttached()) {
                        return true;
                    }
                    if (!this.attached) {
                        this.attached = true;
                        this.endTick = this.mob.f_19853_.m_46467_() + 100L;
                    }
                    if (this.endTick < this.mob.f_19853_.m_46467_()) {
                        meganeura.getAttachSystem().stopAttaching();
                        return false;
                    }
                    return true;
                }
                return false;
            }
            if (current instanceof Instruction.LeapLand) {
                Instruction.LeapLand leapLand = (Instruction.LeapLand)current;
                PrehistoricLeaping leaping = (PrehistoricLeaping)this.mob;
                if (leaping.getLeapSystem().isLeaping()) {
                    if (leaping.getLeapSystem().isLanding()) {
                        this.delayTick = this.mob.f_19853_.m_46467_() + 25L;
                    }
                } else {
                    if (this.mob.m_20096_() && this.delayTick > 0L && this.delayTick >= this.mob.f_19853_.m_46467_()) {
                        return false;
                    }
                    if (leaping.m_20238_(leapLand.location) < 30.0 && this.delayTick == 0L) {
                        leaping.getLeapSystem().setBlockLeapTarget(leapLand.location);
                    }
                }
                return true;
            }
            if (current instanceof Instruction.LeapAttack) {
                Instruction.LeapAttack leapAttack = (Instruction.LeapAttack)current;
                Entity target = this.mob.f_19853_.m_6815_(leapAttack.targetId);
                if (target instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)target;
                    livingEntity.m_21153_(livingEntity.m_21233_());
                    PrehistoricLeaping leaping = (PrehistoricLeaping)this.mob;
                    double jumpDistance = 30.0;
                    if (leaping.getLeapSystem().isLeaping()) {
                        if (leaping.getLeapSystem().isLanding()) {
                            this.delayTick = this.mob.f_19853_.m_46467_() + 25L;
                        }
                    } else {
                        if (this.mob.m_20096_() && this.delayTick > 0L && this.delayTick >= this.mob.f_19853_.m_46467_()) {
                            return false;
                        }
                        if (leaping.m_20280_(target) < jumpDistance && this.delayTick == 0L) {
                            leaping.getLeapSystem().setLeapTarget(livingEntity);
                        } else {
                            this.mob.m_21573_().m_5624_(target, 1.0);
                            this.mob.m_21391_(target, 120.0f, 10.0f);
                        }
                    }
                    return true;
                }
            } else {
                if (current instanceof Instruction.Idle) {
                    Instruction.Idle idle = (Instruction.Idle)current;
                    return this.endTick >= this.mob.f_19853_.m_46467_();
                }
                if (current instanceof Instruction.Sleep) {
                    Instruction.Sleep sleep = (Instruction.Sleep)current;
                    if (this.endTick < this.mob.f_19853_.m_46467_()) {
                        this.mob.sleepSystem.setSleeping(false);
                        this.mob.sleepSystem.setSleepForced(false);
                        return false;
                    }
                    return true;
                }
                if (current instanceof Instruction.PlayAnim) {
                    Instruction.PlayAnim playAnim = (Instruction.PlayAnim)current;
                    if (playAnim.timeBased) {
                        if (this.animCount < this.mob.f_19853_.m_46467_()) {
                            this.mob.getAnimationLogic().cancelAnimation(playAnim.controller);
                            return false;
                        }
                    } else if (this.mob.getAnimationLogic().isAnimationDone(this.activeAnim)) {
                        --this.animCount;
                        if (this.animCount > 0L) {
                            this.activeAnim = this.mob.getAnimationLogic().forceAnimation(playAnim.controller, this.mob.getAllAnimations().get(playAnim.name), AnimationCategory.IDLE, 1.0, 5.0, false);
                        } else {
                            return false;
                        }
                    }
                    return true;
                }
            }
        }
        return false;
    }

    private boolean tryUpdatePath(Instruction.MoveTo moveTo) {
        PathNavigation navigation = this.mob.m_21573_();
        if (this.tries >= 15) {
            this.tries = 0;
            return false;
        }
        if (navigation instanceof GroundPathNavigation && !this.mob.m_20096_() && !this.mob.m_20072_()) {
            return true;
        }
        if (navigation instanceof WaterBoundPathNavigation && !this.mob.m_20072_() && !(navigation instanceof AmphibiousPathNavigation)) {
            return true;
        }
        if (navigation.m_26570_() == null) {
            Path path = navigation.m_7864_(moveTo.target, 1);
            if (path == null) {
                ++this.tries;
                return true;
            }
            return navigation.m_26536_(path, 1.0);
        }
        if (navigation.m_26570_().m_77392_() && !moveTo.target.m_203195_((Position)this.mob.m_20182_(), this.acceptedDistance())) {
            Path path = navigation.m_7864_(moveTo.target, 1);
            if (path == null) {
                ++this.tries;
                return true;
            }
            return navigation.m_26536_(path, 1.0);
        }
        return !navigation.m_26570_().m_77392_();
    }

    public double acceptedDistance() {
        if (this.mob.getEntityHitboxData().hasCustomParts() && this.mob.getEntityHitboxData().getHeadRadius() != 0.0f) {
            return this.mob.getEntityHitboxData().getHeadRadius() * this.mob.m_6134_() + 1.0f;
        }
        return this.mob.m_20205_() / 2.0f + 1.0f;
    }

    private void startNext() {
        ++this.index;
        this.tries = 0;
        if (this.instructions.size() == this.index) {
            if (this.shouldLoop) {
                this.syncWithClients();
                this.index = 0;
            } else {
                this.stop();
                return;
            }
        }
        this.endTick = 0L;
        this.delayTick = 0L;
        Instruction current = this.instructions.get(this.index);
        if (current instanceof Instruction.MoveTo) {
            Instruction.MoveTo moveTo = (Instruction.MoveTo)current;
            this.mob.m_21573_().m_26519_((double)moveTo.target.m_123341_(), (double)moveTo.target.m_123342_(), (double)moveTo.target.m_123343_(), 1.0);
        } else if (current instanceof Instruction.FlyTo) {
            Instruction.FlyTo flyTo = (Instruction.FlyTo)current;
            Prehistoric prehistoric = this.mob;
            if (prehistoric instanceof PrehistoricFlying) {
                PrehistoricFlying flying = (PrehistoricFlying)prehistoric;
                flying.moveTo(Vec3.m_82512_((Vec3i)flyTo.target), false, true);
            }
        } else if (current instanceof Instruction.FlyLand) {
            Instruction.FlyLand flyLand = (Instruction.FlyLand)current;
            Prehistoric prehistoric = this.mob;
            if (prehistoric instanceof PrehistoricFlying) {
                PrehistoricFlying flying = (PrehistoricFlying)prehistoric;
                flying.moveTo(Vec3.m_82512_((Vec3i)flyLand.target), true, true);
            }
        } else if (current instanceof Instruction.TeleportTo) {
            Instruction.TeleportTo teleportTo = (Instruction.TeleportTo)current;
            this.mob.m_21573_().m_26573_();
            this.mob.m_20035_(teleportTo.target, teleportTo.rotation, this.mob.m_146909_());
            this.mob.m_5616_(teleportTo.rotation);
            this.endTick = this.mob.f_19853_.m_46467_() + 5L;
        } else if (current instanceof Instruction.AttachTo) {
            Instruction.AttachTo attachTo = (Instruction.AttachTo)current;
            this.attached = false;
            this.mob.m_21573_().m_26519_((double)attachTo.target.m_123341_(), (double)attachTo.target.m_123342_(), (double)attachTo.target.m_123343_(), 1.0);
            Prehistoric prehistoric = this.mob;
            if (prehistoric instanceof Meganeura) {
                Meganeura meganeura = (Meganeura)prehistoric;
                Direction face = attachTo.direction;
                float rad = this.mob.m_20205_() / 2.0f;
                Vec3 pos = new Vec3(attachTo.location.f_82479_ + (double)(rad * (float)face.m_122429_()), attachTo.location.f_82480_, attachTo.location.f_82481_ + (double)(rad * (float)face.m_122431_()));
                meganeura.getAttachSystem().setAttachTarget(attachTo.target, face, pos);
            }
        } else if (current instanceof Instruction.LeapLand) {
            Instruction.LeapLand leapLand = (Instruction.LeapLand)current;
            this.mob.m_21573_().m_26519_(leapLand.location.f_82479_, leapLand.location.f_82480_, leapLand.location.f_82481_, 1.0);
        } else if (current instanceof Instruction.LeapAttack) {
            Prehistoric prehistoric;
            Instruction.LeapAttack leapAttack = (Instruction.LeapAttack)current;
            Entity target = this.mob.f_19853_.m_6815_(leapAttack.targetId);
            if (target instanceof LivingEntity && (prehistoric = this.mob) instanceof PrehistoricLeaping) {
                PrehistoricLeaping leaping = (PrehistoricLeaping)prehistoric;
                this.mob.m_21573_().m_5624_(target, 1.0);
                this.mob.m_21391_(target, 120.0f, 10.0f);
                this.mob.m_6710_((LivingEntity)leaping);
            }
        } else if (current instanceof Instruction.Idle) {
            Instruction.Idle idle = (Instruction.Idle)current;
            this.endTick = this.mob.f_19853_.m_46467_() + (long)idle.duration;
        } else if (current instanceof Instruction.PlayAnim) {
            Instruction.PlayAnim playAnim = (Instruction.PlayAnim)current;
            if (playAnim.timeBased) {
                this.animCount = this.mob.f_19853_.m_46467_() + (long)playAnim.count * 20L;
                this.activeAnim = this.mob.getAnimationLogic().forceAnimation(playAnim.controller, this.mob.getAllAnimations().get(playAnim.name), AnimationCategory.IDLE, 1.0, 5.0, true);
            } else {
                this.animCount = playAnim.count;
                this.activeAnim = this.mob.getAnimationLogic().forceAnimation(playAnim.controller, this.mob.getAllAnimations().get(playAnim.name), AnimationCategory.IDLE, 1.0, 5.0, false);
            }
        } else if (current instanceof Instruction.Sleep) {
            Instruction.Sleep sleep = (Instruction.Sleep)current;
            this.endTick = this.mob.f_19853_.m_46467_() + (long)sleep.duration;
            this.mob.sleepSystem.setDisabled(false);
            this.mob.sleepSystem.setSleeping(true);
            this.mob.sleepSystem.setSleepForced(true);
        }
    }

    public void start(List<Instruction> instructions, boolean loop, boolean sync) {
        this.instructions.clear();
        this.instructions.addAll(instructions);
        this.mob.m_21573_().m_26573_();
        this.index = -1;
        this.endTick = 0L;
        this.delayTick = 0L;
        this.shouldLoop = loop;
        if (sync) {
            this.syncWithClients();
        }
        this.mob.sleepSystem.setDisabled(true);
        this.mob.sitSystem.setDisabled(true);
        if (instructions.isEmpty()) {
            this.stop();
        } else {
            Prehistoric prehistoric = this.mob;
            if (prehistoric instanceof Meganeura) {
                Meganeura meganeura = (Meganeura)prehistoric;
                meganeura.getAttachSystem().stopAttaching();
            }
            if ((prehistoric = this.mob) instanceof PrehistoricLeaping) {
                PrehistoricLeaping leaping = (PrehistoricLeaping)prehistoric;
                leaping.getLeapSystem().stopLeap();
                leaping.getLeapSystem().setAttackRiding(false);
                leaping.m_8127_();
            }
            if (this.mob.m_5803_()) {
                this.mob.sleepSystem.setSleeping(false);
            }
            if (this.mob.sitSystem.isSitting()) {
                this.mob.sitSystem.setSitting(false);
            }
            this.mob.disableCustomAI((byte)0, false);
            this.mob.disableCustomAI((byte)1, true);
            this.mob.disableCustomAI((byte)2, false);
            this.mob.disableCustomAI((byte)3, false);
            this.startNext();
        }
    }

    public void stop() {
        this.mob.disableCustomAI((byte)0, true);
        this.mob.disableCustomAI((byte)1, false);
        this.mob.sleepSystem.setSleepForced(false);
        this.mob.sleepSystem.setDisabled(false);
        this.mob.sitSystem.setDisabled(false);
    }

    public void syncWithClients() {
        MessageHandler.DEBUG_CHANNEL.sendToPlayers((Iterable)((ServerLevel)this.mob.f_19853_).m_8795_(serverPlayer -> serverPlayer.m_20270_((Entity)this.mob) < 32.0f), (Object)new InstructionMessage(this.mob.m_19879_(), this.shouldLoop, this.instructions));
    }

    @Override
    public void saveAdditional(CompoundTag tag) {
        if (Version.debugEnabled() && !this.mob.f_19853_.f_46443_) {
            ListTag saved = new ListTag();
            for (int i = 0; i < this.instructions.size(); ++i) {
                saved.m_7614_(i, (Tag)this.instructions.get(i).encodeTag());
            }
            tag.m_128365_("Instructions", (Tag)saved);
            tag.m_128379_("InstructionsLoop", this.shouldLoop);
        }
    }

    @Override
    public void load(CompoundTag tag) {
        if (Version.debugEnabled()) {
            ObjectArrayList newInstructions = new ObjectArrayList();
            newInstructions.clear();
            ListTag saved = tag.m_128437_("Instructions", 10);
            for (Tag savedTag : saved) {
                newInstructions.add(Instruction.decodeFromTag((CompoundTag)savedTag));
            }
            this.shouldLoop = tag.m_128471_("InstructionsLoop");
            if (!newInstructions.isEmpty()) {
                this.start((List<Instruction>)newInstructions, this.shouldLoop, false);
            }
        }
    }

    public void saveAdditionalSpawnData(FriendlyByteBuf buf) {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag);
        buf.m_130079_(tag);
    }

    public void loadAdditionalSpawnData(FriendlyByteBuf buf) {
        ObjectArrayList newInstructions = new ObjectArrayList();
        CompoundTag tag = buf.m_130260_();
        if (tag != null) {
            ListTag saved = tag.m_128437_("Instructions", 10);
            for (Tag savedTag : saved) {
                newInstructions.add(Instruction.decodeFromTag((CompoundTag)savedTag));
            }
            InstructionTab.INSTRUCTIONS.put(this.mob.m_20148_(), new InstructionTab.Pair(this.mob.m_19879_(), (List<Instruction>)newInstructions));
        }
    }
}

