/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.forge.data.providers;

import com.github.teamfossilsarcheology.fossil.FossilMod;
import com.github.teamfossilsarcheology.fossil.block.ModBlocks;
import com.github.teamfossilsarcheology.fossil.block.PrehistoricPlantInfo;
import com.github.teamfossilsarcheology.fossil.block.custom_blocks.AmphoraVaseBlock;
import com.github.teamfossilsarcheology.fossil.block.custom_blocks.FernsBlock;
import com.github.teamfossilsarcheology.fossil.block.custom_blocks.FourTallFlowerBlock;
import com.github.teamfossilsarcheology.fossil.block.custom_blocks.KylixVaseBlock;
import com.github.teamfossilsarcheology.fossil.block.custom_blocks.ShortBerryBushBlock;
import com.github.teamfossilsarcheology.fossil.block.custom_blocks.ShortFlowerBlock;
import com.github.teamfossilsarcheology.fossil.block.custom_blocks.TallBerryBushBlock;
import com.github.teamfossilsarcheology.fossil.block.custom_blocks.TallFlowerBlock;
import com.github.teamfossilsarcheology.fossil.block.custom_blocks.VaseBlock;
import com.github.teamfossilsarcheology.fossil.block.custom_blocks.VoluteVaseBlock;
import com.github.teamfossilsarcheology.fossil.forge.data.providers.ModBlockModelProvider;
import com.github.teamfossilsarcheology.fossil.forge.data.providers.ModItemProvider;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.stream.IntStream;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class ModBlockStateProvider
extends BlockStateProvider {
    public static final String BLOCK_FOLDER2 = "block/";
    private final ModBlockModelProvider blockModels;
    private final ModItemProvider itemModels;

    public ModBlockStateProvider(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen, "fossil", exFileHelper);
        this.blockModels = new ModBlockModelProvider(gen, exFileHelper);
        this.itemModels = new ModItemProvider(gen, exFileHelper);
    }

    public ModBlockModelProvider models() {
        return this.blockModels;
    }

    public ModItemProvider itemModels() {
        return this.itemModels;
    }

    protected void registerStatesAndModels() {
        boolean plantBlocks = true;
        boolean vases = true;
        boolean buildingWood = true;
        if (plantBlocks) {
            for (PrehistoricPlantInfo info : PrehistoricPlantInfo.values()) {
                if (info == PrehistoricPlantInfo.DIPTERIS || info == PrehistoricPlantInfo.ZAMITES) continue;
                BushBlock flower = info.getPlantBlock();
                if (flower instanceof ShortBerryBushBlock) {
                    ShortBerryBushBlock shortBerryBushBlock = (ShortBerryBushBlock)flower;
                    this.shortBerryBlock(info, shortBerryBushBlock);
                    continue;
                }
                if (flower instanceof TallBerryBushBlock) {
                    TallBerryBushBlock tallBerry = (TallBerryBushBlock)flower;
                    this.tallBerryBlock(info, tallBerry);
                    continue;
                }
                if (flower instanceof ShortFlowerBlock) {
                    ShortFlowerBlock shortFlower = (ShortFlowerBlock)flower;
                    this.shortFlowerBlock(shortFlower);
                    continue;
                }
                if (flower instanceof TallFlowerBlock) {
                    TallFlowerBlock tallFlower = (TallFlowerBlock)flower;
                    this.tallFlowerBlock(tallFlower);
                    continue;
                }
                if (!(flower instanceof FourTallFlowerBlock)) continue;
                FourTallFlowerBlock tallFlower = (FourTallFlowerBlock)flower;
                this.fourTallFlowerBlock(tallFlower);
            }
            VariantBlockStateBuilder blockState = this.getVariantBuilder((Block)ModBlocks.FERNS.get());
            ResourceLocation[] textures = (ResourceLocation[])IntStream.rangeClosed(0, 6).mapToObj(age -> FossilMod.location("block/plants/plant_ferns_stage" + age)).toArray(ResourceLocation[]::new);
            this.models().registerExistingTexture(textures);
            ResourceLocation fernsCrop = FossilMod.location("block/plant_ferns_template");
            this.models().registerExistingModel(fernsCrop);
            for (int i = 0; i <= 6; ++i) {
                blockState.partialState().with((Property)FernsBlock.AGE, (Comparable)Integer.valueOf(i)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)this.models().singleTexture("block/plants/plant_ferns_stage" + i, fernsCrop, "crop", textures[i]))});
            }
        }
        if (vases) {
            ResourceLocation amphoraTemplateBase = FossilMod.location("block/template_vase_amphora_base");
            ResourceLocation amphoraTemplateTop = FossilMod.location("block/template_vase_amphora_top");
            ResourceLocation kylixTemplate = FossilMod.location("block/template_vase_kylix");
            ResourceLocation voluteTemplate = FossilMod.location("block/template_vase_volute");
            this.models().registerExistingModel(amphoraTemplateBase, amphoraTemplateTop, kylixTemplate, voluteTemplate);
            for (RegistrySupplier registrySupplier : ModBlocks.VASES) {
                VaseBlock block = (VaseBlock)((Object)registrySupplier.get());
                if (block instanceof AmphoraVaseBlock) {
                    this.amphora(block, amphoraTemplateBase, amphoraTemplateTop);
                    continue;
                }
                if (block instanceof KylixVaseBlock) {
                    this.vaseBlock(block, kylixTemplate);
                    continue;
                }
                if (!(block instanceof VoluteVaseBlock)) continue;
                this.vaseBlock(block, voluteTemplate);
            }
        }
        ModBlocks.BLOCKS.forEach(supplier -> supplier.ifPresent(xva$0 -> this.registerExistingTextures((Block)xva$0)));
        if (buildingWood) {
            ResourceLocation ancientStone = this.blockTexture((Block)ModBlocks.ANCIENT_STONE_BRICKS.get());
            this.simpleBlock((Block)ModBlocks.ANCIENT_STONE_BRICKS.get());
            this.slabBlock((SlabBlock)ModBlocks.ANCIENT_STONE_SLAB.get(), ancientStone);
            this.stairsBlock((StairBlock)ModBlocks.ANCIENT_STONE_STAIRS.get(), ancientStone);
            this.wallBlock((WallBlock)ModBlocks.ANCIENT_STONE_WALL.get(), ancientStone);
            ResourceLocation ancientWood = this.blockTexture((Block)ModBlocks.ANCIENT_WOOD_PLANKS.get());
            this.simpleBlock((Block)ModBlocks.ANCIENT_WOOD_PLANKS.get());
            this.slabBlock((SlabBlock)ModBlocks.ANCIENT_WOOD_SLAB.get(), ancientWood);
            this.stairsBlock((StairBlock)ModBlocks.ANCIENT_WOOD_STAIRS.get(), ancientWood);
            this.logBlock((RotatedPillarBlock)ModBlocks.ANCIENT_WOOD_LOG.get());
            ResourceLocation volcanicBrick = this.blockTexture((Block)ModBlocks.VOLCANIC_BRICKS.get());
            this.simpleBlock((Block)ModBlocks.VOLCANIC_BRICKS.get());
            this.slabBlock((SlabBlock)ModBlocks.VOLCANIC_BRICK_SLAB.get(), volcanicBrick);
            this.stairsBlock((StairBlock)ModBlocks.VOLCANIC_BRICK_STAIRS.get(), volcanicBrick);
            this.wallBlock((WallBlock)ModBlocks.VOLCANIC_BRICK_WALL.get(), volcanicBrick);
            ResourceLocation volcanicTile = this.blockTexture((Block)ModBlocks.VOLCANIC_TILES.get());
            this.simpleBlock((Block)ModBlocks.VOLCANIC_TILES.get());
            this.slabBlock((SlabBlock)ModBlocks.VOLCANIC_TILE_SLAB.get(), volcanicTile);
            this.stairsBlock((StairBlock)ModBlocks.VOLCANIC_TILE_STAIRS.get(), volcanicTile);
            this.wallBlock((WallBlock)ModBlocks.VOLCANIC_TILE_WALL.get(), volcanicTile);
            ResourceLocation calamites = this.blockTexture((Block)ModBlocks.CALAMITES_PLANKS.get());
            this.simpleBlock((Block)ModBlocks.CALAMITES_PLANKS.get());
            this.stairsBlock((StairBlock)ModBlocks.CALAMITES_STAIRS.get(), calamites);
            this.slabBlock((SlabBlock)ModBlocks.CALAMITES_SLAB.get(), calamites);
            this.fenceBlock((FenceBlock)ModBlocks.CALAMITES_FENCE.get(), calamites);
            this.fenceGateBlock((FenceGateBlock)ModBlocks.CALAMITES_FENCE_GATE.get(), calamites);
            this.doorBlock((DoorBlock)ModBlocks.CALAMITES_DOOR.get());
            this.trapdoorBlock((TrapDoorBlock)ModBlocks.CALAMITES_TRAPDOOR.get(), true);
            this.buttonBlock((ButtonBlock)ModBlocks.CALAMITES_BUTTON.get(), calamites);
            this.pressurePlateBlock((PressurePlateBlock)ModBlocks.CALAMITES_PRESSURE_PLATE.get(), calamites);
            this.logBlock((RotatedPillarBlock)ModBlocks.CALAMITES_LOG.get());
            this.woodBlock((RotatedPillarBlock)ModBlocks.CALAMITES_WOOD.get(), (RotatedPillarBlock)ModBlocks.CALAMITES_LOG.get());
            this.logBlock((RotatedPillarBlock)ModBlocks.STRIPPED_CALAMITES_LOG.get());
            this.woodBlock((RotatedPillarBlock)ModBlocks.STRIPPED_CALAMITES_WOOD.get(), (RotatedPillarBlock)ModBlocks.STRIPPED_CALAMITES_LOG.get());
            this.leavesBlock((LeavesBlock)ModBlocks.CALAMITES_LEAVES.get());
            this.crossBlock((Block)ModBlocks.CALAMITES_SAPLING.get());
            ResourceLocation resourceLocation = this.blockTexture((Block)ModBlocks.CORDAITES_PLANKS.get());
            this.simpleBlock((Block)ModBlocks.CORDAITES_PLANKS.get());
            this.stairsBlock((StairBlock)ModBlocks.CORDAITES_STAIRS.get(), resourceLocation);
            this.slabBlock((SlabBlock)ModBlocks.CORDAITES_SLAB.get(), resourceLocation);
            this.fenceBlock((FenceBlock)ModBlocks.CORDAITES_FENCE.get(), resourceLocation);
            this.fenceGateBlock((FenceGateBlock)ModBlocks.CORDAITES_FENCE_GATE.get(), resourceLocation);
            this.doorBlock((DoorBlock)ModBlocks.CORDAITES_DOOR.get());
            this.trapdoorBlock((TrapDoorBlock)ModBlocks.CORDAITES_TRAPDOOR.get(), true);
            this.buttonBlock((ButtonBlock)ModBlocks.CORDAITES_BUTTON.get(), resourceLocation);
            this.pressurePlateBlock((PressurePlateBlock)ModBlocks.CORDAITES_PRESSURE_PLATE.get(), resourceLocation);
            this.logBlock((RotatedPillarBlock)ModBlocks.CORDAITES_LOG.get());
            this.woodBlock((RotatedPillarBlock)ModBlocks.CORDAITES_WOOD.get(), (RotatedPillarBlock)ModBlocks.CORDAITES_LOG.get());
            this.logBlock((RotatedPillarBlock)ModBlocks.STRIPPED_CORDAITES_LOG.get());
            this.woodBlock((RotatedPillarBlock)ModBlocks.STRIPPED_CORDAITES_WOOD.get(), (RotatedPillarBlock)ModBlocks.STRIPPED_CORDAITES_LOG.get());
            this.leavesBlock((LeavesBlock)ModBlocks.CORDAITES_LEAVES.get());
            this.crossBlock((Block)ModBlocks.CORDAITES_SAPLING.get());
            ResourceLocation mutantTree = this.blockTexture((Block)ModBlocks.MUTANT_TREE_PLANKS.get());
            this.simpleBlock((Block)ModBlocks.MUTANT_TREE_PLANKS.get());
            this.stairsBlock((StairBlock)ModBlocks.MUTANT_TREE_STAIRS.get(), mutantTree);
            this.slabBlock((SlabBlock)ModBlocks.MUTANT_TREE_SLAB.get(), mutantTree);
            this.fenceBlock((FenceBlock)ModBlocks.MUTANT_TREE_FENCE.get(), mutantTree);
            this.fenceGateBlock((FenceGateBlock)ModBlocks.MUTANT_TREE_FENCE_GATE.get(), mutantTree);
            this.doorBlock((DoorBlock)ModBlocks.MUTANT_TREE_DOOR.get());
            this.trapdoorBlock((TrapDoorBlock)ModBlocks.MUTANT_TREE_TRAPDOOR.get(), true);
            this.buttonBlock((ButtonBlock)ModBlocks.MUTANT_TREE_BUTTON.get(), mutantTree);
            this.pressurePlateBlock((PressurePlateBlock)ModBlocks.MUTANT_TREE_PRESSURE_PLATE.get(), mutantTree);
            this.logBlock((RotatedPillarBlock)ModBlocks.MUTANT_TREE_LOG.get());
            this.woodBlock((RotatedPillarBlock)ModBlocks.MUTANT_TREE_WOOD.get(), (RotatedPillarBlock)ModBlocks.MUTANT_TREE_LOG.get());
            this.logBlock((RotatedPillarBlock)ModBlocks.STRIPPED_MUTANT_TREE_LOG.get());
            this.woodBlock((RotatedPillarBlock)ModBlocks.STRIPPED_MUTANT_TREE_WOOD.get(), (RotatedPillarBlock)ModBlocks.STRIPPED_MUTANT_TREE_LOG.get());
            this.leavesBlock((LeavesBlock)ModBlocks.MUTANT_TREE_LEAVES.get());
            this.crossBlock((Block)ModBlocks.MUTANT_TREE_SAPLING.get());
            ResourceLocation palm = this.blockTexture((Block)ModBlocks.PALM_PLANKS.get());
            this.simpleBlock((Block)ModBlocks.PALM_PLANKS.get());
            this.stairsBlock((StairBlock)ModBlocks.PALM_STAIRS.get(), palm);
            this.slabBlock((SlabBlock)ModBlocks.PALM_SLAB.get(), palm);
            this.fenceBlock((FenceBlock)ModBlocks.PALM_FENCE.get(), palm);
            this.fenceGateBlock((FenceGateBlock)ModBlocks.PALM_FENCE_GATE.get(), palm);
            this.doorBlock((DoorBlock)ModBlocks.PALM_DOOR.get());
            this.trapdoorBlock((TrapDoorBlock)ModBlocks.PALM_TRAPDOOR.get(), true);
            this.buttonBlock((ButtonBlock)ModBlocks.PALM_BUTTON.get(), palm);
            this.pressurePlateBlock((PressurePlateBlock)ModBlocks.PALM_PRESSURE_PLATE.get(), palm);
            this.logBlock((RotatedPillarBlock)ModBlocks.PALM_LOG.get());
            this.woodBlock((RotatedPillarBlock)ModBlocks.PALM_WOOD.get(), (RotatedPillarBlock)ModBlocks.PALM_LOG.get());
            this.logBlock((RotatedPillarBlock)ModBlocks.STRIPPED_PALM_LOG.get());
            this.woodBlock((RotatedPillarBlock)ModBlocks.STRIPPED_PALM_WOOD.get(), (RotatedPillarBlock)ModBlocks.STRIPPED_PALM_LOG.get());
            this.leavesBlock((LeavesBlock)ModBlocks.PALM_LEAVES.get());
            this.crossBlock((Block)ModBlocks.PALM_SAPLING.get());
            ResourceLocation sigillaria = this.blockTexture((Block)ModBlocks.SIGILLARIA_PLANKS.get());
            this.simpleBlock((Block)ModBlocks.SIGILLARIA_PLANKS.get());
            this.stairsBlock((StairBlock)ModBlocks.SIGILLARIA_STAIRS.get(), sigillaria);
            this.slabBlock((SlabBlock)ModBlocks.SIGILLARIA_SLAB.get(), sigillaria);
            this.fenceBlock((FenceBlock)ModBlocks.SIGILLARIA_FENCE.get(), sigillaria);
            this.fenceGateBlock((FenceGateBlock)ModBlocks.SIGILLARIA_FENCE_GATE.get(), sigillaria);
            this.doorBlock((DoorBlock)ModBlocks.SIGILLARIA_DOOR.get());
            this.trapdoorBlock((TrapDoorBlock)ModBlocks.SIGILLARIA_TRAPDOOR.get(), true);
            this.buttonBlock((ButtonBlock)ModBlocks.SIGILLARIA_BUTTON.get(), sigillaria);
            this.pressurePlateBlock((PressurePlateBlock)ModBlocks.SIGILLARIA_PRESSURE_PLATE.get(), sigillaria);
            this.logBlock((RotatedPillarBlock)ModBlocks.SIGILLARIA_LOG.get());
            this.woodBlock((RotatedPillarBlock)ModBlocks.SIGILLARIA_WOOD.get(), (RotatedPillarBlock)ModBlocks.SIGILLARIA_LOG.get());
            this.logBlock((RotatedPillarBlock)ModBlocks.STRIPPED_SIGILLARIA_LOG.get());
            this.woodBlock((RotatedPillarBlock)ModBlocks.STRIPPED_SIGILLARIA_WOOD.get(), (RotatedPillarBlock)ModBlocks.STRIPPED_SIGILLARIA_LOG.get());
            this.leavesBlock((LeavesBlock)ModBlocks.SIGILLARIA_LEAVES.get());
            this.crossBlock((Block)ModBlocks.SIGILLARIA_SAPLING.get());
            ResourceLocation tempskya = this.blockTexture((Block)ModBlocks.TEMPSKYA_PLANKS.get());
            this.simpleBlock((Block)ModBlocks.TEMPSKYA_PLANKS.get());
            this.stairsBlock((StairBlock)ModBlocks.TEMPSKYA_STAIRS.get(), tempskya);
            this.slabBlock((SlabBlock)ModBlocks.TEMPSKYA_SLAB.get(), tempskya);
            this.fenceBlock((FenceBlock)ModBlocks.TEMPSKYA_FENCE.get(), tempskya);
            this.fenceGateBlock((FenceGateBlock)ModBlocks.TEMPSKYA_FENCE_GATE.get(), tempskya);
            this.doorBlock((DoorBlock)ModBlocks.TEMPSKYA_DOOR.get());
            this.trapdoorBlock((TrapDoorBlock)ModBlocks.TEMPSKYA_TRAPDOOR.get(), true);
            this.buttonBlock((ButtonBlock)ModBlocks.TEMPSKYA_BUTTON.get(), tempskya);
            this.pressurePlateBlock((PressurePlateBlock)ModBlocks.TEMPSKYA_PRESSURE_PLATE.get(), tempskya);
            this.logBlock((RotatedPillarBlock)ModBlocks.TEMPSKYA_LOG.get());
            this.woodBlock((RotatedPillarBlock)ModBlocks.TEMPSKYA_WOOD.get(), (RotatedPillarBlock)ModBlocks.TEMPSKYA_LOG.get());
            this.logBlock((RotatedPillarBlock)ModBlocks.STRIPPED_TEMPSKYA_LOG.get());
            this.woodBlock((RotatedPillarBlock)ModBlocks.STRIPPED_TEMPSKYA_WOOD.get(), (RotatedPillarBlock)ModBlocks.STRIPPED_TEMPSKYA_LOG.get());
            this.crossBlock((Block)ModBlocks.TEMPSKYA_SAPLING.get());
        }
        this.amberChunkBlock((Block)ModBlocks.AMBER_CHUNK.get());
        this.amberChunkBlock((Block)ModBlocks.AMBER_CHUNK_DOMINICAN.get());
        this.amberChunkBlock((Block)ModBlocks.AMBER_CHUNK_MOSQUITO.get());
        this.simpleBlock((Block)ModBlocks.CALCITE_FOSSIL.get());
        this.simpleBlock((Block)ModBlocks.DEEPSLATE_FOSSIL.get());
        this.simpleBlock((Block)ModBlocks.DRIPSTONE_FOSSIL.get());
        this.simpleBlock((Block)ModBlocks.RED_SANDSTONE_FOSSIL.get());
        this.simpleBlock((Block)ModBlocks.SANDSTONE_FOSSIL.get());
        this.simpleBlock((Block)ModBlocks.STONE_FOSSIL.get());
        this.simpleBlock((Block)ModBlocks.TUFF_FOSSIL.get());
        ResourceLocation shell = this.blockTexture((Block)ModBlocks.SHELL.get());
        this.models().registerExistingModel(shell);
        this.horizontalBlock((Block)ModBlocks.SHELL.get(), (ModelFile)this.models().getExistingFile(shell));
    }

    public void registerExistingTextures(Block ... blocks) {
        for (Block block : blocks) {
            this.models().registerExistingTexture(this.blockTexture(block));
        }
    }

    public void woodBlock(RotatedPillarBlock block, RotatedPillarBlock log) {
        this.itemModels().blockItem(this.key((Block)block));
        ModelBuilder wood = this.models().cubeColumn(this.key((Block)block).m_135815_(), this.blockTexture((Block)log), this.blockTexture((Block)log));
        this.axisBlock(block, (ModelFile)wood, (ModelFile)wood);
    }

    public void logBlock(RotatedPillarBlock block) {
        this.itemModels().blockItem(this.key((Block)block));
        this.models().registerExistingTexture(FossilMod.location(this.blockTexture((Block)block).m_135815_() + "_top"));
        super.logBlock(block);
    }

    public void simpleBlock(Block block) {
        this.itemModels().blockItem(this.key(block));
        super.simpleBlock(block);
    }

    public void stairsBlock(StairBlock block, ResourceLocation texture) {
        this.itemModels().blockItem(this.key((Block)block));
        super.stairsBlock(block, texture);
    }

    public void slabBlock(SlabBlock block, ResourceLocation texture) {
        this.itemModels().blockItem(this.key((Block)block));
        this.getVariantBuilder((Block)block).partialState().with((Property)SlabBlock.f_56353_, (Comparable)SlabType.BOTTOM).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)this.models().slab(this.key((Block)block).m_135815_(), texture, texture, texture))}).partialState().with((Property)SlabBlock.f_56353_, (Comparable)SlabType.TOP).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)this.models().slabTop(this.key((Block)block).m_135815_() + "_top", texture, texture, texture))}).partialState().with((Property)SlabBlock.f_56353_, (Comparable)SlabType.DOUBLE).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)this.models().getExistingFile(texture))});
    }

    public void wallBlock(WallBlock block, ResourceLocation texture) {
        this.itemModels().blockItem(this.key((Block)block), "_inventory");
        this.models().singleTexture(BLOCK_FOLDER2 + this.key((Block)block).m_135815_() + "_inventory", this.mcLoc("wall_inventory"), "wall", texture);
        super.wallBlock(block, texture);
    }

    public void fenceBlock(FenceBlock block, ResourceLocation texture) {
        this.itemModels().blockItem(this.key((Block)block), "_inventory");
        this.models().singleTexture(BLOCK_FOLDER2 + this.key((Block)block).m_135815_() + "_inventory", this.mcLoc("fence_inventory"), texture);
        super.fenceBlock(block, texture);
    }

    public void fenceGateBlock(FenceGateBlock block, ResourceLocation texture) {
        this.itemModels().blockItem(this.key((Block)block));
        super.fenceGateBlock(block, texture);
    }

    private ResourceLocation expand(ResourceLocation location, String suffix) {
        return new ResourceLocation(location.m_135827_(), location.m_135815_() + suffix);
    }

    public void doorBlock(DoorBlock block) {
        this.itemModels().simpleItem(this.key((Block)block), false);
        ResourceLocation bottom = this.expand(this.blockTexture((Block)block), "_bottom");
        ResourceLocation top = this.expand(this.blockTexture((Block)block), "_top");
        this.models().registerExistingTexture(bottom, top);
        super.doorBlock(block, bottom, top);
    }

    public void trapdoorBlock(TrapDoorBlock block, boolean orientable) {
        this.itemModels().blockItem(this.key((Block)block), "_bottom");
        this.models().registerExistingTexture(this.blockTexture((Block)block));
        super.trapdoorBlock(block, this.blockTexture((Block)block), orientable);
    }

    public void buttonBlock(ButtonBlock block, ResourceLocation texture) {
        this.itemModels().blockItem(this.key((Block)block), "_inventory");
        this.models().singleTexture(BLOCK_FOLDER2 + this.key((Block)block).m_135815_() + "_inventory", this.mcLoc("button_inventory"), texture);
        super.buttonBlock(block, texture);
    }

    public void pressurePlateBlock(PressurePlateBlock block, ResourceLocation texture) {
        this.itemModels().blockItem(this.key((Block)block));
        super.pressurePlateBlock(block, texture);
    }

    public void crossBlock(Block block) {
        this.itemModels().simpleItem(this.key(block), true);
        ResourceLocation texture = this.blockTexture(block);
        this.models().registerExistingTexture(texture);
        ModelBuilder file = this.models().singleTexture(BLOCK_FOLDER2 + this.key(block).m_135815_(), this.mcLoc("cross"), "cross", texture);
        this.getVariantBuilder(block).partialState().setModels(new ConfiguredModel[]{ConfiguredModel.builder().modelFile((ModelFile)file).buildLast()});
    }

    public void leavesBlock(LeavesBlock block) {
        this.itemModels().blockItem(this.key((Block)block));
        ResourceLocation texture = this.blockTexture((Block)block);
        this.models().registerExistingTexture(texture);
        ModelBuilder file = this.models().singleTexture(BLOCK_FOLDER2 + this.key((Block)block).m_135815_(), this.mcLoc("leaves"), "all", texture);
        this.getVariantBuilder((Block)block).partialState().setModels(new ConfiguredModel[]{ConfiguredModel.builder().modelFile((ModelFile)file).buildLast()});
    }

    public void amphora(VaseBlock block, ResourceLocation templateBase, ResourceLocation templateTop) {
        this.itemModels().vaseItem(this.key(block));
        ResourceLocation base = FossilMod.location("block/vases/vase_amphora_base");
        if (block == ModBlocks.AMPHORA_VASE_DAMAGED.get()) {
            base = FossilMod.location("block/vases/vase_amphora_base_damaged");
        }
        ResourceLocation color = FossilMod.location("block/vases/" + this.key(block).m_135815_());
        this.models().registerExistingTexture(base, color);
        ModelBuilder fileBase = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("block/vases/" + this.key(block).m_135815_() + "_base", templateBase)).texture("color", color)).texture("base", base);
        ModelBuilder fileTop = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("block/vases/" + this.key(block).m_135815_() + "_top", templateTop)).texture("color", color)).texture("base", base);
        this.getVariantBuilder(block).forAllStates(arg_0 -> ModBlockStateProvider.lambda$amphora$4((ModelFile)fileTop, (ModelFile)fileBase, arg_0));
    }

    public void vaseBlock(VaseBlock block, ResourceLocation template) {
        this.itemModels().vaseItem(this.key(block));
        ResourceLocation texture = FossilMod.location("block/vases/" + this.key(block).m_135815_());
        this.models().registerExistingTexture(texture);
        ModelBuilder file = this.models().singleTexture("block/vases/" + this.key(block).m_135815_(), template, texture);
        this.horizontalBlock(block, (ModelFile)file);
    }

    public void amberChunkBlock(Block block) {
        ResourceLocation template = FossilMod.location("block/amber_chunk_template");
        this.models().registerExistingModel(template);
        this.itemModels().basicItem(this.key(block));
        ResourceLocation texture = FossilMod.location(BLOCK_FOLDER2 + this.key(block).m_135815_());
        this.models().registerExistingTexture(texture);
        ModelBuilder file = this.models().singleTexture(BLOCK_FOLDER2 + this.key(block).m_135815_(), template, "all", texture);
        this.horizontalBlock(block, (ModelFile)file, 90);
    }

    private void shortBerryBlock(PrehistoricPlantInfo info, ShortBerryBushBlock block) {
        this.itemModels().plantBlockItem((Block)block, "_stage" + info.maxAge());
        String name = this.key((Block)block).m_135815_();
        VariantBlockStateBuilder blockState = this.getVariantBuilder((Block)block);
        ResourceLocation[] textures = (ResourceLocation[])IntStream.rangeClosed(0, info.maxAge()).mapToObj(age -> FossilMod.location("block/plants/plant_" + name + "_stage" + age)).toArray(ResourceLocation[]::new);
        this.models().registerExistingTexture(textures);
        for (int i = 0; i <= info.maxAge(); ++i) {
            blockState.partialState().with((Property)block.ageProperty(), (Comparable)Integer.valueOf(i)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)this.models().cross("block/plants/" + name + "_stage" + i, textures[i]))});
        }
    }

    private void tallBerryBlock(PrehistoricPlantInfo info, TallBerryBushBlock block) {
        this.itemModels().plantBlockItem((Block)block, "_2_stage" + info.maxAge());
        String name = this.key((Block)block).m_135815_();
        VariantBlockStateBuilder blockState = this.getVariantBuilder((Block)block);
        ResourceLocation[] lower = (ResourceLocation[])IntStream.rangeClosed(0, info.maxAge()).mapToObj(age -> FossilMod.location("block/plants/plant_" + name + "_1_stage" + age)).toArray(ResourceLocation[]::new);
        ResourceLocation[] upper = (ResourceLocation[])IntStream.rangeClosed(0, info.maxAge()).mapToObj(age -> FossilMod.location("block/plants/plant_" + name + "_2_stage" + age)).toArray(ResourceLocation[]::new);
        this.models().registerExistingTexture(lower);
        this.models().registerExistingTexture(upper);
        for (int i = 0; i <= info.maxAge(); ++i) {
            blockState.partialState().with((Property)block.ageProperty(), (Comparable)Integer.valueOf(i)).with((Property)TallBerryBushBlock.f_52858_, (Comparable)DoubleBlockHalf.LOWER).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)this.models().cross("block/plants/" + name + "_1_stage" + i, lower[i]))}).partialState().with((Property)block.ageProperty(), (Comparable)Integer.valueOf(i)).with((Property)TallBerryBushBlock.f_52858_, (Comparable)DoubleBlockHalf.UPPER).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)this.models().cross("block/plants/" + name + "_2_stage" + i, upper[i]))});
        }
    }

    public void shortFlowerBlock(ShortFlowerBlock block) {
        this.itemModels().plantBlockItem((Block)block, "");
        ResourceLocation flower = FossilMod.location("block/plants/plant_" + this.key((Block)block).m_135815_());
        this.models().registerExistingTexture(flower);
        this.getVariantBuilder((Block)block).partialState().setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)this.models().cross("block/plants/" + this.key((Block)block).m_135815_(), flower))});
    }

    public void tallFlowerBlock(TallFlowerBlock block) {
        this.itemModels().plantBlockItem((Block)block, "_2");
        ResourceLocation lower = FossilMod.location("block/plants/plant_" + this.key((Block)block).m_135815_() + "_1");
        ResourceLocation upper = FossilMod.location("block/plants/plant_" + this.key((Block)block).m_135815_() + "_2");
        this.models().registerExistingTexture(lower, upper);
        this.getVariantBuilder((Block)block).partialState().with((Property)TallFlowerBlock.f_52858_, (Comparable)DoubleBlockHalf.LOWER).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)this.models().cross("block/plants/" + this.key((Block)block).m_135815_() + "_1", lower))}).partialState().with((Property)TallFlowerBlock.f_52858_, (Comparable)DoubleBlockHalf.UPPER).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)this.models().cross("block/plants/" + this.key((Block)block).m_135815_() + "_2", upper))});
    }

    public void fourTallFlowerBlock(FourTallFlowerBlock block) {
        this.itemModels().plantBlockItem((Block)block, "_1");
        ResourceLocation first = FossilMod.location("block/plants/plant_" + this.key((Block)block).m_135815_() + "_1");
        ResourceLocation second = FossilMod.location("block/plants/plant_" + this.key((Block)block).m_135815_() + "_2");
        ResourceLocation third = FossilMod.location("block/plants/plant_" + this.key((Block)block).m_135815_() + "_3");
        ResourceLocation fourth = FossilMod.location("block/plants/plant_" + this.key((Block)block).m_135815_() + "_4");
        this.models().registerExistingTexture(first, second, third, fourth);
        this.getVariantBuilder((Block)block).partialState().with((Property)FourTallFlowerBlock.LAYER, (Comparable)Integer.valueOf(0)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)this.models().cross("block/plants/" + this.key((Block)block).m_135815_() + "_1", first))}).partialState().with((Property)FourTallFlowerBlock.LAYER, (Comparable)Integer.valueOf(1)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)this.models().cross("block/plants/" + this.key((Block)block).m_135815_() + "_2", second))}).partialState().with((Property)FourTallFlowerBlock.LAYER, (Comparable)Integer.valueOf(2)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)this.models().cross("block/plants/" + this.key((Block)block).m_135815_() + "_3", third))}).partialState().with((Property)FourTallFlowerBlock.LAYER, (Comparable)Integer.valueOf(3)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)this.models().cross("block/plants/" + this.key((Block)block).m_135815_() + "_4", fourth))});
    }

    private ResourceLocation key(Block block) {
        return ForgeRegistries.BLOCKS.getKey((Object)block);
    }

    private static /* synthetic */ ConfiguredModel[] lambda$amphora$4(ModelFile fileTop, ModelFile fileBase, BlockState state) {
        return ConfiguredModel.builder().modelFile(state.m_61143_(AmphoraVaseBlock.HALF) == DoubleBlockHalf.UPPER ? fileTop : fileBase).rotationY(((int)((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122435_() + 180) % 360).build();
    }
}

