/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.forge.world.biome;

import com.github.teamfossilsarcheology.fossil.FossilMod;
import com.github.teamfossilsarcheology.fossil.config.FossilConfig;
import com.github.teamfossilsarcheology.fossil.world.biome.ModBiomes;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.Climate;
import terrablender.api.ParameterUtils;
import terrablender.api.Region;
import terrablender.api.RegionType;

public class ForgeFossilRegion
extends Region {
    public ForgeFossilRegion(String location, RegionType regionType, int weight) {
        super(FossilMod.location(location), regionType, weight);
    }

    public void addBiomes(Registry<Biome> registry, Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> mapper) {
        this.addModifiedVanillaOverworldBiomes(mapper, builder -> {
            List hopfullyCorrectPoints = new ParameterUtils.ParameterPointListBuilder().temperature(new ParameterUtils.Temperature[]{ParameterUtils.Temperature.HOT, ParameterUtils.Temperature.WARM}).humidity(new ParameterUtils.Humidity[]{ParameterUtils.Humidity.ARID, ParameterUtils.Humidity.DRY}).continentalness(new Climate.Parameter[]{ParameterUtils.Continentalness.span((ParameterUtils.Continentalness)ParameterUtils.Continentalness.NEAR_INLAND, (ParameterUtils.Continentalness)ParameterUtils.Continentalness.FAR_INLAND)}).erosion(new ParameterUtils.Erosion[]{ParameterUtils.Erosion.EROSION_5, ParameterUtils.Erosion.EROSION_1, ParameterUtils.Erosion.EROSION_0}).depth(new ParameterUtils.Depth[]{ParameterUtils.Depth.SURFACE, ParameterUtils.Depth.FLOOR}).weirdness(new ParameterUtils.Weirdness[]{ParameterUtils.Weirdness.MID_SLICE_NORMAL_ASCENDING, ParameterUtils.Weirdness.MID_SLICE_NORMAL_DESCENDING}).build();
            builder.replaceBiome(Biomes.f_48159_, ModBiomes.VOLCANO_KEY);
            builder.replaceBiome(Biomes.f_48194_, ModBiomes.VOLCANO_KEY);
            hopfullyCorrectPoints.forEach(point -> builder.replaceBiome(point, ModBiomes.VOLCANO_KEY));
        });
    }

    public int getWeight() {
        return FossilConfig.getInt("volcanoBiomeRarity");
    }
}

