/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.loot;

import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.Prehistoric;
import com.github.teamfossilsarcheology.fossil.loot.ModLootItemFunctionTypes;
import com.github.teamfossilsarcheology.fossil.tags.ModItemTags;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.jetbrains.annotations.NotNull;

public class CustomizeToDinoFunction
extends LootItemConditionalFunction {
    private final LootContext.EntityTarget entityTarget;

    protected CustomizeToDinoFunction(LootItemCondition[] lootItemConditions, LootContext.EntityTarget entityTarget) {
        super(lootItemConditions);
        this.entityTarget = entityTarget;
    }

    public static LootItemConditionalFunction.Builder<?> apply(LootContext.EntityTarget target) {
        return CustomizeToDinoFunction.m_80683_(lootItemConditions -> new CustomizeToDinoFunction((LootItemCondition[])lootItemConditions, target));
    }

    @NotNull
    protected ItemStack m_7372_(ItemStack stack, LootContext context) {
        Entity entity;
        if (!stack.m_41619_() && (entity = (Entity)context.m_78953_(this.entityTarget.m_79003_())) instanceof Prehistoric) {
            Prehistoric prehistoric = (Prehistoric)entity;
            if (stack.m_204117_(ModItemTags.UNCOOKED_MEAT)) {
                stack.m_41764_(Math.min(prehistoric.getAgeInDays(), prehistoric.data().adultAgeDays()));
                return prehistoric.m_6060_() ? new ItemStack((ItemLike)prehistoric.info().cookedFoodItem, stack.m_41613_()) : stack;
            }
        }
        return stack;
    }

    @NotNull
    public LootItemFunctionType m_7162_() {
        return (LootItemFunctionType)ModLootItemFunctionTypes.CUSTOMIZE_TO_DINOSAUR.get();
    }

    public static class Serializer
    extends LootItemConditionalFunction.Serializer<CustomizeToDinoFunction> {
        public void serialize(JsonObject json, CustomizeToDinoFunction value, JsonSerializationContext serializationContext) {
            super.m_6170_(json, (LootItemConditionalFunction)value, serializationContext);
            json.add("entity", serializationContext.serialize((Object)value.entityTarget));
        }

        @NotNull
        public CustomizeToDinoFunction deserialize(JsonObject object, JsonDeserializationContext deserializationContext, LootItemCondition[] conditions) {
            LootContext.EntityTarget entityTarget = (LootContext.EntityTarget)GsonHelper.m_13836_((JsonObject)object, (String)"entity", (JsonDeserializationContext)deserializationContext, LootContext.EntityTarget.class);
            return new CustomizeToDinoFunction(conditions, entityTarget);
        }
    }
}

