/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.recipe;

import com.google.gson.JsonObject;
import java.util.function.Consumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.core.Registry;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class WithFuelRecipeBuilder
implements RecipeBuilder {
    protected final String modId;
    protected final ItemLike itemInput;
    protected final ItemLike itemFuel;
    protected final ItemLike itemOutput;
    protected final int duration;

    protected WithFuelRecipeBuilder(String modId, ItemLike itemInput, ItemLike itemFuel, ItemLike itemOutput, int duration) {
        this.modId = modId;
        this.itemInput = itemInput;
        this.itemFuel = itemFuel;
        this.itemOutput = itemOutput;
        this.duration = duration;
    }

    @NotNull
    public RecipeBuilder m_126132_(@NotNull String criterionName, @NotNull CriterionTriggerInstance criterionTrigger) {
        return this;
    }

    @NotNull
    public RecipeBuilder m_126145_(@Nullable String groupName) {
        return this;
    }

    @NotNull
    public Item m_142372_() {
        return this.itemOutput.m_5456_();
    }

    public void m_176498_(@NotNull Consumer<FinishedRecipe> consumer) {
        this.m_126140_(consumer, this.getDefaultRecipeId());
    }

    public void m_176500_(@NotNull Consumer<FinishedRecipe> consumer, @NotNull String recipeId) {
        ResourceLocation resourceLocation2 = new ResourceLocation(recipeId);
        ResourceLocation resourceLocation = this.getDefaultRecipeId();
        if (resourceLocation2.equals((Object)resourceLocation)) {
            throw new IllegalStateException("Recipe " + recipeId + " should remove its 'save' argument as it is equal to default one");
        }
        this.m_126140_(consumer, resourceLocation2);
    }

    protected abstract ResourceLocation getDefaultRecipeId();

    public static abstract class Result
    implements FinishedRecipe {
        private final ResourceLocation recipeLocation;
        private final Ingredient input;
        private final Ingredient fuel;
        private final ItemLike output;
        private final int duration;

        protected Result(ResourceLocation recipeLocation, Ingredient input, Ingredient fuel, ItemLike output, int duration) {
            this.recipeLocation = recipeLocation;
            this.input = input;
            this.fuel = fuel;
            this.output = output;
            this.duration = duration;
        }

        public void m_7917_(JsonObject json) {
            json.add("input", this.input.m_43942_());
            json.add("fuel", this.fuel.m_43942_());
            json.addProperty("result", Registry.f_122827_.m_7981_((Object)this.output.m_5456_()).toString());
            json.addProperty("duration", (Number)this.duration);
        }

        @NotNull
        public ResourceLocation m_6445_() {
            return this.recipeLocation;
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

