/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.world.feature.placement;

import com.github.teamfossilsarcheology.fossil.config.FossilConfig;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.Vec3i;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacementType;
import org.jetbrains.annotations.NotNull;

public class LazyRandomSpreadPlacement
extends StructurePlacement {
    public static final Codec<LazyRandomSpreadPlacement> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("spacingEntry").forGetter(LazyRandomSpreadPlacement::spacingEntry), (App)Codec.STRING.fieldOf("separationEntry").forGetter(LazyRandomSpreadPlacement::separationEntry), (App)RandomSpreadType.f_205014_.optionalFieldOf("spread_type", (Object)RandomSpreadType.LINEAR).forGetter(LazyRandomSpreadPlacement::spreadType), (App)ExtraCodecs.f_144628_.fieldOf("salt").forGetter(rec$ -> ((LazyRandomSpreadPlacement)((Object)((Object)((Object)rec$)))).m_227075_())).apply((Applicative)instance, LazyRandomSpreadPlacement::new));
    public static final StructurePlacementType<LazyRandomSpreadPlacement> TYPE = () -> CODEC;
    private final String spacingEntry;
    private final String separationEntry;
    private final RandomSpreadType spreadType;

    public LazyRandomSpreadPlacement(String spacingEntry, String separationEntry, RandomSpreadType spreadType, int salt) {
        super(Vec3i.f_123288_, StructurePlacement.FrequencyReductionMethod.DEFAULT, 1.0f, salt, Optional.empty());
        this.spacingEntry = spacingEntry;
        this.separationEntry = separationEntry;
        this.spreadType = spreadType;
    }

    public String spacingEntry() {
        return this.spacingEntry;
    }

    public String separationEntry() {
        return this.separationEntry;
    }

    public RandomSpreadType spreadType() {
        return this.spreadType;
    }

    public ChunkPos getPotentialFeatureChunk(long seed, int x, int z) {
        int spacing = FossilConfig.getInt(this.spacingEntry);
        int separation = FossilConfig.getInt(this.separationEntry);
        int m = Math.floorDiv(x, spacing);
        int n = Math.floorDiv(z, spacing);
        WorldgenRandom worldgenRandom = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
        worldgenRandom.m_190058_(seed, m, n, this.m_227075_());
        int o = spacing - separation;
        int p = this.spreadType().m_227018_((RandomSource)worldgenRandom, o);
        int q = this.spreadType().m_227018_((RandomSource)worldgenRandom, o);
        return new ChunkPos(m * spacing + p, n * spacing + q);
    }

    protected boolean m_214090_(ChunkGenerator generator, RandomState randomState, long seed, int x, int z) {
        ChunkPos chunkPos = this.getPotentialFeatureChunk(seed, x, z);
        return chunkPos.f_45578_ == x && chunkPos.f_45579_ == z;
    }

    @NotNull
    public StructurePlacementType<?> m_203443_() {
        return TYPE;
    }
}

