/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.world.feature.placement;

import com.github.teamfossilsarcheology.fossil.FossilMod;
import com.github.teamfossilsarcheology.fossil.config.FossilConfig;
import com.github.teamfossilsarcheology.fossil.world.feature.ModOreFeatures;
import com.github.teamfossilsarcheology.fossil.world.feature.placement.LazyCountPlacement;
import dev.architectury.registry.level.biome.BiomeModifications;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;

public class ModPlacedFeatures {
    public static final ResourceKey<PlacedFeature> MOAI_STATUE_KEY = ModPlacedFeatures.createKey("moai_statue");

    private static ResourceKey<PlacedFeature> createKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registry.f_194567_, (ResourceLocation)FossilMod.location(name));
    }

    public static void register() {
        Holder upperFossilBlockPlaced = PlacementUtils.m_206509_((String)"fossil_block_no_sandstone_placed_upper", ModOreFeatures.FOSSIL_BLOCK_NO_SANDSTONE, ModPlacedFeatures.commonOrePlacement("fossilOreRarity", (PlacementModifier)HeightRangePlacement.m_191692_((VerticalAnchor)VerticalAnchor.m_158922_((int)76), (VerticalAnchor)VerticalAnchor.m_158929_())));
        Holder middleFossilBlockPlaced = PlacementUtils.m_206509_((String)"fossil_block_placed_middle", ModOreFeatures.FOSSIL_BLOCK, ModPlacedFeatures.commonOrePlacement("fossilOreRarity", (PlacementModifier)HeightRangePlacement.m_191692_((VerticalAnchor)VerticalAnchor.m_158922_((int)0), (VerticalAnchor)VerticalAnchor.m_158922_((int)75))));
        Holder deepFossilBlockPlaced = PlacementUtils.m_206509_((String)"fossil_block_placed_deep", ModOreFeatures.FOSSIL_BLOCK, ModPlacedFeatures.commonOrePlacement("fossilOreRarity", (PlacementModifier)HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158930_((int)0), (VerticalAnchor)VerticalAnchor.m_158922_((int)0))));
        Holder volcanicRockPlaced = PlacementUtils.m_206509_((String)"volcanic_rock_placed", ModOreFeatures.VOLCANIC_ROCK, ModPlacedFeatures.commonOrePlacement(2, (PlacementModifier)HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158921_(), (VerticalAnchor)VerticalAnchor.m_158922_((int)0))));
        Holder permafrostBlockPlaced = PlacementUtils.m_206509_((String)"permafrost_block_placed", ModOreFeatures.PERMAFROST_BLOCK, ModPlacedFeatures.commonOrePlacement("permafrostRarity", (PlacementModifier)HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158930_((int)100), (VerticalAnchor)VerticalAnchor.m_158930_((int)256))));
        Holder oreAmber = PlacementUtils.m_206509_((String)"amber_ore_placed", ModOreFeatures.ORE_AMBER, ModPlacedFeatures.commonOrePlacement(2, (PlacementModifier)HeightRangePlacement.m_191692_((VerticalAnchor)VerticalAnchor.m_158922_((int)-10), (VerticalAnchor)VerticalAnchor.m_158922_((int)80))));
        Holder oreAmberBuried = PlacementUtils.m_206509_((String)"ore_amber_buried", ModOreFeatures.ORE_AMBER_BURIED, ModPlacedFeatures.commonOrePlacement(5, (PlacementModifier)HeightRangePlacement.m_191692_((VerticalAnchor)VerticalAnchor.m_158922_((int)-10), (VerticalAnchor)VerticalAnchor.m_158922_((int)80))));
        BiomeModifications.addProperties((context, mutable) -> {
            if (FossilConfig.isEnabled("generateFossils")) {
                mutable.getGenerationProperties().addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, upperFossilBlockPlaced);
                mutable.getGenerationProperties().addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, middleFossilBlockPlaced);
                mutable.getGenerationProperties().addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, deepFossilBlockPlaced);
            }
            if (FossilConfig.isEnabled("generateVolcanicRock")) {
                mutable.getGenerationProperties().addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, volcanicRockPlaced);
            }
            if (FossilConfig.isEnabled("generatePermafrost") && (double)mutable.getClimateProperties().getTemperature() < 0.15) {
                mutable.getGenerationProperties().addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, permafrostBlockPlaced);
            }
            mutable.getGenerationProperties().addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, oreAmber);
            mutable.getGenerationProperties().addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, oreAmberBuried);
        });
    }

    private static List<PlacementModifier> orePlacement(PlacementModifier placementModifier, PlacementModifier placementModifier2) {
        return List.of(placementModifier, InSquarePlacement.m_191715_(), placementModifier2, BiomeFilter.m_191561_());
    }

    private static List<PlacementModifier> commonOrePlacement(String configEntry, PlacementModifier placementModifier) {
        return ModPlacedFeatures.orePlacement((PlacementModifier)new LazyCountPlacement(configEntry), placementModifier);
    }

    private static List<PlacementModifier> commonOrePlacement(int count, PlacementModifier placementModifier) {
        return ModPlacedFeatures.orePlacement((PlacementModifier)CountPlacement.m_191628_((int)count), placementModifier);
    }

    private static List<PlacementModifier> rareOrePlacement(int rarity, PlacementModifier placementModifier) {
        return ModPlacedFeatures.orePlacement((PlacementModifier)RarityFilter.m_191900_((int)rarity), placementModifier);
    }
}

