/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.world.feature.structures;

import com.github.teamfossilsarcheology.fossil.FossilMod;
import com.github.teamfossilsarcheology.fossil.world.feature.structures.ModStructureType;
import com.github.teamfossilsarcheology.fossil.world.feature.structures.ModTemplatePools;
import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.JigsawBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.pools.JigsawJunction;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.jetbrains.annotations.NotNull;

public class AnuCastleStructure
extends Structure {
    public static final Codec<AnuCastleStructure> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)AnuCastleStructure.m_226567_((RecordCodecBuilder.Instance)instance)).apply((Applicative)instance, AnuCastleStructure::new));

    public AnuCastleStructure(Structure.StructureSettings settings) {
        super(settings);
    }

    @NotNull
    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        ChunkPos chunkPos = context.f_226628_();
        BlockPos blockPos = new BlockPos(chunkPos.m_45604_(), 63, chunkPos.m_45605_());
        return AnuCastleStructure.addPieces(context, blockPos);
    }

    private static Optional<Structure.GenerationStub> addPieces(Structure.GenerationContext context, BlockPos blockPos) {
        RegistryAccess registryAccess = context.f_226621_();
        StructureTemplateManager structureTemplateManager = context.f_226625_();
        WorldgenRandom worldgenRandom = context.f_226626_();
        Registry templatePools = registryAccess.m_175515_(Registry.f_122884_);
        Rotation rotation = Rotation.NONE;
        StructureTemplatePool structureTemplatePool = (StructureTemplatePool)templatePools.m_6246_(ModTemplatePools.ANU_CASTLE_START);
        StructurePoolElement structurePoolElement = structureTemplatePool.m_227355_((RandomSource)worldgenRandom);
        PoolElementStructurePiece poolElementStructurePiece = new PoolElementStructurePiece(structureTemplateManager, structurePoolElement, blockPos, structurePoolElement.m_210540_(), rotation, structurePoolElement.m_214015_(structureTemplateManager, blockPos, rotation));
        BoundingBox boundingBox = poolElementStructurePiece.m_73547_();
        int posY = blockPos.m_123342_();
        int delta = boundingBox.m_162396_() + poolElementStructurePiece.m_72647_();
        poolElementStructurePiece.m_6324_(0, posY - delta, 0);
        return Optional.of(new Structure.GenerationStub(blockPos, builder -> {
            ArrayList pieces = Lists.newArrayList();
            pieces.add(poolElementStructurePiece);
            Placer placer = new Placer((Registry<StructureTemplatePool>)templatePools, 4, structureTemplateManager, pieces, (RandomSource)worldgenRandom);
            placer.placing.addLast(new PieceState(poolElementStructurePiece, 0));
            while (!placer.placing.isEmpty()) {
                PieceState pieceState = placer.placing.removeFirst();
                placer.tryPlacingChildren(pieceState.piece, pieceState.depth);
            }
            pieces.forEach(arg_0 -> ((StructurePiecesBuilder)builder).m_142679_(arg_0));
        }));
    }

    @NotNull
    public StructureType<?> m_213658_() {
        return ModStructureType.ANU_CASTLE;
    }

    private static final class Placer {
        private final Registry<StructureTemplatePool> pools;
        private final int maxDepth;
        private final StructureTemplateManager structureTemplateManager;
        private final List<? super PoolElementStructurePiece> pieces;
        private final RandomSource random;
        private final Deque<PieceState> placing = Queues.newArrayDeque();

        public Placer(Registry<StructureTemplatePool> pools, int maxDepth, StructureTemplateManager structureTemplateManager, List<? super PoolElementStructurePiece> list, RandomSource random) {
            this.pools = pools;
            this.maxDepth = maxDepth;
            this.structureTemplateManager = structureTemplateManager;
            this.pieces = list;
            this.random = random;
        }

        private void tryPlacingChildren(PoolElementStructurePiece baseStructurePiece, int depth) {
            StructurePoolElement structurePoolElement = baseStructurePiece.m_209918_();
            BlockPos baseStructurePosition = baseStructurePiece.m_72646_();
            Rotation baseStructureRotation = baseStructurePiece.m_6830_();
            StructureTemplatePool.Projection projection = structurePoolElement.m_210539_();
            BoundingBox baseStructureBoundingBox = baseStructurePiece.m_73547_();
            block0: for (StructureTemplate.StructureBlockInfo baseStructureJigSaw : structurePoolElement.m_213638_(this.structureTemplateManager, baseStructurePosition, baseStructureRotation, this.random)) {
                ResourceLocation poolLocation = new ResourceLocation(baseStructureJigSaw.f_74677_.m_128461_("pool"));
                Optional baseTargetPool = this.pools.m_6612_(poolLocation);
                if (baseTargetPool.isEmpty() || ((StructureTemplatePool)baseTargetPool.get()).m_210590_() == 0 && !Objects.equals(poolLocation, Pools.f_127186_.m_135782_())) {
                    FossilMod.LOGGER.warn("Empty or non-existent pool: {}", (Object)poolLocation);
                    continue;
                }
                ArrayList targetPoolElements = Lists.newArrayList();
                if (depth != this.maxDepth) {
                    targetPoolElements.addAll(((StructureTemplatePool)baseTargetPool.get()).m_227362_(this.random));
                }
                if (targetPoolElements.isEmpty()) continue;
                BlockPos baseJigsawPosition = baseStructureJigSaw.f_74675_;
                Direction baseJigsawDirection = JigsawBlock.m_54250_((BlockState)baseStructureJigSaw.f_74676_);
                BlockPos expectedJigsawPosition = baseJigsawPosition.m_121945_(baseJigsawDirection);
                int baseMinY = baseStructureBoundingBox.m_162396_();
                int baseJigsawOffset = baseJigsawPosition.m_123342_() - baseMinY;
                StructurePoolElement targetElement = (StructurePoolElement)targetPoolElements.get(0);
                List allTargetJigsaws = targetElement.m_213638_(this.structureTemplateManager, BlockPos.f_121853_, baseStructureRotation, this.random);
                for (StructureTemplate.StructureBlockInfo targetJigsaw : allTargetJigsaws) {
                    int groundLevelDelta = baseStructurePiece.m_72647_();
                    if (!JigsawBlock.m_54245_((StructureTemplate.StructureBlockInfo)baseStructureJigSaw, (StructureTemplate.StructureBlockInfo)targetJigsaw)) continue;
                    BlockPos targetJigsawPosition = targetJigsaw.f_74675_;
                    BlockPos vecToTargetJigsaw = expectedJigsawPosition.m_121996_((Vec3i)targetJigsawPosition);
                    BoundingBox targetBoundingBox = targetElement.m_214015_(this.structureTemplateManager, vecToTargetJigsaw, baseStructureRotation);
                    PoolElementStructurePiece poolElementStructurePiece2 = new PoolElementStructurePiece(this.structureTemplateManager, targetElement, vecToTargetJigsaw, groundLevelDelta, baseStructureRotation, targetBoundingBox);
                    baseStructurePiece.m_209916_(new JigsawJunction(expectedJigsawPosition.m_123341_(), baseMinY + groundLevelDelta, expectedJigsawPosition.m_123343_(), 0, targetElement.m_210539_()));
                    poolElementStructurePiece2.m_209916_(new JigsawJunction(baseJigsawPosition.m_123341_(), baseMinY + baseJigsawOffset - targetJigsawPosition.m_123342_() + groundLevelDelta, baseJigsawPosition.m_123343_(), 0, projection));
                    this.pieces.add((PoolElementStructurePiece)poolElementStructurePiece2);
                    if (depth + 1 > this.maxDepth) continue block0;
                    this.placing.addLast(new PieceState(poolElementStructurePiece2, depth + 1));
                    continue block0;
                }
            }
        }
    }

    private static final class PieceState {
        private final PoolElementStructurePiece piece;
        private final int depth;

        public PieceState(PoolElementStructurePiece poolElementStructurePiece, int i) {
            this.piece = poolElementStructurePiece;
            this.depth = i;
        }
    }
}

