/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.world.feature.tree;

import com.github.teamfossilsarcheology.fossil.block.ModBlocks;
import com.github.teamfossilsarcheology.fossil.world.feature.tree.CustomTreeFeature;
import com.github.teamfossilsarcheology.fossil.world.feature.tree.TreeBranchLayouts;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class SigillariaTreeFeature
extends CustomTreeFeature {
    boolean placeLargeVariant(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel level = context.m_159774_();
        BlockPos pos = context.m_159777_();
        BlockState log = ((RotatedPillarBlock)ModBlocks.SIGILLARIA_LOG.get()).m_49966_();
        BlockState leaves = ((LeavesBlock)ModBlocks.SIGILLARIA_LEAVES.get()).m_49966_();
        int treeHeight = 21 + context.m_225041_().m_188503_(9) - 4;
        int m = this.getMaxFreeTreeHeight((LevelSimulatedReader)level, treeHeight, pos);
        if (m < treeHeight) {
            return false;
        }
        int thickHeight = (int)Math.floor((double)treeHeight * 0.35);
        for (int i = 0; i < treeHeight; ++i) {
            BlockPos northPos;
            BlockState stateNorth;
            BlockPos southPos;
            BlockState stateSouth;
            BlockPos westPos;
            BlockState stateWest;
            level.m_7731_(pos.m_6630_(i), log, 19);
            if (i >= thickHeight) continue;
            BlockPos eastPos = pos.m_7918_(1, i, 0);
            BlockState stateEast = level.m_8055_(eastPos);
            if (stateEast.m_60767_().m_76336_()) {
                level.m_7731_(eastPos, log, 19);
            }
            if ((stateWest = level.m_8055_(westPos = pos.m_7918_(-1, i, 0))).m_60767_().m_76336_()) {
                level.m_7731_(westPos, log, 19);
            }
            if ((stateSouth = level.m_8055_(southPos = pos.m_7918_(0, i, 1))).m_60767_().m_76336_()) {
                level.m_7731_(southPos, log, 19);
            }
            if (!(stateNorth = level.m_8055_(northPos = pos.m_7918_(0, i, -1))).m_60767_().m_76336_()) continue;
            level.m_7731_(northPos, log, 19);
        }
        BlockPos north = pos.m_122012_().m_122012_();
        BlockPos south = pos.m_122019_().m_122019_();
        BlockPos east = pos.m_122029_().m_122029_();
        BlockPos west = pos.m_122024_().m_122024_();
        level.m_7731_(north, (BlockState)log.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Z), 19);
        level.m_7731_(south, (BlockState)log.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Z), 19);
        level.m_7731_(east, (BlockState)log.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.X), 19);
        level.m_7731_(west, (BlockState)log.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.X), 19);
        if (context.m_225041_().m_188499_()) {
            List<BlockPos> leafPositions = context.m_225041_().m_188499_() ? TreeBranchLayouts.SIGILLARIA_LEAVES_A : TreeBranchLayouts.SIGILLARIA_LEAVES_B;
            for (int i = 0; i < leafPositions.size(); ++i) {
                BlockPos leafPos = leafPositions.get(i);
                BlockPos worldPos = pos.m_6630_(treeHeight - 2).m_121955_((Vec3i)leafPos);
                BlockState stateAtPos = level.m_8055_(worldPos);
                if (!stateAtPos.m_60767_().m_76336_()) continue;
                this.placeLeaf(level, pos.m_6630_(treeHeight - 2).m_121955_((Vec3i)leafPos), leaves);
            }
        } else {
            BlockState stateAtPos;
            BlockPos worldPos;
            BlockPos branchTop2;
            BlockPos branchTop1;
            int i;
            int branchLength = 4;
            int branchTrunkHeight = 7;
            boolean isZAligned = context.m_225041_().m_188499_();
            if (isZAligned) {
                for (i = 0; i < branchLength; ++i) {
                    forkPos = pos.m_6630_(treeHeight + i).m_7918_(0, 0, -1 - i);
                    stateAtFork = level.m_8055_(forkPos);
                    if (!stateAtFork.m_60767_().m_76336_()) continue;
                    level.m_7731_(forkPos, log, 19);
                }
                for (i = 0; i < branchLength - 1; ++i) {
                    forkPos = pos.m_6630_(treeHeight + i).m_7918_(0, -1, -1 - i);
                    stateAtFork = level.m_8055_(forkPos);
                    if (!stateAtFork.m_60767_().m_76336_()) continue;
                    level.m_7731_(forkPos, log, 19);
                }
                for (i = 0; i < branchLength; ++i) {
                    forkPos = pos.m_6630_(treeHeight + i).m_7918_(0, 0, 1 + i);
                    stateAtFork = level.m_8055_(forkPos);
                    if (!stateAtFork.m_60767_().m_76336_()) continue;
                    level.m_7731_(forkPos, log, 19);
                }
                for (i = 0; i < branchLength - 1; ++i) {
                    forkPos = pos.m_6630_(treeHeight + i).m_7918_(0, -1, 1 + i);
                    stateAtFork = level.m_8055_(forkPos);
                    if (!stateAtFork.m_60767_().m_76336_()) continue;
                    level.m_7731_(forkPos, log, 19);
                }
                branchTop1 = pos.m_6630_(treeHeight + branchLength - 1).m_7918_(0, branchTrunkHeight, -branchLength);
                branchTop2 = pos.m_6630_(treeHeight + branchLength - 1).m_7918_(0, branchTrunkHeight, branchLength);
            } else {
                for (i = 0; i < branchLength; ++i) {
                    forkPos = pos.m_6630_(treeHeight + i).m_7918_(-1 - i, 0, 0);
                    stateAtFork = level.m_8055_(forkPos);
                    if (!stateAtFork.m_60767_().m_76336_()) continue;
                    level.m_7731_(forkPos, log, 19);
                }
                for (i = 0; i < branchLength - 1; ++i) {
                    forkPos = pos.m_6630_(treeHeight + i).m_7918_(-1 - i, -1, 0);
                    stateAtFork = level.m_8055_(forkPos);
                    if (!stateAtFork.m_60767_().m_76336_()) continue;
                    level.m_7731_(forkPos, log, 19);
                }
                for (i = 0; i < branchLength; ++i) {
                    forkPos = pos.m_6630_(treeHeight + i).m_7918_(1 + i, 0, 0);
                    stateAtFork = level.m_8055_(forkPos);
                    if (!stateAtFork.m_60767_().m_76336_()) continue;
                    level.m_7731_(forkPos, log, 19);
                }
                for (i = 0; i < branchLength - 1; ++i) {
                    forkPos = pos.m_6630_(treeHeight + i).m_7918_(1 + i, -1, 0);
                    stateAtFork = level.m_8055_(forkPos);
                    if (!stateAtFork.m_60767_().m_76336_()) continue;
                    level.m_7731_(forkPos, log, 19);
                }
                branchTop1 = pos.m_6630_(treeHeight + branchLength - 1).m_7918_(-branchLength, branchTrunkHeight, 0);
                branchTop2 = pos.m_6630_(treeHeight + branchLength - 1).m_7918_(branchLength, branchTrunkHeight, 0);
            }
            for (i = 0; i < branchTrunkHeight; ++i) {
                BlockState stateAtFork2;
                BlockState stateAtFork1 = level.m_8055_(branchTop1.m_7918_(0, -i - 1, 0));
                if (stateAtFork1.m_60767_().m_76336_()) {
                    level.m_7731_(branchTop1.m_7918_(0, -i - 1, 0), log, 19);
                }
                if (!(stateAtFork2 = level.m_8055_(branchTop2.m_7918_(0, -i - 1, 0))).m_60767_().m_76336_()) continue;
                level.m_7731_(branchTop2.m_7918_(0, -i - 1, 0), log, 19);
            }
            for (BlockPos leafOffset : TreeBranchLayouts.SIGILLARIA_LEAVES_B) {
                worldPos = branchTop1.m_121955_((Vec3i)leafOffset).m_7495_().m_7495_();
                stateAtPos = level.m_8055_(worldPos);
                if (!stateAtPos.m_60767_().m_76336_()) continue;
                this.placeLeaf(level, worldPos, leaves);
            }
            for (BlockPos leafOffset : TreeBranchLayouts.SIGILLARIA_LEAVES_B) {
                worldPos = branchTop2.m_121955_((Vec3i)leafOffset).m_7495_().m_7495_();
                stateAtPos = level.m_8055_(worldPos);
                if (!stateAtPos.m_60767_().m_76336_()) continue;
                this.placeLeaf(level, worldPos, leaves);
            }
        }
        return true;
    }

    boolean placeMediumVariant(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel level = context.m_159774_();
        BlockPos pos = context.m_159777_();
        BlockState log = ((RotatedPillarBlock)ModBlocks.SIGILLARIA_LOG.get()).m_49966_();
        BlockState leaves = ((LeavesBlock)ModBlocks.SIGILLARIA_LEAVES.get()).m_49966_();
        int treeHeight = 16 + context.m_225041_().m_188503_(7) - 3;
        int m = this.getMaxFreeTreeHeight((LevelSimulatedReader)level, treeHeight, pos);
        if (m < treeHeight) {
            return false;
        }
        for (int i = 0; i < treeHeight; ++i) {
            level.m_7731_(pos.m_6630_(i), log, 19);
        }
        BlockPos north = pos.m_122012_();
        BlockPos south = pos.m_122019_();
        BlockPos east = pos.m_122029_();
        BlockPos west = pos.m_122024_();
        level.m_7731_(north, (BlockState)log.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Z), 19);
        level.m_7731_(south, (BlockState)log.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Z), 19);
        level.m_7731_(east, (BlockState)log.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.X), 19);
        level.m_7731_(west, (BlockState)log.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.X), 19);
        List<BlockPos> leafPositions = context.m_225041_().m_188499_() ? TreeBranchLayouts.SIGILLARIA_LEAVES_A : TreeBranchLayouts.SIGILLARIA_LEAVES_B;
        for (int i = 0; i < leafPositions.size(); ++i) {
            BlockPos leafPos = leafPositions.get(i);
            BlockPos worldPos = pos.m_6630_(treeHeight - 2).m_121955_((Vec3i)leafPos);
            BlockState stateAtPos = level.m_8055_(worldPos);
            if (!stateAtPos.m_60767_().m_76336_()) continue;
            this.placeLeaf(level, pos.m_6630_(treeHeight - 2).m_121955_((Vec3i)leafPos), leaves);
        }
        return true;
    }

    boolean placeSmallVariant(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel level = context.m_159774_();
        BlockPos pos = context.m_159777_();
        BlockState log = ((RotatedPillarBlock)ModBlocks.SIGILLARIA_LOG.get()).m_49966_();
        BlockState leaves = ((LeavesBlock)ModBlocks.SIGILLARIA_LEAVES.get()).m_49966_();
        int treeHeight = 8 + context.m_225041_().m_188503_(3) - 1;
        int m = this.getMaxFreeTreeHeight((LevelSimulatedReader)level, treeHeight, pos);
        if (m < treeHeight) {
            return false;
        }
        for (int i = 0; i < treeHeight; ++i) {
            level.m_7731_(pos.m_6630_(i), log, 19);
        }
        BlockPos north = pos.m_122012_();
        BlockPos south = pos.m_122019_();
        BlockPos east = pos.m_122029_();
        BlockPos west = pos.m_122024_();
        level.m_7731_(north, (BlockState)log.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Z), 19);
        level.m_7731_(south, (BlockState)log.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Z), 19);
        level.m_7731_(east, (BlockState)log.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.X), 19);
        level.m_7731_(west, (BlockState)log.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.X), 19);
        List<BlockPos> leafPositions = context.m_225041_().m_188499_() ? TreeBranchLayouts.SIGILLARIA_SMALL_VARIANT_A : TreeBranchLayouts.SIGILLARIA_SMALL_VARIANT_B;
        for (int i = 0; i < leafPositions.size(); ++i) {
            BlockPos leafPos = leafPositions.get(i);
            BlockPos worldPos = pos.m_6630_(treeHeight - 1).m_121955_((Vec3i)leafPos);
            BlockState stateAtPos = level.m_8055_(worldPos);
            if (!stateAtPos.m_60767_().m_76336_()) continue;
            this.placeLeaf(level, pos.m_6630_(treeHeight - 1).m_121955_((Vec3i)leafPos), leaves);
        }
        return true;
    }

    @Override
    protected boolean placeTree(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        switch (context.m_225041_().m_188503_(8)) {
            case 0: 
            case 1: {
                return this.placeSmallVariant(context);
            }
            case 2: 
            case 3: 
            case 4: {
                return this.placeMediumVariant(context);
            }
            case 5: 
            case 6: 
            case 7: {
                return this.placeLargeVariant(context);
            }
        }
        return true;
    }
}

