/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.block;

import com.github.teamfossilsarcheology.fossil.block.ModBlocks;
import com.github.teamfossilsarcheology.fossil.block.custom_blocks.CrataegusBushBlock;
import com.github.teamfossilsarcheology.fossil.block.custom_blocks.EphedraBushBlock;
import com.github.teamfossilsarcheology.fossil.block.custom_blocks.VacciniumBushBlock;
import com.github.teamfossilsarcheology.fossil.item.FlowerSeedsItem;
import com.github.teamfossilsarcheology.fossil.item.ModItems;
import com.github.teamfossilsarcheology.fossil.item.ModTabs;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2261;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_4176;

public enum PrehistoricPlantInfo {
    BENNETTITALES_LARGE(Size.DOUBLE_GROWABLE, class_2248.method_9541((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)28.0, (double)14.0)),
    BENNETTITALES_SMALL(Size.SINGLE_GROWABLE, BENNETTITALES_LARGE, "bennettitales", class_2248.method_9541((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0)),
    CEPHALOTAXUS(Size.SINGLE, class_2248.method_9541((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)10.0, (double)14.0)),
    CRATAEGUS(Size.DOUBLE_BERRY, class_259.method_1073(), 2, 3),
    CYATHEA(Size.FOUR, class_2248.method_9541((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0)),
    DICTYOPHYLLUM(Size.SINGLE, class_2248.method_9541((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0)),
    DILLHOFFIA(Size.SINGLE, class_2248.method_9541((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)13.0, (double)14.0)),
    DIPTERIS(Size.DOUBLE, class_2248.method_9541((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)22.0, (double)15.0)),
    DUISBERGIA(Size.DOUBLE, class_2248.method_9541((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)32.0, (double)13.0)),
    EPHEDRA(Size.SINGLE_BERRY, class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0), 1, 1),
    FLORISSANTIA(Size.SINGLE, class_2248.method_9541((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)11.0, (double)12.0)),
    FOOZIA(Size.DOUBLE, class_2248.method_9541((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)32.0, (double)14.0)),
    HORSETAIL_LARGE(Size.DOUBLE_GROWABLE, class_2248.method_9541((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)32.0, (double)14.0)),
    HORSETAIL_SMALL(Size.SINGLE_GROWABLE, HORSETAIL_LARGE, "horsetail", class_2248.method_9541((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0)),
    LICOPODIOPHYTA(Size.SINGLE, class_2248.method_9541((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)10.0, (double)14.0)),
    MUTANT_PLANT(Size.DOUBLE, class_2248.method_9541((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)32.0, (double)14.0)),
    OSMUNDA(Size.SINGLE, class_2248.method_9541((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)15.0, (double)14.0)),
    SAGENOPTERIS(Size.SINGLE, class_2248.method_9541((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)14.0, (double)12.0)),
    SARRACENIA(Size.DOUBLE, class_2248.method_9541((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)28.0, (double)13.0)),
    VACCINIUM(Size.SINGLE_BERRY, class_259.method_1073(), 2, 3),
    WELWITSCHIA(Size.SINGLE, class_2248.method_9541((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)5.0, (double)13.0)),
    ZAMITES(Size.DOUBLE, class_2248.method_9541((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)32.0, (double)13.0));

    private static List<PrehistoricPlantInfo> seedsCache;
    private final Size size;
    private final String resourceName;
    private final class_265 shape;
    private PrehistoricPlantInfo tallPlant;
    private int berryAge;
    private int maxAge;
    private RegistrySupplier<class_1792> berryItem;
    private String commonName;
    private RegistrySupplier<? extends class_2261> plantBlock;
    private RegistrySupplier<class_1792> fossilizedPlantSeedItem;
    private RegistrySupplier<FlowerSeedsItem> plantSeedItem;

    private PrehistoricPlantInfo(Size size, class_265 shape) {
        this.size = size;
        this.shape = shape;
        this.resourceName = this.name().toLowerCase(Locale.ROOT);
    }

    private PrehistoricPlantInfo(Size size, PrehistoricPlantInfo tallPlant, String commonName, class_265 shape) {
        this.size = size;
        this.resourceName = this.name().toLowerCase(Locale.ROOT);
        this.tallPlant = tallPlant;
        this.commonName = commonName;
        this.shape = shape;
    }

    private PrehistoricPlantInfo(Size size, class_265 shape, int berryAge, int maxAge) {
        this.size = size;
        this.resourceName = this.name().toLowerCase(Locale.ROOT);
        this.berryAge = berryAge;
        this.maxAge = maxAge;
        this.shape = shape;
    }

    public static void register() {
        for (PrehistoricPlantInfo info : PrehistoricPlantInfo.values()) {
            if (info == CRATAEGUS) {
                info.plantBlock = ModBlocks.registerBlock(info.resourceName, () -> new CrataegusBushBlock(info));
                info.berryItem = ModItems.ITEMS.register("berry_" + info.resourceName, () -> new class_1792(new class_1792.class_1793().method_7892(ModTabs.FA_MOB_ITEM_TAB).method_19265(class_4176.field_18636)));
                info.registerPlantSeed(info.resourceName);
                continue;
            }
            if (info == EPHEDRA) {
                info.plantBlock = ModBlocks.registerBlock(info.resourceName, () -> new EphedraBushBlock(info.shape, info));
                info.berryItem = ModItems.ITEMS.register("berry_" + info.resourceName, () -> new class_1792(new class_1792.class_1793().method_7892(ModTabs.FA_MOB_ITEM_TAB).method_19265(class_4176.field_18636)));
                info.registerPlantSeed(info.resourceName);
                continue;
            }
            if (info == VACCINIUM) {
                info.plantBlock = ModBlocks.registerBlock(info.resourceName, () -> new VacciniumBushBlock(info.shape, info));
                info.berryItem = ModItems.ITEMS.register("berry_" + info.resourceName, () -> new class_1792(new class_1792.class_1793().method_7892(ModTabs.FA_MOB_ITEM_TAB).method_19265(class_4176.field_18636)));
                info.registerPlantSeed(info.resourceName);
                continue;
            }
            if (info.size == Size.SINGLE) {
                info.plantBlock = ModBlocks.registerShortFlower(info.resourceName, info.shape);
                info.registerPlantSeed(info.resourceName);
                continue;
            }
            if (info.size == Size.DOUBLE) {
                info.plantBlock = ModBlocks.registerTallFlower(info.resourceName, info.shape);
                if (info == MUTANT_PLANT) continue;
                info.registerPlantSeed(info.resourceName);
                continue;
            }
            if (info.size == Size.SINGLE_GROWABLE) {
                info.plantBlock = ModBlocks.registerGrowableFlower(info.resourceName, info.tallPlant.plantBlock, info.shape);
                info.registerPlantSeed(info.commonName);
                continue;
            }
            if (info.size == Size.DOUBLE_GROWABLE || info == MUTANT_PLANT) {
                info.plantBlock = ModBlocks.registerTallFlower(info.resourceName, info.shape);
                continue;
            }
            if (info.size != Size.FOUR) continue;
            info.plantBlock = ModBlocks.registerFourTallFlower(info.resourceName, info.shape);
            info.registerPlantSeed(info.resourceName);
        }
    }

    public static List<PrehistoricPlantInfo> plantsWithSeeds() {
        if (seedsCache == null) {
            seedsCache = Arrays.stream(PrehistoricPlantInfo.values()).filter(type -> type.plantSeedItem != null).toList();
        }
        return seedsCache;
    }

    private void registerPlantSeed(String name) {
        this.fossilizedPlantSeedItem = ModItems.ITEMS.register("fossil_seed_" + name, () -> new class_1792(new class_1792.class_1793().method_7892(ModTabs.FA_MOB_ITEM_TAB)));
        this.plantSeedItem = ModItems.ITEMS.register("seed_" + name, () -> new FlowerSeedsItem(new class_1792.class_1793().method_7892(ModTabs.FA_MOB_ITEM_TAB), this.plantBlock));
    }

    public class_2261 getPlantBlock() {
        return (class_2261)this.plantBlock.get();
    }

    public class_1792 getFossilizedPlantSeedItem() {
        return (class_1792)this.fossilizedPlantSeedItem.get();
    }

    public FlowerSeedsItem getPlantSeedItem() {
        return (FlowerSeedsItem)((Object)this.plantSeedItem.get());
    }

    public int berryAge() {
        return this.berryAge;
    }

    public int maxAge() {
        return this.maxAge;
    }

    public RegistrySupplier<class_1792> berryItem() {
        return this.berryItem;
    }

    static enum Size {
        SINGLE,
        DOUBLE,
        SINGLE_GROWABLE,
        DOUBLE_GROWABLE,
        FOUR,
        SINGLE_BERRY,
        DOUBLE_BERRY;

    }
}

