/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.client;

import com.github.teamfossilsarcheology.fossil.FossilMod;
import com.github.teamfossilsarcheology.fossil.client.ResourceLoader;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import org.jetbrains.annotations.NotNull;

public class OptionalTextureLoader
extends ResourceLoader<Pair<Set<String>, Set<String>>> {
    public static final OptionalTextureLoader INSTANCE = new OptionalTextureLoader();
    private final Set<String> babyTextures = new HashSet<String>();
    private final Set<String> teenTextures = new HashSet<String>();

    public OptionalTextureLoader() {
        super(class_3264.field_14188, "textures/entity", ".png");
    }

    @NotNull
    protected Pair<Set<String>, Set<String>> prepare(class_3300 resourceManager, class_3695 profiler) {
        ImmutableSet.Builder babySetBuilder = ImmutableSet.builder();
        ImmutableSet.Builder teenSetBuilder = ImmutableSet.builder();
        for (class_2960 resourceLocation : this.listResources(resourceManager)) {
            String path = resourceLocation.method_12832();
            String entityName = path.split("/")[2];
            if (path.contains("baby")) {
                babySetBuilder.add((Object)entityName);
                continue;
            }
            if (!path.contains("teen")) continue;
            teenSetBuilder.add((Object)entityName);
        }
        return Pair.of((Object)babySetBuilder.build(), (Object)teenSetBuilder.build());
    }

    protected void apply(Pair<Set<String>, Set<String>> object, class_3300 resourceManager, class_3695 profiler) {
        this.babyTextures.clear();
        this.babyTextures.addAll((Collection)object.getFirst());
        FossilMod.LOGGER.info("Loaded {} optional baby textures", (Object)this.babyTextures.size());
        this.teenTextures.clear();
        this.teenTextures.addAll((Collection)object.getSecond());
        FossilMod.LOGGER.info("Loaded {} optional teen textures", (Object)this.teenTextures.size());
    }

    public boolean hasBabyTexture(String entityName) {
        return this.babyTextures.contains(entityName);
    }

    public boolean hasTeenTexture(String entityName) {
        return this.teenTextures.contains(entityName);
    }
}

