/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.client.gui.debug;

import com.github.teamfossilsarcheology.fossil.client.gui.debug.DebugSelectionList;
import com.github.teamfossilsarcheology.fossil.entity.animation.AnimationInfo;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_350;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4265;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_6379;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AbstractAnimationList
extends DebugSelectionList<AnimationEntry> {
    private final Consumer<AnimationObject> consumer;
    protected String currentControllerName;
    protected double speed = 1.0;
    protected double transitionLength = 5.0;
    protected boolean loop;

    public AbstractAnimationList(int x0, int height, int itemHeight, int yOffset, Map<String, ? extends AnimationInfo> animations, class_310 minecraft, Consumer<AnimationObject> function) {
        super(minecraft, 100, 215, height, yOffset, height + 60, itemHeight);
        this.field_19088 = x0;
        this.field_19087 = x0 + this.field_22742;
        List<String> sortedAnimations = animations.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(Map.Entry::getKey).toList();
        sortedAnimations.forEach(animation -> this.method_25321((class_350.class_351)new AnimationEntry((String)animation)));
        this.method_31322(false);
        this.method_31323(false);
        this.consumer = function;
    }

    @Nullable
    protected AnimationEntry getEntryAtPosition(double mouseX, double mouseY) {
        int x1 = this.getEntryLeftPos() + this.method_25322();
        int m = class_3532.method_15357((double)(mouseY - (double)this.field_19085)) - this.field_22748 + (int)this.method_25341() - 4;
        int n = m / this.field_22741;
        if (mouseX < (double)this.method_25329() && mouseX >= (double)this.field_19088 && mouseX <= (double)x1 && n >= 0 && m >= 0 && n < this.method_25340()) {
            return (AnimationEntry)((Object)this.method_25396().get(n));
        }
        return null;
    }

    protected int getEntryLeftPos() {
        return this.field_19088;
    }

    protected int method_25329() {
        return this.field_19088 + this.rowWidth + 6;
    }

    protected class AnimationEntry
    extends class_4265.class_4266<AnimationEntry> {
        private final class_4185 changeButton;

        AnimationEntry(String animation) {
            String[] split = animation.split("\\.");
            class_5250 display = class_2561.method_43470((String)(split.length > 0 ? StringUtils.capitalize((String)split[split.length - 1]) : ""));
            this.changeButton = new class_4185(0, 0, 100, 20, (class_2561)display, button -> AbstractAnimationList.this.consumer.accept(new AnimationObject(animation, AbstractAnimationList.this.currentControllerName, AbstractAnimationList.this.speed, AbstractAnimationList.this.transitionLength, AbstractAnimationList.this.loop)));
        }

        @NotNull
        public List<? extends class_6379> method_37025() {
            return ImmutableList.of((Object)this.changeButton);
        }

        public void method_25343(class_4587 poseStack, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTick) {
            this.changeButton.field_22760 = AbstractAnimationList.this.getEntryLeftPos();
            this.changeButton.field_22761 = top;
            this.changeButton.method_25394(poseStack, mouseX, mouseY, partialTick);
        }

        @NotNull
        public List<? extends class_364> method_25396() {
            return ImmutableList.of((Object)this.changeButton);
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            return this.changeButton.method_25402(mouseX, mouseY, button);
        }

        public boolean method_25406(double mouseX, double mouseY, int button) {
            return this.changeButton.method_25406(mouseX, mouseY, button);
        }
    }

    public record AnimationObject(String name, String controller, double speed, double transitionLength, boolean loop) {
    }
}

