/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.client.gui.debug;

import com.github.teamfossilsarcheology.fossil.client.gui.debug.AbstractAnimationList;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.DebugScreen;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.DebugSlider;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.DebugTab;
import com.github.teamfossilsarcheology.fossil.entity.animation.AnimationInfo;
import com.github.teamfossilsarcheology.fossil.entity.animation.PausableAnimationController;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricAnimatable;
import com.github.teamfossilsarcheology.fossil.network.MessageHandler;
import com.github.teamfossilsarcheology.fossil.network.debug.C2SForceAnimationMessage;
import com.github.teamfossilsarcheology.fossil.network.debug.C2SRotationMessage;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_1308;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_4185;
import net.minecraft.class_4587;
import net.minecraft.class_5676;
import net.minecraft.class_7172;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.controller.AnimationController;

public class AnimationTab<T extends class_1308>
extends DebugTab<T> {
    private float rotYBase;
    private float rotXBase;

    protected AnimationTab(DebugScreen debugScreen, @NotNull T mob) {
        super(debugScreen, mob);
        this.rotYBase = ((class_1308)mob).field_6283;
        this.rotXBase = mob.method_36455();
    }

    @Override
    protected void init(int width, int height) {
        super.init(width, height);
        int yLeft = 0;
        boolean yRight = false;
        DebugSlider sliderY = this.addWidget(new DebugSlider(20, 30 + yLeft++ * 30, width / 4, 20, (class_2561)class_2561.method_43470((String)"Rotation Y: "), (class_2561)class_2561.method_43470((String)""), 0.0, 360.0, 0.0, 5.0, 3, true){

            @Override
            protected void method_25344() {
                float rotY = (float)(this.stepSize * (double)Math.round(class_3532.method_16436((double)this.field_22753, (double)this.minValue, (double)this.maxValue) / this.stepSize));
                float newRot = (AnimationTab.this.rotYBase + rotY) % 360.0f;
                MessageHandler.DEBUG_CHANNEL.sendToServer((Object)new C2SRotationMessage(((class_1308)AnimationTab.this.entity).method_5628(), newRot, 0));
                ((class_1308)AnimationTab.this.entity).method_5636(newRot);
                ((class_1308)AnimationTab.this.entity).method_36456(newRot);
                ((class_1308)AnimationTab.this.entity).method_5847(newRot);
            }
        });
        DebugSlider sliderX = this.addWidget(new DebugSlider(20, 30 + yLeft++ * 30, width / 4, 20, (class_2561)class_2561.method_43470((String)"Rotation X: "), (class_2561)class_2561.method_43470((String)""), 0.0, 360.0, 0.0, 5.0, 3, true){

            @Override
            protected void method_25344() {
                float rotX = (float)(this.stepSize * (double)Math.round(class_3532.method_16436((double)this.field_22753, (double)this.minValue, (double)this.maxValue) / this.stepSize));
                float newRot = (AnimationTab.this.rotXBase + rotX) % 360.0f;
                MessageHandler.DEBUG_CHANNEL.sendToServer((Object)new C2SRotationMessage(((class_1308)AnimationTab.this.entity).method_5628(), newRot, 1));
                ((class_1308)AnimationTab.this.entity).method_36457(newRot);
            }
        });
        this.addWidget(new class_4185(20, 30 + yLeft++ * 30, width / 6, 20, (class_2561)class_2561.method_43470((String)"Reset Rotation"), button -> {
            this.rotYBase = 0.0f;
            this.rotXBase = 0.0f;
            sliderY.setSliderValue(0.0, true);
            sliderX.setSliderValue(0.0, true);
        }, (button, poseStack, i, j) -> this.debugScreen.method_25424(poseStack, (class_2561)class_2561.method_43470((String)"client side only"), i, j)));
        Map controllers = ((IAnimatable)((class_1308)this.entity)).getFactory().getOrCreateAnimationData(((class_1308)this.entity).method_5628()).getAnimationControllers();
        this.addWidget(new AnimationList(width - width / 4 + 20, ((PrehistoricAnimatable)((class_1308)this.entity)).getAllAnimations(), controllers, this.minecraft, animationObject -> MessageHandler.DEBUG_CHANNEL.sendToServer((Object)new C2SForceAnimationMessage(animationObject.controller(), ((class_1308)this.entity).method_5628(), animationObject.name(), animationObject.speed(), animationObject.transitionLength(), animationObject.loop()))));
    }

    @Override
    public void render(class_4587 poseStack, int mouseX, int mouseY, float partialTick) {
        super.render(poseStack, mouseX, mouseY, partialTick);
        AnimationTab.method_27535((class_4587)poseStack, (class_327)this.minecraft.field_1772, (class_2561)class_2561.method_43470((String)("Rotation: " + ((class_1308)this.entity).method_36454())), (int)20, (int)160, (int)0xFFFFFF);
        AnimationTab.method_27535((class_4587)poseStack, (class_327)this.minecraft.field_1772, (class_2561)class_2561.method_43470((String)("Rotation Body: " + ((class_1308)this.entity).field_6283)), (int)20, (int)180, (int)0xFFFFFF);
        AnimationTab.method_27535((class_4587)poseStack, (class_327)this.minecraft.field_1772, (class_2561)class_2561.method_43470((String)("Rotation Head: " + ((class_1308)this.entity).method_5791())), (int)20, (int)200, (int)0xFFFFFF);
    }

    private static class AnimationList
    extends AbstractAnimationList {
        private final Map<String, class_339> pauseButtons = new HashMap<String, class_339>();
        private final Map<String, DebugSlider> pauseSliders = new HashMap<String, DebugSlider>();

        public AnimationList(int x0, Map<String, ? extends AnimationInfo> animations, Map<String, AnimationController> controllers, class_310 minecraft, Consumer<AbstractAnimationList.AnimationObject> function) {
            super(x0, 250, 21, 120, animations, minecraft, function);
            int buttonX = x0;
            int buttonY = this.field_19085 - 110;
            if (controllers.isEmpty()) {
                return;
            }
            List controllerNames = controllers.keySet().stream().toList();
            this.currentControllerName = (String)controllerNames.get(0);
            this.addWidget(class_5676.method_32606(class_2561::method_43470).method_32620(controllerNames).method_32619((Object)this.currentControllerName).method_32617(buttonX, buttonY, 200, 20, (class_2561)class_2561.method_43470((String)"Controller"), (button, controller) -> {
                this.removeWidget(this.pauseButtons.get(this.currentControllerName));
                this.removeWidget(this.pauseSliders.get(this.currentControllerName));
                this.addWidget(this.pauseButtons.get(controller));
                this.addWidget(this.pauseSliders.get(controller));
                this.currentControllerName = controller;
            }));
            this.addWidget(new DebugSlider(buttonX, buttonY + 21, 99, 20, (class_2561)class_2561.method_43470((String)"Transition: "), (class_2561)class_2561.method_43470((String)""), 0.0, 20.0, this.transitionLength, 1.0, 3, true){

                @Override
                protected void method_25344() {
                    transitionLength = (float)(this.stepSize * (double)Math.round(class_3532.method_16436((double)this.field_22753, (double)this.minValue, (double)this.maxValue) / this.stepSize));
                }
            });
            this.addWidget(new DebugSlider(buttonX + 102, buttonY + 21, 99, 20, (class_2561)class_2561.method_43470((String)"Speed: "), (class_2561)class_2561.method_43470((String)""), 0.0, 3.0, this.speed, 0.05, 3, true){

                @Override
                protected void method_25344() {
                    speed = (float)(this.stepSize * (double)Math.round(class_3532.method_16436((double)this.field_22753, (double)this.minValue, (double)this.maxValue) / this.stepSize));
                }
            });
            this.addWidget(class_7172.method_41751((String)"Loop", (boolean)this.loop, newLoop -> {
                this.loop = newLoop;
            }).method_18520(class_310.method_1551().field_1690, buttonX, buttonY + 42, 99));
            for (String controllerName : controllerNames) {
                AnimationController animationController = controllers.get(controllerName);
                if (!(animationController instanceof PausableAnimationController)) continue;
                PausableAnimationController pausableAnimationController = (PausableAnimationController)animationController;
                DebugSlider slider = AnimationList.createPauseSlider(pausableAnimationController, buttonX, buttonY);
                class_5676 button2 = class_5676.method_32613((boolean)pausableAnimationController.isPaused()).method_32617(buttonX + 102, buttonY + 42, 99, 20, (class_2561)class_2561.method_43470((String)"Pause"), (cycleButton, paused) -> {
                    pausableAnimationController.pause((boolean)paused);
                    slider.field_22764 = paused;
                    if (pausableAnimationController.getCurrentAnimation() != null) {
                        slider.maxValue = pausableAnimationController.getCurrentAnimation().animationLength;
                    }
                    if (Boolean.TRUE.equals(paused)) {
                        slider.setSliderValue(pausableAnimationController.getCurrentTick() / slider.maxValue, true);
                    }
                });
                this.pauseSliders.put(controllerName, slider);
                this.pauseButtons.put(controllerName, (class_339)button2);
                if (!controllerName.equals(this.currentControllerName)) continue;
                this.addWidget(button2);
                this.addWidget(slider);
            }
        }

        @NotNull
        private static DebugSlider createPauseSlider(final PausableAnimationController<?> pausableAnimationController, int buttonX, int buttonY) {
            double tick;
            double maxTick = tick = pausableAnimationController.getCurrentTick();
            if (pausableAnimationController.getCurrentAnimation() != null) {
                maxTick = pausableAnimationController.getCurrentAnimation().animationLength - 1.0;
            }
            var slider = new DebugSlider(buttonX, buttonY + 63, 200, 20, (class_2561)class_2561.method_43470((String)"Time: "), (class_2561)class_2561.method_43470((String)""), 0.0, maxTick, tick, 1.0, 3, true){

                @Override
                protected void method_25344() {
                    pausableAnimationController.overrideTick(this.stepSize * (double)Math.round(class_3532.method_16436((double)this.field_22753, (double)this.minValue, (double)this.maxValue) / this.stepSize));
                }
            };
            slider.field_22764 = pausableAnimationController.isPaused();
            return slider;
        }

        @Override
        protected int getEntryLeftPos() {
            return super.getEntryLeftPos() + this.field_22742 / 2;
        }

        @Override
        protected int method_25329() {
            return super.method_25329() + this.field_22742 / 2 - 4;
        }
    }
}

