/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.client.renderer.entity;

import com.github.teamfossilsarcheology.fossil.client.model.SkeletonModel;
import com.github.teamfossilsarcheology.fossil.entity.PrehistoricSkeleton;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4581;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4720;
import net.minecraft.class_5617;
import net.minecraft.class_897;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib3.core.util.Color;
import software.bernie.geckolib3.geo.render.built.GeoBone;
import software.bernie.geckolib3.geo.render.built.GeoCube;
import software.bernie.geckolib3.geo.render.built.GeoModel;
import software.bernie.geckolib3.model.provider.GeoModelProvider;
import software.bernie.geckolib3.renderers.geo.IGeoRenderer;
import software.bernie.geckolib3.util.EModelRenderCycle;
import software.bernie.geckolib3.util.IRenderCycle;
import software.bernie.geckolib3.util.RenderUtils;

public class SkeletonRenderer
extends class_897<PrehistoricSkeleton>
implements IGeoRenderer<PrehistoricSkeleton> {
    private final GeoModelProvider<PrehistoricSkeleton> geoModel;
    private IRenderCycle currentModelRenderCycle = EModelRenderCycle.INITIAL;
    private PrehistoricSkeleton animatable;
    protected class_1159 dispatchedMat = new class_1159();
    protected class_1159 renderEarlyMat = new class_1159();
    private class_4597 rtb;

    public SkeletonRenderer(class_5617.class_5618 context) {
        super(context);
        this.geoModel = new SkeletonModel();
    }

    public void renderEarly(PrehistoricSkeleton animatable, class_4587 poseStack, float partialTick, class_4597 bufferSource, class_4588 buffer, int packedLight, int packedOverlayIn, float red, float green, float blue, float alpha) {
        this.animatable = animatable;
        this.renderEarlyMat = poseStack.method_23760().method_23761().method_22673();
        this.rtb = bufferSource;
        super.renderEarly((Object)animatable, poseStack, partialTick, bufferSource, buffer, packedLight, packedOverlayIn, red, green, blue, alpha);
    }

    public void render(GeoModel model, PrehistoricSkeleton animatable, float partialTick, class_1921 type, class_4587 poseStack, class_4597 bufferSource, class_4588 buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        super.render(model, (Object)animatable, partialTick, type, poseStack, bufferSource, buffer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void render(PrehistoricSkeleton animatable, float entityYaw, float partialTick, class_4587 poseStack, class_4597 bufferSource, int packedLight) {
        this.setCurrentModelRenderCycle((IRenderCycle)EModelRenderCycle.INITIAL);
        poseStack.method_22903();
        this.dispatchedMat = poseStack.method_23760().method_23761().method_22673();
        GeoModel model = this.geoModel.getModel(this.geoModel.getModelResource((Object)animatable));
        poseStack.method_22904(0.0, (double)0.01f, 0.0);
        RenderSystem.setShaderTexture((int)0, (class_2960)this.getTextureLocation(animatable));
        if (!animatable.method_5756((class_1657)class_310.method_1551().field_1724)) {
            poseStack.method_22907(class_1160.field_20705.method_23214(180.0f - animatable.method_36454()));
            Color renderColor = this.getRenderColor((Object)animatable, partialTick, poseStack, bufferSource, null, packedLight);
            class_1921 renderType = this.getRenderType(animatable, partialTick, poseStack, bufferSource, null, packedLight, this.getTextureLocation(animatable));
            class_4588 glintBuffer = bufferSource.getBuffer(class_1921.method_29707());
            class_4588 translucentBuffer = bufferSource.getBuffer(class_1921.method_23689((class_2960)this.getTextureLocation(animatable)));
            this.render(model, animatable, partialTick, renderType, poseStack, bufferSource, glintBuffer != translucentBuffer ? class_4720.method_24037((class_4588)glintBuffer, (class_4588)translucentBuffer) : null, packedLight, class_4608.method_23625((int)class_4608.method_23210((float)0.0f), (int)class_4608.method_23212((boolean)false)), (float)renderColor.getRed() / 255.0f, (float)renderColor.getGreen() / 255.0f, (float)renderColor.getBlue() / 255.0f, (float)renderColor.getAlpha() / 255.0f);
        }
        poseStack.method_22909();
        super.method_3936((class_1297)animatable, entityYaw, partialTick, poseStack, bufferSource, packedLight);
    }

    public void renderRecursively(GeoBone bone, class_4587 poseStack, class_4588 buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        boolean rotOverride;
        poseStack.method_22903();
        RenderUtils.translateMatrixToBone((class_4587)poseStack, (GeoBone)bone);
        RenderUtils.translateToPivotPoint((class_4587)poseStack, (GeoBone)bone);
        boolean bl = rotOverride = bone.rotMat != null;
        if (rotOverride) {
            poseStack.method_23760().method_23761().method_22672(bone.rotMat);
            poseStack.method_23760().method_23762().method_22855(new class_4581(bone.rotMat));
        } else {
            RenderUtils.rotateMatrixAroundBone((class_4587)poseStack, (GeoBone)bone);
        }
        RenderUtils.scaleMatrixForBone((class_4587)poseStack, (GeoBone)bone);
        if (bone.isTrackingXform()) {
            class_1159 poseState = poseStack.method_23760().method_23761().method_22673();
            class_1159 localMatrix = RenderUtils.invertAndMultiplyMatrices((class_1159)poseState, (class_1159)this.dispatchedMat);
            bone.setModelSpaceXform(RenderUtils.invertAndMultiplyMatrices((class_1159)poseState, (class_1159)this.renderEarlyMat));
            localMatrix.method_22671(new class_1160(this.method_23169(this.animatable, 1.0f)));
            bone.setLocalSpaceXform(localMatrix);
            class_1159 worldState = localMatrix.method_22673();
            worldState.method_22671(new class_1160(this.animatable.method_19538()));
            bone.setWorldSpaceXform(worldState);
        }
        RenderUtils.translateAwayFromPivotPoint((class_4587)poseStack, (GeoBone)bone);
        if (!bone.isHidden) {
            if (!bone.cubesAreHidden()) {
                for (GeoCube geoCube : bone.childCubes) {
                    poseStack.method_22903();
                    this.renderCube(geoCube, poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
                    poseStack.method_22909();
                }
            }
            for (GeoBone childBone : bone.childBones) {
                this.renderRecursively(childBone, poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
            }
        }
        poseStack.method_22909();
    }

    public class_1921 getRenderType(PrehistoricSkeleton animatable, float partialTick, class_4587 poseStack, class_4597 bufferSource, class_4588 buffer, int packedLight, class_2960 texture) {
        return class_1921.method_23578((class_2960)texture);
    }

    public int getInstanceId(PrehistoricSkeleton entity) {
        return entity.method_5628();
    }

    public float getWidthScale(PrehistoricSkeleton entity) {
        return entity.getScale();
    }

    public float getHeightScale(PrehistoricSkeleton entity) {
        return entity.getScale();
    }

    protected boolean shouldShowName(PrehistoricSkeleton entity) {
        return false;
    }

    public GeoModelProvider<PrehistoricSkeleton> getGeoModelProvider() {
        return this.geoModel;
    }

    @NotNull
    public class_2960 getTextureLocation(PrehistoricSkeleton entity) {
        return this.geoModel.getTextureResource((Object)entity);
    }

    public void setCurrentRTB(class_4597 bufferSource) {
        this.rtb = bufferSource;
    }

    public class_4597 getCurrentRTB() {
        return this.rtb;
    }

    @NotNull
    public IRenderCycle getCurrentModelRenderCycle() {
        return this.currentModelRenderCycle;
    }

    public void setCurrentModelRenderCycle(IRenderCycle currentModelRenderCycle) {
        this.currentModelRenderCycle = currentModelRenderCycle;
    }
}

