/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.ai;

import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.Prehistoric;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Optional;
import net.minecraft.class_11;
import net.minecraft.class_1352;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_4538;

public abstract class CacheMoveToBlockGoal
extends class_1352 {
    public static final int STUCK_DISTANCE = 2;
    protected static final int CLEAR_TICKS = 400;
    private static final int GIVE_UP_TICKS = 1200;
    private static final int STAY_TICKS = 1200;
    private static final int INTERVAL_TICKS = 160;
    public final double speedModifier;
    protected final Prehistoric entity;
    protected final int searchRange;
    protected final LongList avoidCache = new LongArrayList();
    private final int verticalSearchRange;
    protected int nextStartTick;
    protected int tryTicks;
    protected int clearTicks;
    protected int stuckTicks;
    protected class_2338 targetPos = class_2338.field_10980;
    protected class_2248 targetBlock = class_2246.field_10124;
    protected boolean reachedTarget;
    protected class_11 path;
    private class_2338 lastStuckPos;

    protected CacheMoveToBlockGoal(Prehistoric entity, double speedModifier, int searchRange) {
        this(entity, speedModifier, searchRange, 1);
    }

    protected CacheMoveToBlockGoal(Prehistoric entity, double speedModifier, int searchRange, int verticalSearchRange) {
        this.entity = entity;
        this.speedModifier = speedModifier;
        this.searchRange = searchRange;
        this.verticalSearchRange = verticalSearchRange;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18407));
    }

    public boolean method_6264() {
        if (this.clearTicks > 0) {
            --this.clearTicks;
            if (this.clearTicks == 0) {
                this.avoidCache.clear();
            }
        }
        if (this.nextStartTick > 0) {
            --this.nextStartTick;
            return false;
        }
        if (!this.findNearestBlock()) {
            this.nextStartTick = 40;
            return false;
        }
        return this.createPath();
    }

    protected int nextStartTick() {
        return CacheMoveToBlockGoal.method_38848((int)(160 + this.entity.method_6051().method_43048(160)));
    }

    public boolean method_6266() {
        return this.tryTicks >= -1200 && this.tryTicks < 1200 && this.isValidTarget((class_4538)this.entity.field_6002, this.targetPos);
    }

    public void method_6269() {
        this.moveMobToBlock();
        this.tryTicks = 0;
        this.stuckTicks = 0;
        this.lastStuckPos = null;
    }

    public void method_6270() {
        this.nextStartTick = this.nextStartTick();
    }

    protected boolean createPath() {
        this.path = this.entity.method_5942().method_35141(this.getMoveToTarget(), 1, 32);
        if (this.path == null || this.path.method_45() == null) {
            return false;
        }
        if (this.path.method_38() < 16 && (double)this.path.method_45().method_35494(this.getMoveToTarget()) > this.acceptedDistance()) {
            this.avoidCache.add(this.getMoveToTarget().method_10063());
            return false;
        }
        return true;
    }

    protected double calculateSpeedModifier() {
        return this.speedModifier;
    }

    protected void moveMobToBlock() {
        this.entity.method_5942().method_6334(this.path, this.calculateSpeedModifier());
    }

    public double acceptedDistance() {
        if (this.entity.getEntityHitboxData().hasCustomParts() && this.entity.getEntityHitboxData().getHeadRadius() != 0.0f) {
            return (double)(this.entity.getEntityHitboxData().getHeadRadius() * this.entity.method_17825()) + 0.7;
        }
        return (double)(this.entity.method_17681() / 2.0f) + 1.5;
    }

    protected class_2338 getMoveToTarget() {
        return this.targetPos;
    }

    public boolean method_38846() {
        return true;
    }

    protected int getStuckPatience() {
        return 150;
    }

    public void method_6268() {
        class_2338 blockPos = this.getMoveToTarget();
        if (this.checkReachedTarget()) {
            this.reachedTarget = true;
            this.entity.method_5942().method_6340();
            --this.tryTicks;
        } else if (this.stuckTicks > this.getStuckPatience()) {
            this.avoidCache.add(blockPos.method_10063());
            this.tryTicks = 1200;
        } else {
            this.reachedTarget = false;
            ++this.tryTicks;
            if (this.shouldRecalculatePath()) {
                if (!this.createPath()) {
                    return;
                }
                this.moveMobToBlock();
            }
        }
        if (!this.isReachedTarget() && this.entity.method_5942().method_6357() || this.entity.method_5942().method_31267()) {
            if (this.lastStuckPos != null && !this.lastStuckPos.method_19769((class_2374)this.entity.method_19538(), 2.0)) {
                this.stuckTicks = 0;
            }
            ++this.stuckTicks;
            this.lastStuckPos = this.entity.method_24515();
        }
    }

    public boolean shouldRecalculatePath() {
        return this.tryTicks % 40 == 0;
    }

    protected boolean checkReachedTarget() {
        double horizontal = class_243.method_24955((class_2382)this.targetPos).method_1020(this.entity.method_19538()).method_37268();
        double vertical = class_3532.method_33723((double)((double)this.targetPos.method_10264() - this.entity.method_23318()));
        return horizontal < class_3532.method_33723((double)this.acceptedDistance()) && vertical < class_3532.method_33723((double)((double)this.entity.method_17682() + 0.1));
    }

    protected boolean isReachedTarget() {
        return this.reachedTarget;
    }

    protected boolean findNearestBlock() {
        class_2338 pos = this.entity.method_24515();
        class_238 searchArea = new class_238((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260()).method_1009((double)this.searchRange, (double)this.verticalSearchRange, (double)this.searchRange);
        Optional<class_2338> target = class_2338.method_29715((class_238)searchArea).map(class_2338::method_10062).filter(pos1 -> this.isValidTarget((class_4538)this.entity.field_6002, (class_2338)pos1)).min(Comparator.comparingInt(value -> value.method_19455((class_2382)pos)));
        if (target.isPresent()) {
            this.setTargetPos(target.get());
            return true;
        }
        this.clearTicks = !this.avoidCache.isEmpty() ? 400 : 0;
        return false;
    }

    protected boolean isValidTarget(class_4538 level, class_2338 pos) {
        return !this.avoidCache.contains(pos.method_10063());
    }

    protected void setTargetPos(class_2338 targetPos) {
        this.targetPos = targetPos;
        this.targetBlock = this.entity.field_6002.method_8320(targetPos).method_26204();
    }
}

