/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.animation;

import com.github.teamfossilsarcheology.fossil.FossilMod;
import com.github.teamfossilsarcheology.fossil.entity.animation.AnimationCategoryLoader;
import com.github.teamfossilsarcheology.fossil.entity.animation.AnimationInfoLoader;
import com.github.teamfossilsarcheology.fossil.entity.animation.BakedAnimationInfo;
import com.github.teamfossilsarcheology.fossil.entity.animation.ServerAnimationInfo;
import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.lang.reflect.Type;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import software.bernie.geckolib3.core.builder.Animation;
import software.bernie.geckolib3.core.builder.ILoopType;

public class ServerAnimationInfoLoader
extends AnimationInfoLoader<ServerAnimationInfo> {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(BakedAnimationInfo.class, (Object)new Deserializer()).create();
    private static final Type TYPE = new TypeToken<BakedAnimationInfo<ServerAnimationInfo>>(){}.getType();
    private static final BakedAnimationInfo<ServerAnimationInfo> EMPTY = new BakedAnimationInfo(Object2ObjectMaps.emptyMap());
    public static final ServerAnimationInfoLoader INSTANCE = new ServerAnimationInfoLoader(GSON);
    private Map<class_2960, BakedAnimationInfo<ServerAnimationInfo>> serverAnimationInfos = ImmutableMap.of();

    protected ServerAnimationInfoLoader(Gson gson) {
        super(gson, "animations");
    }

    protected void apply(Map<class_2960, JsonElement> jsons, class_3300 resourceManager, class_3695 profiler) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<class_2960, JsonElement> fileEntry : jsons.entrySet()) {
            JsonElement jsonElement = fileEntry.getValue();
            if (!(jsonElement instanceof JsonObject)) continue;
            JsonObject root = (JsonObject)jsonElement;
            if (!fileEntry.getKey().method_12836().equals("fossil")) continue;
            class_2960 path = FossilMod.location("animations/" + fileEntry.getKey().method_12832() + ".json");
            builder.put((Object)path, (Object)((BakedAnimationInfo)GSON.fromJson((JsonElement)class_3518.method_15296((JsonObject)root, (String)"animations"), TYPE)));
        }
        this.serverAnimationInfos = builder.build();
        FossilMod.LOGGER.info("Loaded {} server animations for {} entities", (Object)this.serverAnimationInfos.values().stream().map(info -> info.animations().size()).reduce(Integer::sum).orElse(0), (Object)this.serverAnimationInfos.size());
        AnimationCategoryLoader.SERVER.apply(this.serverAnimationInfos);
    }

    @Override
    public Map<class_2960, BakedAnimationInfo<ServerAnimationInfo>> getAnimationInfos() {
        return this.serverAnimationInfos;
    }

    @Override
    public BakedAnimationInfo<ServerAnimationInfo> getAnimations(class_2960 animationFile) {
        return this.serverAnimationInfos.getOrDefault(animationFile, EMPTY);
    }

    public static class Deserializer
    implements JsonDeserializer<BakedAnimationInfo<ServerAnimationInfo>> {
        public BakedAnimationInfo<ServerAnimationInfo> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject root = json.getAsJsonObject();
            Object2ObjectOpenHashMap animations = new Object2ObjectOpenHashMap(root.size());
            for (Map.Entry entry : root.entrySet()) {
                JsonObject animationObj = ((JsonElement)entry.getValue()).getAsJsonObject();
                double animationLength = animationObj.has("animation_length") ? class_3518.method_34927((JsonObject)animationObj, (String)"animation_length") * 20.0 : -1.0;
                double actionDelay = animationObj.has("action_delay") ? animationObj.get("action_delay").getAsDouble() * 20.0 : 0.0;
                boolean usesAttackBox = animationObj.has("uses_attack_box") && class_3518.method_15270((JsonObject)animationObj, (String)"uses_attack_box");
                ILoopType loopType = ILoopType.fromJson((JsonElement)animationObj.get("loop"));
                Animation animation = new Animation();
                animation.animationName = (String)entry.getKey();
                animation.animationLength = animationLength;
                animation.loop = loopType;
                animations.put((String)entry.getKey(), new ServerAnimationInfo(animation, actionDelay, usesAttackBox));
            }
            return new BakedAnimationInfo<ServerAnimationInfo>((Map<String, ServerAnimationInfo>)animations);
        }
    }
}

