/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.prehistoric;

import com.github.teamfossilsarcheology.fossil.entity.ai.FleeBattleGoal;
import com.github.teamfossilsarcheology.fossil.entity.animation.AnimationCategory;
import com.github.teamfossilsarcheology.fossil.entity.animation.AnimationLogic;
import com.github.teamfossilsarcheology.fossil.entity.animation.PausableAnimationController;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.Prehistoric;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricEntityInfo;
import com.github.teamfossilsarcheology.fossil.sounds.ModSounds;
import com.github.teamfossilsarcheology.fossil.util.Gender;
import java.util.EnumSet;
import java.util.Optional;
import net.minecraft.class_1282;
import net.minecraft.class_1299;
import net.minecraft.class_1352;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;

public class Parasaurolophus
extends Prehistoric {
    private static final class_2940<Boolean> STANDING = class_2945.method_12791(Parasaurolophus.class, (class_2941)class_2943.field_13323);
    private final ParaAnimationLogic animationLogic = new ParaAnimationLogic(this);
    private static final String STAND = "animation.parasaurolophus.stand";
    private static final String STAND_UP = "animation.parasaurolophus.stand_up";

    public Parasaurolophus(class_1299<Parasaurolophus> entityType, class_1937 level) {
        super(entityType, level);
    }

    @Override
    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(3, (class_1352)new FleeBattleGoal(this, 1.0));
        this.field_6201.method_6277(19, (class_1352)new ParaStandGoal());
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(STANDING, (Object)false);
    }

    @Override
    public void method_5674(class_2940<?> key) {
        if (!this.field_6002.field_9236 && (SLEEPING.equals(key) || SITTING.equals(key))) {
            this.setStanding(false);
        }
        super.method_5674(key);
    }

    @Override
    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10556("Standing", this.isStanding());
    }

    @Override
    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.setStanding(compound.method_10577("Standing"));
    }

    @Override
    public PrehistoricEntityInfo info() {
        return PrehistoricEntityInfo.PARASAUROLOPHUS;
    }

    @Override
    public class_1792 getOrderItem() {
        return class_1802.field_8600;
    }

    @Override
    public double method_5621() {
        return super.method_5621() + 0.4;
    }

    public boolean isStanding() {
        return (Boolean)this.field_6011.method_12789(STANDING);
    }

    public void setStanding(boolean standing) {
        this.field_6011.method_12778(STANDING, (Object)standing);
    }

    @Override
    public float getGenderedScale() {
        return this.getGender() == Gender.MALE ? 1.15f : super.getGenderedScale();
    }

    @Nullable
    protected class_3414 method_5994() {
        return (class_3414)ModSounds.PARASAUROLOPHUS_AMBIENT.get();
    }

    @Nullable
    protected class_3414 method_6011(class_1282 damageSource) {
        return (class_3414)ModSounds.PARASAUROLOPHUS_HURT.get();
    }

    @Nullable
    protected class_3414 method_6002() {
        return (class_3414)ModSounds.PARASAUROLOPHUS_DEATH.get();
    }

    @Override
    public void registerControllers(AnimationData data) {
        PausableAnimationController<Parasaurolophus> controller = new PausableAnimationController<Parasaurolophus>(this, "Movement/Idle", 5.0f, this.animationLogic::paraPredicate);
        this.registerEatingListeners(controller);
        data.addAnimationController(controller);
        data.addAnimationController(new PausableAnimationController<Parasaurolophus>(this, "Attack", 0.0f, this.getAnimationLogic()::attackPredicate));
    }

    @Override
    public AnimationLogic<Prehistoric> getAnimationLogic() {
        return this.animationLogic;
    }

    static class ParaAnimationLogic
    extends AnimationLogic<Prehistoric> {
        public ParaAnimationLogic(Parasaurolophus entity) {
            super(entity);
        }

        public PlayState paraPredicate(AnimationEvent<Parasaurolophus> event) {
            if (this.isBlocked()) {
                return PlayState.STOP;
            }
            AnimationController controller = event.getController();
            if (this.tryNextAnimation(controller)) {
                return PlayState.CONTINUE;
            }
            Optional<AnimationLogic.ActiveAnimationInfo> activeAnimation = this.getActiveAnimation(controller.getName());
            if (activeAnimation.isPresent() && this.tryForcedAnimation(event, activeAnimation.get())) {
                return PlayState.CONTINUE;
            }
            if (((Parasaurolophus)event.getAnimatable()).isStanding()) {
                controller.setAnimation(new AnimationBuilder().playOnce(Parasaurolophus.STAND_UP).loop(Parasaurolophus.STAND));
                return PlayState.CONTINUE;
            }
            double animationSpeed = 1.0;
            if (((Prehistoric)this.entity).method_6113()) {
                this.addActiveAnimation(controller.getName(), AnimationCategory.SLEEP);
            } else if (((Parasaurolophus)event.getAnimatable()).sitSystem.isSitting()) {
                this.addActiveAnimation(controller.getName(), AnimationCategory.SIT);
            } else if (((Prehistoric)this.entity).method_5799()) {
                this.addActiveAnimation(controller.getName(), AnimationCategory.SWIM, true);
            } else if (event.isMoving()) {
                animationSpeed = this.addMovementAnimation(event, true);
            } else {
                this.addActiveAnimation(controller.getName(), AnimationCategory.IDLE);
            }
            ParaAnimationLogic.setAnimationSpeed(controller, animationSpeed, event.getAnimationTick());
            Optional<AnimationLogic.ActiveAnimationInfo> newAnimation = this.getActiveAnimation(controller.getName());
            if (newAnimation.isPresent()) {
                controller.transitionLengthTicks = newAnimation.get().transitionLength();
                controller.setAnimation(new AnimationBuilder().addAnimation(newAnimation.get().animationName(), (ILoopType)(newAnimation.get().loop() ? ILoopType.EDefaultLoopTypes.LOOP : ILoopType.EDefaultLoopTypes.PLAY_ONCE)));
            }
            return PlayState.CONTINUE;
        }
    }

    class ParaStandGoal
    extends class_1352 {
        private int cooldown;

        public ParaStandGoal() {
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        public boolean method_6264() {
            if (this.cooldown > Parasaurolophus.this.field_6012 || Parasaurolophus.this.method_5799() || Parasaurolophus.this.method_6062()) {
                return false;
            }
            return Parasaurolophus.this.field_5974.method_43048(100) == 0;
        }

        public boolean method_6266() {
            return !Parasaurolophus.this.method_5782() && !Parasaurolophus.this.method_5799() && !Parasaurolophus.this.method_6062() && Parasaurolophus.this.field_5974.method_43048(ParaStandGoal.method_38848((int)2000)) != 0;
        }

        public void method_6269() {
            this.cooldown = 0;
            Parasaurolophus.this.setStanding(true);
        }

        public void method_6270() {
            this.cooldown = Parasaurolophus.this.field_6012 + (Parasaurolophus.this.field_5974.method_43048(120) + 10) * 20;
            Parasaurolophus.this.setStanding(false);
        }
    }
}

