/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.prehistoric.base;

import com.github.teamfossilsarcheology.fossil.FossilMod;
import com.github.teamfossilsarcheology.fossil.entity.animation.AnimationCategory;
import com.github.teamfossilsarcheology.fossil.entity.animation.AnimationCategoryLoader;
import com.github.teamfossilsarcheology.fossil.entity.animation.AnimationHolder;
import com.github.teamfossilsarcheology.fossil.entity.animation.AnimationInfo;
import com.github.teamfossilsarcheology.fossil.entity.animation.AnimationLogic;
import com.github.teamfossilsarcheology.fossil.entity.animation.ClientAnimationInfoLoader;
import com.github.teamfossilsarcheology.fossil.entity.animation.PausableAnimationController;
import com.github.teamfossilsarcheology.fossil.entity.animation.ServerAnimationInfo;
import com.github.teamfossilsarcheology.fossil.entity.animation.ServerAnimationInfoLoader;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.Prehistoric;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricAnimatable;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricDebug;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricEntityInfo;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1266;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1313;
import net.minecraft.class_1315;
import net.minecraft.class_1332;
import net.minecraft.class_1422;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3486;
import net.minecraft.class_3730;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5757;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public abstract class PrehistoricFish
extends class_1422
implements PrehistoricAnimatable<PrehistoricFish>,
PrehistoricDebug {
    public static final class_2940<class_2487> DEBUG = class_2945.method_12791(PrehistoricFish.class, (class_2941)class_2943.field_13318);
    private static final class_2940<Boolean> BABY = class_2945.method_12791(PrehistoricFish.class, (class_2941)class_2943.field_13323);
    private final AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    private final class_2960 animationLocation;
    private final AnimationLogic<PrehistoricFish> animationLogic = new AnimationLogic<PrehistoricFish>(this);
    private int absoluteEggCooldown = this.field_5974.method_43048(12000) + 12000;
    private int age;

    protected PrehistoricFish(class_1299<? extends PrehistoricFish> entityType, class_1937 level) {
        super(entityType, level);
        this.animationLocation = FossilMod.location("animations/" + class_1299.method_5890(entityType).method_12832() + ".animation.json");
        this.field_6207 = new class_5757((class_1308)this, 85, 10, 0.2f, 0.1f, true);
        this.field_6206 = new class_1332((class_1308)this, 10);
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 20.0).method_26868(class_5134.field_23719, 0.25);
    }

    public static boolean canSpawn(class_1299<? extends PrehistoricFish> entityType, class_1936 level, class_3730 spawnType, class_2338 pos, class_5819 rand) {
        return pos.method_10264() < level.method_8615() && level.method_8316(pos.method_10074()).method_15767(class_3486.field_15517) && level.method_8320(pos.method_10084()).method_27852(class_2246.field_10382);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(BABY, (Object)false);
        class_2487 tag = new class_2487();
        tag.method_10556("disableGoalAI", false);
        tag.method_10556("disableMoveAI", false);
        tag.method_10556("disableLookAI", false);
        this.field_6011.method_12784(DEBUG, (Object)tag);
    }

    @NotNull
    public abstract PrehistoricEntityInfo info();

    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10569("AbsoluteEggCooldown", this.absoluteEggCooldown);
        compound.method_10569("Age", this.age);
    }

    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.absoluteEggCooldown = compound.method_10550("AbsoluteEggCooldown");
        this.setAge(compound.method_10550("Age"));
    }

    @NotNull
    public class_1799 method_6452() {
        return new class_1799((class_1935)this.info().bucketItem);
    }

    public void method_6455(class_1799 bucket) {
        super.method_6455(bucket);
        class_2487 tag = bucket.method_7948();
        tag.method_10569("AbsoluteEggCooldown", this.absoluteEggCooldown);
        tag.method_10569("Age", this.age);
    }

    public void method_35170(class_2487 tag) {
        super.method_35170(tag);
        if (tag.method_10545("AbsoluteEggCooldown")) {
            this.absoluteEggCooldown = tag.method_10550("AbsoluteEggCooldown");
        }
        if (tag.method_10545("Age")) {
            this.setAge(tag.method_10550("Age"));
        }
    }

    @NotNull
    protected class_3414 method_6457() {
        return class_3417.field_14918;
    }

    public boolean method_6109() {
        return (Boolean)this.field_6011.method_12789(BABY);
    }

    public int getAge() {
        return this.age;
    }

    public void setAge(int age) {
        this.age = age;
        this.field_6011.method_12778(BABY, (Object)(age < 0 ? 1 : 0));
    }

    public void method_5674(class_2940<?> key) {
        if (BABY.equals(key)) {
            this.method_18382();
        }
        super.method_5674(key);
    }

    public void method_6091(class_243 travelVector) {
        if (this.method_6034() && this.method_5799()) {
            this.method_5724(this.method_6029(), travelVector);
            this.method_5784(class_1313.field_6308, this.method_18798());
            this.method_18799(this.method_18798().method_1021(0.9));
            if (this.method_5968() == null) {
                this.method_18799(this.method_18798().method_1031(0.0, -0.005, 0.0));
            }
        } else {
            super.method_6091(travelVector);
        }
    }

    protected void method_5958() {
        super.method_5958();
        this.method_5728(this.method_5962().method_6242() >= 1.25);
    }

    public void method_5773() {
        super.method_5773();
        if (!this.field_6002.field_9236) {
            PrehistoricFish closestMate;
            if (this.absoluteEggCooldown > 0) {
                --this.absoluteEggCooldown;
            }
            if (this.method_5799() && this.getAge() >= 0 && this.absoluteEggCooldown <= 0 && (closestMate = this.getClosestMate()) != null) {
                this.absoluteEggCooldown = 48000 + this.field_5974.method_43048(48000);
                closestMate.absoluteEggCooldown = 48000 + this.field_5974.method_43048(48000);
                this.field_6002.method_8649((class_1297)new class_1542(this.field_6002, this.method_23317(), this.method_23318(), this.method_23321(), new class_1799((class_1935)this.info().eggItem)));
            }
        }
    }

    @Nullable
    private PrehistoricFish getClosestMate() {
        List sameTypes = this.field_6002.method_8390(this.getClass(), this.method_5829().method_1009(2.0, 2.0, 2.0), fish -> fish != this && fish.getAge() >= 0);
        double shortestDistance = Double.MAX_VALUE;
        PrehistoricFish other = null;
        for (PrehistoricFish sameType : sameTypes) {
            if (this.method_5858((class_1297)sameType) > shortestDistance) continue;
            other = sameType;
            shortestDistance = this.method_5858((class_1297)other);
        }
        return other;
    }

    @Override
    public class_2487 getDebugTag() {
        return (class_2487)this.field_6011.method_12789(DEBUG);
    }

    @Nullable
    public class_1315 method_5943(class_5425 level, class_1266 difficulty, class_3730 reason, @Nullable class_1315 spawnData, @Nullable class_2487 dataTag) {
        if (spawnData instanceof Prehistoric.PrehistoricGroupData) {
            Prehistoric.PrehistoricGroupData prehistoricGroupData = (Prehistoric.PrehistoricGroupData)spawnData;
            this.setAge(prehistoricGroupData.ageInDays() * 24000);
        } else {
            this.setAge(0);
        }
        return super.method_5943(level, difficulty, reason, spawnData, dataTag);
    }

    @Override
    public Map<AnimationCategory, AnimationHolder> getAnimations() {
        if (this.field_6002.field_9236) {
            return AnimationCategoryLoader.CLIENT.getAnimations(this.animationLocation);
        }
        return AnimationCategoryLoader.SERVER.getAnimations(this.animationLocation);
    }

    @Override
    public Map<String, ? extends AnimationInfo> getAllAnimations() {
        if (this.field_6002.field_9236) {
            return ClientAnimationInfoLoader.INSTANCE.getAnimations(this.animationLocation).animations();
        }
        return this.getServerAnimationInfos();
    }

    @Override
    public AnimationInfo getAnimation(AnimationCategory category) {
        return this.getRandomAnimation(category);
    }

    @Override
    public Map<String, ServerAnimationInfo> getServerAnimationInfos() {
        return ServerAnimationInfoLoader.INSTANCE.getAnimations(this.animationLocation).animations();
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new PausableAnimationController<PrehistoricFish>(this, "Movement/Idle", 4.0f, this.animationLogic::fishPredicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    @Override
    public AnimationLogic<PrehistoricFish> getAnimationLogic() {
        return this.animationLogic;
    }

    @NotNull
    public AnimationInfo nextBeachedAnimation() {
        return this.getAnimation(AnimationCategory.BEACHED);
    }

    @Override
    public void disableCustomAI(byte type, boolean disableAI) {
        this.method_5977(disableAI);
    }
}

