/*
 * Decompiled with CFR 0.152.
 */
package com.github.darkpred.morehitboxes;

import com.github.darkpred.morehitboxes.MoreHitboxesMod;
import com.github.darkpred.morehitboxes.api.HitboxData;
import com.github.darkpred.morehitboxes.internal.HitboxDataLoader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import org.jetbrains.annotations.ApiStatus;

@Mod(value="morehitboxes")
@ApiStatus.Internal
public class ForgeMoreHitboxesMod {
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("morehitboxes", "main"), () -> "1", "1"::equals, "1"::equals);

    public ForgeMoreHitboxesMod() {
        MoreHitboxesMod.init();
        MinecraftForge.EVENT_BUS.addListener(this::onDatapackSyncEvent);
        INSTANCE.registerMessage(0, SyncHitboxDataMessage.class, SyncHitboxDataMessage::write, SyncHitboxDataMessage::new, SyncHitboxDataMessage::handle);
    }

    public void onDatapackSyncEvent(OnDatapackSyncEvent event) {
        if (event.getPlayer() != null) {
            INSTANCE.send(PacketDistributor.PLAYER.with(() -> ((OnDatapackSyncEvent)event).getPlayer()), (Object)new SyncHitboxDataMessage(HitboxDataLoader.HITBOX_DATA.getHitboxData()));
        } else {
            for (ServerPlayer player : event.getPlayerList().m_11314_()) {
                INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SyncHitboxDataMessage(HitboxDataLoader.HITBOX_DATA.getHitboxData()));
            }
        }
    }

    private static class SyncHitboxDataMessage {
        private final Map<ResourceLocation, List<HitboxData>> hitboxes;

        public SyncHitboxDataMessage(FriendlyByteBuf buf) {
            this.hitboxes = buf.m_178374_(HashMap::new, FriendlyByteBuf::m_130281_, HitboxDataLoader::readBuf);
        }

        public SyncHitboxDataMessage(Map<ResourceLocation, List<HitboxData>> hitboxes) {
            this.hitboxes = hitboxes;
        }

        public void write(FriendlyByteBuf buf) {
            HitboxDataLoader.HITBOX_DATA.writeBuf(buf);
        }

        public void handle(Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> HitboxDataLoader.HITBOX_DATA.replaceData(this.hitboxes)));
            ctx.get().setPacketHandled(true);
        }
    }
}

