/*
 * Decompiled with CFR 0.152.
 */
package com.github.darkpred.morehitboxes.internal;

import com.github.darkpred.morehitboxes.api.HitboxData;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class HitboxDataLoader
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().create();
    public static final HitboxDataLoader HITBOX_DATA = new HitboxDataLoader(GSON);
    private ImmutableMap<ResourceLocation, List<HitboxData>> hitboxData = ImmutableMap.of();

    public HitboxDataLoader(Gson gson) {
        super(gson, "hitboxes");
    }

    public List<HitboxData> getHitboxes(ResourceLocation entityLocation) {
        return (List)this.hitboxData.get((Object)entityLocation);
    }

    public Map<ResourceLocation, List<HitboxData>> getHitboxData() {
        return this.hitboxData;
    }

    protected void apply(Map<ResourceLocation, JsonElement> jsons, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profiler) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<ResourceLocation, JsonElement> fileEntry : jsons.entrySet()) {
            JsonElement jsonElement = fileEntry.getValue();
            if (!(jsonElement instanceof JsonObject)) continue;
            JsonObject root = (JsonObject)jsonElement;
            JsonArray elements = GsonHelper.m_13933_((JsonObject)root, (String)"elements");
            ImmutableList.Builder listBuilder = ImmutableList.builder();
            for (JsonElement element : elements) {
                JsonObject elemObject = element.getAsJsonObject();
                double[] pos = new double[3];
                JsonArray posArray = GsonHelper.m_13933_((JsonObject)elemObject, (String)"pos");
                JsonElement refElement = elemObject.get("ref");
                String ref = refElement == null ? "" : refElement.getAsString();
                for (int i = 0; i < pos.length; ++i) {
                    pos[i] = GsonHelper.m_144769_((JsonElement)posArray.get(i), (String)("pos[" + i + "]"));
                }
                if (elemObject.has("is_anchor") && GsonHelper.m_13912_((JsonObject)elemObject, (String)"is_anchor")) {
                    listBuilder.add((Object)new HitboxData(elemObject.get("name").getAsString(), new Vec3(pos[0] / 16.0, pos[1] / 16.0, pos[2] / 16.0), 0.0f, 0.0f, ref, false, true));
                    continue;
                }
                float width = GsonHelper.m_13915_((JsonObject)elemObject, (String)"width") / 16.0f;
                float height = GsonHelper.m_13915_((JsonObject)elemObject, (String)"height") / 16.0f;
                JsonElement attackElement = elemObject.get("is_attack_box");
                boolean isAttack = attackElement != null && attackElement.getAsBoolean();
                listBuilder.add((Object)new HitboxData(elemObject.get("name").getAsString(), new Vec3(pos[0] / 16.0, pos[1] / 16.0, pos[2] / 16.0), width, height, ref, isAttack, false));
            }
            builder.put((Object)fileEntry.getKey(), (Object)listBuilder.build());
        }
        this.hitboxData = builder.build();
    }

    public void replaceData(Map<ResourceLocation, List<HitboxData>> dataMap) {
        this.hitboxData = ImmutableMap.copyOf(dataMap);
    }

    public static List<HitboxData> readBuf(FriendlyByteBuf buf) {
        return buf.m_178366_(HitboxData::readBuf);
    }

    private static void writeBuf(FriendlyByteBuf buf, List<HitboxData> hitboxes) {
        buf.m_178352_(hitboxes, HitboxData::writeBuf);
    }

    public void writeBuf(FriendlyByteBuf buf) {
        buf.m_178355_(this.hitboxData, (buffer, key) -> buf.m_130085_(key), HitboxDataLoader::writeBuf);
    }
}

