/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.block.entity;

import com.github.teamfossilsarcheology.fossil.block.custom_blocks.AnubiteStatueBlock;
import com.github.teamfossilsarcheology.fossil.block.entity.ModBlockEntities;
import com.github.teamfossilsarcheology.fossil.config.FossilConfig;
import com.github.teamfossilsarcheology.fossil.entity.ModEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnubiteStatueBlockEntity
extends BlockEntity {
    private int cooldown;

    public AnubiteStatueBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.ANUBITE_STATUE.get(), blockPos, blockState);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("Cooldown", this.cooldown);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.cooldown = tag.m_128451_("Cooldown");
    }

    @NotNull
    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_183216_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, AnubiteStatueBlockEntity blockEntity) {
        if (FossilConfig.isEnabled("anubiteHasCooldown")) {
            Player player;
            if (blockEntity.cooldown <= 0 && (player = level.m_45924_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 5.0, true)) != null) {
                level.m_46518_(null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5, 5.0f, true, Explosion.BlockInteraction.NONE);
                BlockPos spawnPos = pos.m_142300_((Direction)state.m_61143_((Property)AnubiteStatueBlock.FACING));
                ((EntityType)ModEntities.ANUBITE.get()).m_20592_((ServerLevel)level, null, null, spawnPos, MobSpawnType.EVENT, false, false);
                blockEntity.cooldown = FossilConfig.getInt("anubiteCooldown");
                level.m_46597_(pos, (BlockState)state.m_61124_((Property)AnubiteStatueBlock.LIT, (Comparable)Boolean.valueOf(false)));
            }
        } else {
            Player player = level.m_45924_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 5.0, true);
            if (player != null) {
                level.m_46518_(null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5, 5.0f, true, Explosion.BlockInteraction.NONE);
                BlockPos spawnPos = pos.m_142300_((Direction)state.m_61143_((Property)AnubiteStatueBlock.FACING));
                ((EntityType)ModEntities.ANUBITE.get()).m_20592_((ServerLevel)level, null, null, spawnPos, MobSpawnType.EVENT, false, false);
                level.m_7471_(pos, false);
            }
        }
        if (blockEntity.cooldown > 0) {
            --blockEntity.cooldown;
            if (blockEntity.cooldown == 0) {
                level.m_46597_(pos, (BlockState)state.m_61124_((Property)AnubiteStatueBlock.LIT, (Comparable)Boolean.valueOf(true)));
            }
        }
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, AnubiteStatueBlockEntity blockEntity) {
        if (blockEntity.cooldown > 0) {
            --blockEntity.cooldown;
        }
    }

    public int getCooldown() {
        return this.cooldown;
    }
}

