/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.client;

import com.github.teamfossilsarcheology.fossil.FossilMod;
import com.github.teamfossilsarcheology.fossil.client.ResourceLoader;
import com.google.common.collect.ImmutableMap;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class DinopediaBioLoader
extends ResourceLoader<Map<String, Map<String, String>>> {
    public static final DinopediaBioLoader INSTANCE = new DinopediaBioLoader();
    private static final Logger LOGGER = LogUtils.getLogger();
    private ImmutableMap<String, String> englishFallback = ImmutableMap.of();
    private ImmutableMap<String, String> dinopediaTexts = ImmutableMap.of();

    public DinopediaBioLoader() {
        super(PackType.CLIENT_RESOURCES, "fossil", "dinopedia", ".txt");
    }

    @NotNull
    protected Map<String, Map<String, String>> prepare(ResourceManager resourceManager, ProfilerFiller profiler) {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        ImmutableMap.Builder selectedLangBuilder = ImmutableMap.builder();
        ImmutableMap.Builder fallbackLangBuilder = ImmutableMap.builder();
        int i = this.directory.length() + 1;
        String selectedLang = Minecraft.m_91087_().f_91066_.f_92075_;
        for (ResourceLocation resourceLocation : this.listResources(resourceManager)) {
            String path = resourceLocation.m_135815_();
            ResourceLocation locationWithLang = new ResourceLocation(resourceLocation.m_135827_(), path.substring(i, path.length() - this.suffix.length()));
            try {
                String[] dinoInfo = locationWithLang.m_135815_().split("/");
                if ("en_us".equals(dinoInfo[0])) {
                    fallbackLangBuilder.put((Object)dinoInfo[1], (Object)this.readFile(resourceManager, resourceLocation));
                }
                if (!selectedLang.equals(dinoInfo[0])) continue;
                selectedLangBuilder.put((Object)dinoInfo[1], (Object)this.readFile(resourceManager, resourceLocation));
            }
            catch (IOException | IllegalArgumentException exception) {
                LOGGER.error("Couldn't parse data file {} from {}", new Object[]{locationWithLang, resourceLocation, exception});
            }
        }
        mapBuilder.put((Object)selectedLang, (Object)selectedLangBuilder.build());
        if (!selectedLang.equals("en_us")) {
            mapBuilder.put((Object)"en_us", (Object)fallbackLangBuilder.build());
        }
        return mapBuilder.build();
    }

    /*
     * Exception decompiling
     */
    private String readFile(ResourceManager resourceManager, ResourceLocation resourceLocation) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void apply(Map<String, Map<String, String>> files, ResourceManager resourceManager, ProfilerFiller profiler) {
        ImmutableMap.Builder selectedBuilder = ImmutableMap.builder();
        ImmutableMap.Builder fallbackBuilder = ImmutableMap.builder();
        this.dinopediaTexts = selectedBuilder.putAll(files.get(Minecraft.m_91087_().f_91066_.f_92075_)).build();
        this.englishFallback = fallbackBuilder.putAll(files.get("en_us")).build();
        FossilMod.LOGGER.info("Loaded {} dinopedia texts for {}", (Object)this.dinopediaTexts.size(), (Object)Minecraft.m_91087_().f_91066_.f_92075_);
        FossilMod.LOGGER.info("Loaded {} fallback dinopedia texts for {}", (Object)this.englishFallback.size(), (Object)"en_us");
    }

    public boolean hasFallback(String entityName) {
        return this.englishFallback.containsKey((Object)entityName);
    }

    public String getDinopediaBio(String entityName) {
        if (this.dinopediaTexts.containsKey((Object)entityName)) {
            return (String)this.dinopediaTexts.get((Object)entityName);
        }
        if (this.englishFallback.containsKey((Object)entityName)) {
            return (String)this.englishFallback.get((Object)entityName);
        }
        return "No bio found. This should not have happened";
    }
}

