/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.client.gui.debug;

import com.github.teamfossilsarcheology.fossil.capabilities.ModCapabilities;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.AnimationTab;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.DebugSlider;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.DebugTab;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.EggTab;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.EmbryoTab;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.InfoTab;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.InstructionTab;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.SkeletonEditTab;
import com.github.teamfossilsarcheology.fossil.entity.PrehistoricSkeleton;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.DinosaurEgg;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.Prehistoric;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricAnimatable;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricDebug;
import com.github.teamfossilsarcheology.fossil.network.MessageHandler;
import com.github.teamfossilsarcheology.fossil.network.debug.C2SDisableAIMessage;
import com.github.teamfossilsarcheology.fossil.network.debug.C2SDiscardMessage;
import com.github.teamfossilsarcheology.fossil.network.debug.C2SSlowMessage;
import com.github.teamfossilsarcheology.fossil.network.debug.C2SStructureMessage;
import com.github.teamfossilsarcheology.fossil.network.debug.C2STameMessage;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.CycleOption;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class DebugScreen
extends Screen {
    private static final List<PathInfo> pathTargets = new ArrayList<PathInfo>();
    public static CycleButton<Boolean> disableAI;
    public static boolean showPaths;
    private static PathInfo currentVision;
    @Nullable
    public static Entity entity;
    private final List<DebugTab<? extends Entity>> tabs = new ArrayList<DebugTab<? extends Entity>>();
    private static int tabShift;
    private DebugTab<? extends Entity> currentTab;
    private double speedMod = 0.5;
    public static int rulerMode;

    public DebugScreen(@Nullable Entity newEntity) {
        super((Component)new TextComponent("Debug Screen"));
        entity = newEntity;
        if (newEntity == null || !newEntity.m_6084_()) {
            entity = null;
        }
    }

    @Nullable
    public static Entity getHitResult(Minecraft mc) {
        Entity camera = mc.m_91288_();
        Vec3 view = camera.m_20252_(1.0f);
        double range = 30.0;
        Vec3 end = camera.m_146892_().m_82520_(view.f_82479_ * range, view.f_82480_ * range, view.f_82481_ * range);
        AABB aabb = camera.m_142469_().m_82369_(view.m_82490_(range)).m_82400_(1.0);
        EntityHitResult entityHitResult = ProjectileUtil.m_37287_((Entity)camera, (Vec3)camera.m_146892_(), (Vec3)end, (AABB)aabb, Entity::m_6087_, (double)(range * range));
        return entityHitResult != null ? entityHitResult.m_82443_() : null;
    }

    public static void showPath(Player player, List<BlockPos> targets, List<BlockState> blocks, boolean below) {
        if (showPaths) {
            for (int i = 0; i < targets.size(); ++i) {
                if (below) {
                    pathTargets.add(new PathInfo(targets.get(i), player.f_19853_.m_8055_(targets.get(i).m_7495_()), true));
                    player.f_19853_.m_7731_(targets.get(i).m_7495_(), blocks.get(i), 3);
                    continue;
                }
                pathTargets.add(new PathInfo(targets.get(i), player.f_19853_.m_8055_(targets.get(i)), false));
                player.f_19853_.m_7731_(targets.get(i), blocks.get(i), 3);
            }
        }
    }

    public static void showVision(Player player, BlockPos target, BlockState block) {
        if (currentVision != null) {
            player.f_19853_.m_7731_(DebugScreen.currentVision.targetPos, DebugScreen.currentVision.blockState, 3);
        }
        currentVision = new PathInfo(target, player.f_19853_.m_8055_(target), false);
        player.f_19853_.m_7731_(target, block, 3);
    }

    public static void clearPaths() {
        for (int i = pathTargets.size() - 1; i >= 0; --i) {
            boolean below = DebugScreen.pathTargets.get((int)i).below;
            Minecraft.m_91087_().f_91073_.m_7731_(below ? DebugScreen.pathTargets.get((int)i).targetPos.m_7495_() : DebugScreen.pathTargets.get((int)i).targetPos, DebugScreen.pathTargets.get((int)i).blockState, 3);
        }
        pathTargets.clear();
        if (currentVision != null) {
            Minecraft.m_91087_().f_91073_.m_7731_(DebugScreen.currentVision.targetPos, DebugScreen.currentVision.blockState, 3);
        }
    }

    public boolean m_7043_() {
        return false;
    }

    protected void m_169413_() {
        super.m_169413_();
        this.tabs.clear();
    }

    protected void m_7856_() {
        Mob mob;
        Entity entity;
        Animal animal;
        Prehistoric prehistoric;
        CycleButton.Builder builder = CycleButton.m_168919_();
        Entity entity2 = DebugScreen.entity;
        if (entity2 instanceof Prehistoric) {
            prehistoric = (Prehistoric)entity2;
            this.tabs.add(new InfoTab(this, prehistoric));
        } else if (DebugScreen.entity instanceof TamableAnimal || DebugScreen.entity instanceof AbstractHorse) {
            this.m_142416_((GuiEventListener)new Button(275, 55, 50, 20, (Component)new TextComponent("Tame"), button -> MessageHandler.DEBUG_CHANNEL.sendToServer((Object)new C2STameMessage(entity.m_142049_()))));
        }
        entity2 = DebugScreen.entity;
        if (entity2 instanceof PrehistoricSkeleton) {
            PrehistoricSkeleton skeleton = (PrehistoricSkeleton)entity2;
            this.tabs.add(new SkeletonEditTab(this, skeleton));
        }
        if ((entity2 = DebugScreen.entity) instanceof DinosaurEgg) {
            DinosaurEgg egg = (DinosaurEgg)entity2;
            this.tabs.add(new EggTab(this, egg));
        }
        if ((entity2 = DebugScreen.entity) instanceof Animal && ModCapabilities.hasEmbryo(animal = (Animal)entity2)) {
            this.tabs.add(new EmbryoTab(this, animal));
        }
        if ((entity = DebugScreen.entity) instanceof Mob) {
            mob = (Mob)entity;
            entity = DebugScreen.entity;
            if (entity instanceof PrehistoricDebug) {
                PrehistoricDebug prehistoric2 = (PrehistoricDebug)entity;
                builder.m_168948_((Object)mob.m_21525_());
                disableAI = builder.m_168936_(this.f_96543_ / 2 - 225, this.f_96544_ - 95, 130, 20, (Component)new TextComponent("Disable AI"), (cycleButton, object) -> MessageHandler.DEBUG_CHANNEL.sendToServer((Object)new C2SDisableAIMessage(entity.m_142049_(), (Boolean)cycleButton.m_168883_(), 0)));
                this.m_142416_((GuiEventListener)disableAI);
                builder.m_168948_((Object)prehistoric2.getDebugTag().m_128471_("disableGoalAI"));
                this.m_142416_((GuiEventListener)builder.m_168936_(this.f_96543_ / 2 - 225, this.f_96544_ - 70, 130, 20, (Component)new TextComponent("Disable Goal AI"), (cycleButton, object) -> MessageHandler.DEBUG_CHANNEL.sendToServer((Object)new C2SDisableAIMessage(entity.m_142049_(), (Boolean)cycleButton.m_168883_(), 1))));
                builder.m_168948_((Object)prehistoric2.getDebugTag().m_128471_("disableMoveAI"));
                this.m_142416_((GuiEventListener)builder.m_168936_(this.f_96543_ / 2 - 225, this.f_96544_ - 45, 130, 20, (Component)new TextComponent("Disable Move AI"), (cycleButton, object) -> MessageHandler.DEBUG_CHANNEL.sendToServer((Object)new C2SDisableAIMessage(entity.m_142049_(), (Boolean)cycleButton.m_168883_(), 2))));
                builder.m_168948_((Object)prehistoric2.getDebugTag().m_128471_("disableLookAI"));
                this.m_142416_((GuiEventListener)builder.m_168936_(this.f_96543_ / 2 - 225, this.f_96544_ - 22, 130, 20, (Component)new TextComponent("Disable Look AI"), (cycleButton, object) -> MessageHandler.DEBUG_CHANNEL.sendToServer((Object)new C2SDisableAIMessage(entity.m_142049_(), (Boolean)cycleButton.m_168883_(), 3))));
            }
        }
        if ((entity2 = DebugScreen.entity) instanceof Mob && (mob = (Mob)entity2) instanceof PrehistoricAnimatable) {
            this.tabs.add(new AnimationTab<Mob>(this, mob));
        }
        if ((entity2 = DebugScreen.entity) instanceof Prehistoric) {
            prehistoric = (Prehistoric)entity2;
            this.tabs.add(new InstructionTab(this, prehistoric));
        }
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 91, this.f_96544_ - 95, 91, 20, (Component)new TextComponent("Ruler"), button -> {
            rulerMode = 1;
            this.m_7379_();
            if (this.currentTab != null) {
                this.currentTab.onClose();
            }
        }, (button, poseStack, i, j) -> this.m_96602_(poseStack, (Component)new TextComponent("Measure length. Left click for 1st pos. Right click for 2nd pos"), i, j)));
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 91, this.f_96544_ - 70, 91, 20, (Component)new TextComponent("Discard All"), button -> {
            MessageHandler.DEBUG_CHANNEL.sendToServer((Object)new C2SDiscardMessage(-1));
            if (this.currentTab != null) {
                this.currentTab.onClose();
            }
        }, (button, poseStack, i, j) -> this.m_96602_(poseStack, (Component)new TextComponent("Kills all non-player entities"), i, j)));
        if (DebugScreen.entity != null) {
            this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2, this.f_96544_ - 70, 91, 20, (Component)new TextComponent("Discard This"), button -> {
                MessageHandler.DEBUG_CHANNEL.sendToServer((Object)new C2SDiscardMessage(entity.m_142049_()));
                if (this.currentTab != null) {
                    this.currentTab.onClose();
                }
            }));
        }
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 + 95, this.f_96544_ - 70, 59, 20, (Component)new TextComponent("Slow Self"), button -> MessageHandler.DEBUG_CHANNEL.sendToServer((Object)new C2SSlowMessage(this.speedMod)), (button, poseStack, i, j) -> this.m_96602_(poseStack, (Component)new TextComponent("If clicked multiply your walkspeed by the value on the right"), i, j)));
        this.m_142416_((GuiEventListener)new DebugSlider(this.f_96543_ / 2 + 154, this.f_96544_ - 70, 65, 20, (Component)new TextComponent("Mod: "), (Component)new TextComponent(""), 0.1, 1.0, this.speedMod, 0.05, 2, true){

            @Override
            protected void m_5697_() {
                DebugScreen.this.speedMod = this.stepSize * (double)Math.round(Mth.m_14139_((double)this.f_93577_, (double)this.minValue, (double)this.maxValue) / this.stepSize);
            }
        });
        builder.m_168948_((Object)showPaths);
        this.m_142416_((GuiEventListener)builder.m_168936_(this.f_96543_ / 2 - 91, this.f_96544_ - 45, 91, 20, (Component)new TextComponent("Show Paths"), (cycleButton, object) -> {
            showPaths = (Boolean)cycleButton.m_168883_();
        }));
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2, this.f_96544_ - 45, 91, 20, (Component)new TextComponent("Clear Paths"), button -> DebugScreen.clearPaths(), (button, poseStack, i, j) -> this.m_96602_(poseStack, (Component)new TextComponent("Mostly unused"), i, j)));
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 + 95, this.f_96544_ - 45, 125, 20, (Component)new TextComponent("Spawn Test Structure"), button -> MessageHandler.DEBUG_CHANNEL.sendToServer((Object)new C2SStructureMessage(true)), (button, poseStack, i, j) -> this.m_96602_(poseStack, (Component)new TextComponent("Spawns a big structure at 0,79,0 with every mob"), i, j)));
        if (!this.tabs.isEmpty()) {
            this.tabs.forEach(tab -> tab.init(this.f_96543_, this.f_96544_));
            Collections.rotate(this.tabs, -tabShift);
            this.currentTab = this.tabs.get(0);
            this.m_142416_((GuiEventListener)CycleOption.m_167747_((String)"Tab", () -> this.tabs, debugTab -> new TextComponent(((Object)debugTab).getClass().getSimpleName()), options -> this.currentTab, (options, option, tab) -> {
                tab.onOpen();
                this.m_7787_((GuiEventListener)tab);
                this.m_169411_(this.currentTab);
                this.currentTab.onClose();
                this.currentTab = tab;
            }).m_7496_(Minecraft.m_91087_().f_91066_, this.f_96543_ / 2, 60, 100));
            this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2, 35, 100, 20, (Component)new TextComponent("Set default"), button -> tabShift += this.tabs.indexOf(this.currentTab), (button, poseStack, i, j) -> this.m_96602_(poseStack, (Component)new TextComponent("Sets the current tab as default tab when opening screen"), i, j)));
            this.m_7787_(this.currentTab);
            this.currentTab.onOpen();
        }
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        Entity entity;
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
        if (this.currentTab != null) {
            this.currentTab.render(poseStack, mouseX, mouseY, partialTick);
        }
        if ((entity = DebugScreen.entity) instanceof Sheep) {
            Sheep sheep = (Sheep)entity;
            DebugScreen.m_93243_((PoseStack)poseStack, (Font)this.f_96541_.f_91062_, (Component)new TextComponent("yRot: " + sheep.m_146908_()), (int)275, (int)15, (int)0xFFFFFF);
            DebugScreen.m_93243_((PoseStack)poseStack, (Font)this.f_96541_.f_91062_, (Component)new TextComponent("yRotHead: " + sheep.m_6080_()), (int)275, (int)35, (int)0xFFFFFF);
        }
    }

    static {
        tabShift = 0;
    }

    record PathInfo(BlockPos targetPos, BlockState blockState, boolean below) {
    }
}

